/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.cryptomator.cryptofs.DelegatingBasicFileAttributes;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.api.Cryptor;

class CryptoBasicFileAttributes
implements DelegatingBasicFileAttributes {
    private final BasicFileAttributes delegate;
    protected final Path ciphertextPath;
    private final Cryptor cryptor;

    public CryptoBasicFileAttributes(BasicFileAttributes basicFileAttributes, Path path, Cryptor cryptor) {
        this.delegate = basicFileAttributes;
        this.ciphertextPath = path;
        this.cryptor = cryptor;
    }

    @Override
    public BasicFileAttributes getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isRegularFile() {
        return this.getDelegate().isRegularFile();
    }

    @Override
    public boolean isDirectory() {
        return this.getDelegate().isDirectory();
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public long size() {
        if (this.isRegularFile()) {
            return Cryptors.cleartextSize(this.getDelegate().size() - (long)this.cryptor.fileHeaderCryptor().headerSize(), this.cryptor);
        }
        return -1L;
    }
}

