/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.InputLimit;
import org.apache.http.client.cache.Resource;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.impl.client.cache.HeapResource;
import org.apache.http.impl.client.cache.IOUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HeapResourceFactory
implements ResourceFactory {
    @Override
    public Resource generate(String string, InputStream inputStream, InputLimit inputLimit) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            if (inputLimit == null || (l += (long)n) <= inputLimit.getValue()) continue;
            inputLimit.reached();
            break;
        }
        return this.createResource(byteArrayOutputStream.toByteArray());
    }

    @Override
    public Resource copy(String string, Resource resource) throws IOException {
        byte[] byArray;
        if (resource instanceof HeapResource) {
            byArray = ((HeapResource)resource).getByteArray();
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copyAndClose(resource.getInputStream(), byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        }
        return this.createResource(byArray);
    }

    Resource createResource(byte[] byArray) {
        return new HeapResource(byArray);
    }
}

