/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.impl.client.cache.AsynchronousValidationRequest;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.SchedulingStrategy;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ExponentialBackOffSchedulingStrategy
implements SchedulingStrategy {
    public static final long DEFAULT_BACK_OFF_RATE = 10L;
    public static final long DEFAULT_INITIAL_EXPIRY_IN_MILLIS = TimeUnit.SECONDS.toMillis(6L);
    public static final long DEFAULT_MAX_EXPIRY_IN_MILLIS = TimeUnit.SECONDS.toMillis(86400L);
    private final long backOffRate;
    private final long initialExpiryInMillis;
    private final long maxExpiryInMillis;
    private final ScheduledExecutorService executor;

    public ExponentialBackOffSchedulingStrategy(CacheConfig cacheConfig) {
        this(cacheConfig, 10L, DEFAULT_INITIAL_EXPIRY_IN_MILLIS, DEFAULT_MAX_EXPIRY_IN_MILLIS);
    }

    public ExponentialBackOffSchedulingStrategy(CacheConfig cacheConfig, long l, long l2, long l3) {
        this(ExponentialBackOffSchedulingStrategy.createThreadPoolFromCacheConfig(cacheConfig), l, l2, l3);
    }

    private static ScheduledThreadPoolExecutor createThreadPoolFromCacheConfig(CacheConfig cacheConfig) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(cacheConfig.getAsynchronousWorkersMax());
        scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return scheduledThreadPoolExecutor;
    }

    ExponentialBackOffSchedulingStrategy(ScheduledExecutorService scheduledExecutorService, long l, long l2, long l3) {
        this.executor = Args.notNull(scheduledExecutorService, "Executor");
        this.backOffRate = Args.notNegative(l, "BackOffRate");
        this.initialExpiryInMillis = Args.notNegative(l2, "InitialExpiryInMillis");
        this.maxExpiryInMillis = Args.notNegative(l3, "MaxExpiryInMillis");
    }

    @Override
    public void schedule(AsynchronousValidationRequest asynchronousValidationRequest) {
        Args.notNull(asynchronousValidationRequest, "RevalidationRequest");
        int n = asynchronousValidationRequest.getConsecutiveFailedAttempts();
        long l = this.calculateDelayInMillis(n);
        this.executor.schedule(asynchronousValidationRequest, l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    public long getBackOffRate() {
        return this.backOffRate;
    }

    public long getInitialExpiryInMillis() {
        return this.initialExpiryInMillis;
    }

    public long getMaxExpiryInMillis() {
        return this.maxExpiryInMillis;
    }

    protected long calculateDelayInMillis(int n) {
        if (n > 0) {
            long l = (long)((double)this.initialExpiryInMillis * Math.pow(this.backOffRate, n - 1));
            return Math.min(l, this.maxExpiryInMillis);
        }
        return 0L;
    }

    @Deprecated
    protected static <T> T checkNotNull(String string, T t) {
        if (t == null) {
            throw new IllegalArgumentException(string + " may not be null");
        }
        return t;
    }

    @Deprecated
    protected static long checkNotNegative(String string, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(string + " may not be negative");
        }
        return l;
    }
}

