/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.http.client.cache.HttpCacheInvalidator;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.AsynchronousValidator;
import org.apache.http.impl.client.cache.BasicHttpCache;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CacheInvalidator;
import org.apache.http.impl.client.cache.CacheKeyGenerator;
import org.apache.http.impl.client.cache.CachingExec;
import org.apache.http.impl.client.cache.FileResourceFactory;
import org.apache.http.impl.client.cache.HeapResourceFactory;
import org.apache.http.impl.client.cache.ImmediateSchedulingStrategy;
import org.apache.http.impl.client.cache.ManagedHttpCacheStorage;
import org.apache.http.impl.client.cache.SchedulingStrategy;
import org.apache.http.impl.execchain.ClientExecChain;

public class CachingHttpClientBuilder
extends HttpClientBuilder {
    private ResourceFactory resourceFactory;
    private HttpCacheStorage storage;
    private File cacheDir;
    private CacheConfig cacheConfig;
    private SchedulingStrategy schedulingStrategy;
    private HttpCacheInvalidator httpCacheInvalidator;
    private boolean deleteCache = true;

    public static CachingHttpClientBuilder create() {
        return new CachingHttpClientBuilder();
    }

    protected CachingHttpClientBuilder() {
    }

    public final CachingHttpClientBuilder setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
        return this;
    }

    public final CachingHttpClientBuilder setHttpCacheStorage(HttpCacheStorage httpCacheStorage) {
        this.storage = httpCacheStorage;
        return this;
    }

    public final CachingHttpClientBuilder setCacheDir(File file) {
        this.cacheDir = file;
        return this;
    }

    public final CachingHttpClientBuilder setCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig = cacheConfig;
        return this;
    }

    public final CachingHttpClientBuilder setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
        return this;
    }

    public final CachingHttpClientBuilder setHttpCacheInvalidator(HttpCacheInvalidator httpCacheInvalidator) {
        this.httpCacheInvalidator = httpCacheInvalidator;
        return this;
    }

    public CachingHttpClientBuilder setDeleteCache(boolean bl) {
        this.deleteCache = bl;
        return this;
    }

    @Override
    protected ClientExecChain decorateMainExec(ClientExecChain clientExecChain) {
        Closeable closeable;
        Object object;
        CacheConfig cacheConfig = this.cacheConfig != null ? this.cacheConfig : CacheConfig.DEFAULT;
        ResourceFactory resourceFactory = this.resourceFactory;
        if (resourceFactory == null) {
            resourceFactory = this.cacheDir == null ? new HeapResourceFactory() : new FileResourceFactory(this.cacheDir);
        }
        if ((object = this.storage) == null) {
            if (this.cacheDir == null) {
                object = new BasicHttpCacheStorage(cacheConfig);
            } else {
                closeable = new ManagedHttpCacheStorage(cacheConfig);
                if (this.deleteCache) {
                    this.addCloseable(new Closeable((ManagedHttpCacheStorage)closeable){
                        final /* synthetic */ ManagedHttpCacheStorage val$managedStorage;
                        {
                            this.val$managedStorage = managedHttpCacheStorage;
                        }

                        @Override
                        public void close() throws IOException {
                            this.val$managedStorage.shutdown();
                        }
                    });
                } else {
                    this.addCloseable(closeable);
                }
                object = closeable;
            }
        }
        closeable = this.createAsynchronousRevalidator(cacheConfig);
        CacheKeyGenerator cacheKeyGenerator = new CacheKeyGenerator();
        HttpCacheInvalidator httpCacheInvalidator = this.httpCacheInvalidator;
        if (httpCacheInvalidator == null) {
            httpCacheInvalidator = new CacheInvalidator(cacheKeyGenerator, (HttpCacheStorage)object);
        }
        return new CachingExec(clientExecChain, new BasicHttpCache(resourceFactory, (HttpCacheStorage)object, cacheConfig, cacheKeyGenerator, httpCacheInvalidator), cacheConfig, (AsynchronousValidator)closeable);
    }

    private AsynchronousValidator createAsynchronousRevalidator(CacheConfig cacheConfig) {
        if (cacheConfig.getAsynchronousWorkersMax() > 0) {
            SchedulingStrategy schedulingStrategy = this.createSchedulingStrategy(cacheConfig);
            AsynchronousValidator asynchronousValidator = new AsynchronousValidator(schedulingStrategy);
            this.addCloseable(asynchronousValidator);
            return asynchronousValidator;
        }
        return null;
    }

    private SchedulingStrategy createSchedulingStrategy(CacheConfig cacheConfig) {
        return this.schedulingStrategy != null ? this.schedulingStrategy : new ImmediateSchedulingStrategy(cacheConfig);
    }
}

