/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.ContentResponseHandler;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private final HttpResponse response;
    private boolean consumed;

    Response(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    private void assertNotConsumed() {
        if (this.consumed) {
            throw new IllegalStateException("Response content has been already consumed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        if (this.consumed) {
            return;
        }
        try {
            HttpEntity httpEntity = this.response.getEntity();
            InputStream inputStream = httpEntity.getContent();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.consumed = true;
        }
    }

    public void discardContent() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T handleResponse(ResponseHandler<T> responseHandler) throws ClientProtocolException, IOException {
        this.assertNotConsumed();
        try {
            T t = responseHandler.handleResponse(this.response);
            return t;
        }
        finally {
            this.dispose();
        }
    }

    public Content returnContent() throws ClientProtocolException, IOException {
        return this.handleResponse(new ContentResponseHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse returnResponse() throws IOException {
        this.assertNotConsumed();
        try {
            Object object;
            HttpEntity httpEntity = this.response.getEntity();
            if (httpEntity != null) {
                object = new ByteArrayEntity(EntityUtils.toByteArray(httpEntity));
                ContentType contentType = ContentType.getOrDefault(httpEntity);
                ((AbstractHttpEntity)object).setContentType(contentType.toString());
                this.response.setEntity((HttpEntity)object);
            }
            object = this.response;
            return object;
        }
        finally {
            this.consumed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContent(File file) throws IOException {
        this.assertNotConsumed();
        StatusLine statusLine = this.response.getStatusLine();
        if (statusLine.getStatusCode() >= 300) {
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            HttpEntity httpEntity = this.response.getEntity();
            if (httpEntity != null) {
                httpEntity.writeTo(fileOutputStream);
            }
        }
        finally {
            this.consumed = true;
            fileOutputStream.close();
        }
    }
}

