/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_ARG_NAME = "arg";
    public int defaultWidth = 74;
    public int defaultLeftPad = 1;
    public int defaultDescPad = 3;
    public String defaultSyntaxPrefix = "usage: ";
    public String defaultNewLine = System.getProperty("line.separator");
    public String defaultOptPrefix = "-";
    public String defaultLongOptPrefix = "--";
    public String defaultArgName = "arg";

    public void printHelp(String string, Options options) {
        this.printHelp(this.defaultWidth, string, null, options, null, false);
    }

    public void printHelp(String string, Options options, boolean bl) {
        this.printHelp(this.defaultWidth, string, null, options, null, bl);
    }

    public void printHelp(String string, String string2, Options options, String string3) {
        this.printHelp(string, string2, options, string3, false);
    }

    public void printHelp(String string, String string2, Options options, String string3, boolean bl) {
        this.printHelp(this.defaultWidth, string, string2, options, string3, bl);
    }

    public void printHelp(int n, String string, String string2, Options options, String string3) {
        this.printHelp(n, string, string2, options, string3, false);
    }

    public void printHelp(int n, String string, String string2, Options options, String string3, boolean bl) {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.printHelp(printWriter, n, string, string2, options, this.defaultLeftPad, this.defaultDescPad, string3, bl);
        printWriter.flush();
    }

    public void printHelp(PrintWriter printWriter, int n, String string, String string2, Options options, int n2, int n3, String string3) throws IllegalArgumentException {
        this.printHelp(printWriter, n, string, string2, options, n2, n3, string3, false);
    }

    public void printHelp(PrintWriter printWriter, int n, String string, String string2, Options options, int n2, int n3, String string3, boolean bl) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (bl) {
            this.printUsage(printWriter, n, string, options);
        } else {
            this.printUsage(printWriter, n, string);
        }
        if (string2 != null && string2.trim().length() > 0) {
            this.printWrapped(printWriter, n, string2);
        }
        this.printOptions(printWriter, n, options, n2, n3);
        if (string3 != null && string3.trim().length() > 0) {
            this.printWrapped(printWriter, n, string3);
        }
    }

    public void printUsage(PrintWriter printWriter, int n, String string, Options options) {
        StringBuffer stringBuffer = new StringBuffer(this.defaultSyntaxPrefix).append(string).append(" ");
        ArrayList<OptionGroup> arrayList = new ArrayList<OptionGroup>();
        Iterator iterator = options.getOptions().iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            OptionGroup optionGroup = options.getOptionGroup(option);
            if (optionGroup != null && !arrayList.contains(optionGroup)) {
                arrayList.add(optionGroup);
                Collection collection = optionGroup.getNames();
                stringBuffer.append("[");
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append(iterator2.next());
                    if (!iterator2.hasNext()) continue;
                    stringBuffer.append(" | ");
                }
                stringBuffer.append("]");
                continue;
            }
            if (!option.isRequired()) {
                stringBuffer.append("[");
            }
            if (!" ".equals(option.getOpt())) {
                stringBuffer.append(DEFAULT_OPT_PREFIX).append(option.getOpt());
            } else {
                stringBuffer.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongOpt());
            }
            if (option.hasArg()) {
                stringBuffer.append(" ");
            }
            if (option.hasArg()) {
                stringBuffer.append(option.getArgName());
            }
            if (!option.isRequired()) {
                stringBuffer.append("]");
            }
            stringBuffer.append(" ");
        }
        this.printWrapped(printWriter, n, stringBuffer.toString().indexOf(32) + 1, stringBuffer.toString());
    }

    public void printUsage(PrintWriter printWriter, int n, String string) {
        int n2 = string.indexOf(32) + 1;
        this.printWrapped(printWriter, n, this.defaultSyntaxPrefix.length() + n2, this.defaultSyntaxPrefix + string);
    }

    public void printOptions(PrintWriter printWriter, int n, Options options, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        this.renderOptions(stringBuffer, n, options, n2, n3);
        printWriter.println(stringBuffer.toString());
    }

    public void printWrapped(PrintWriter printWriter, int n, String string) {
        this.printWrapped(printWriter, n, 0, string);
    }

    public void printWrapped(PrintWriter printWriter, int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        this.renderWrappedText(stringBuffer, n, n2, string);
        printWriter.println(stringBuffer.toString());
    }

    protected StringBuffer renderOptions(StringBuffer stringBuffer, int n, Options options, int n2, int n3) {
        StringBuffer stringBuffer2;
        Option option;
        String string = this.createPadding(n2);
        String string2 = this.createPadding(n3);
        int n4 = 0;
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        List list = options.helpOptions();
        Collections.sort(list, new StringBufferComparator());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            option = (Option)iterator.next();
            stringBuffer2 = new StringBuffer(8);
            if (option.getOpt().equals(" ")) {
                stringBuffer2.append(string).append("   " + this.defaultLongOptPrefix).append(option.getLongOpt());
            } else {
                stringBuffer2.append(string).append(this.defaultOptPrefix).append(option.getOpt());
                if (option.hasLongOpt()) {
                    stringBuffer2.append(',').append(this.defaultLongOptPrefix).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                if (option.hasArgName()) {
                    stringBuffer2.append(" <").append(option.getArgName()).append('>');
                } else {
                    stringBuffer2.append(' ');
                }
            }
            arrayList.add(stringBuffer2);
            int n5 = n4 = stringBuffer2.length() > n4 ? stringBuffer2.length() : n4;
        }
        int n6 = 0;
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            option = (Option)iterator2.next();
            if ((stringBuffer2 = new StringBuffer(arrayList.get(n6++).toString())).length() < n4) {
                stringBuffer2.append(this.createPadding(n4 - stringBuffer2.length()));
            }
            stringBuffer2.append(string2);
            int n7 = n4 + n3;
            this.renderWrappedText(stringBuffer, n, n7, stringBuffer2.append(option.getDescription()).toString());
            if (!iterator2.hasNext()) continue;
            stringBuffer.append(this.defaultNewLine);
        }
        return stringBuffer;
    }

    protected StringBuffer renderWrappedText(StringBuffer stringBuffer, int n, int n2, String string) {
        int n3 = this.findWrapPos(string, n, 0);
        if (n3 == -1) {
            stringBuffer.append(this.rtrim(string));
            return stringBuffer;
        }
        stringBuffer.append(this.rtrim(string.substring(0, n3))).append(this.defaultNewLine);
        String string2 = this.createPadding(n2);
        while (true) {
            if ((n3 = this.findWrapPos(string = string2 + string.substring(n3).trim(), n, n2)) == -1) {
                stringBuffer.append(string);
                return stringBuffer;
            }
            stringBuffer.append(this.rtrim(string.substring(0, n3))).append(this.defaultNewLine);
        }
    }

    protected int findWrapPos(String string, int n, int n2) {
        char c;
        int n3 = -1;
        n3 = string.indexOf(10, n2);
        if (n3 != -1 && n3 <= n || (n3 = string.indexOf(9, n2)) != -1 && n3 <= n) {
            return n3;
        }
        if (n2 + n >= string.length()) {
            return -1;
        }
        n3 = n2 + n;
        while (n3 >= n2 && (c = string.charAt(n3)) != ' ' && c != '\n' && c != '\r') {
            --n3;
        }
        if (n3 > n2) {
            return n3;
        }
        n3 = n2 + n;
        while (n3 <= string.length() && (c = string.charAt(n3)) != ' ' && c != '\n' && c != '\r') {
            ++n3;
        }
        return n3 == string.length() ? -1 : n3;
    }

    protected String createPadding(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected String rtrim(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.length();
        while (n >= 0 && Character.isWhitespace(string.charAt(n - 1))) {
            --n;
        }
        return string.substring(0, n);
    }

    private static class StringBufferComparator
    implements Comparator {
        private StringBufferComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = this.stripPrefix(object.toString());
            String string2 = this.stripPrefix(object2.toString());
            return string.compareTo(string2);
        }

        private String stripPrefix(String string) {
            int n = string.lastIndexOf(45);
            if (n == -1) {
                n = 0;
            }
            return string.substring(n);
        }
    }
}

