/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.win32;

import java.util.Hashtable;
import net.contentobjects.jnotify.IJNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import net.contentobjects.jnotify.Util;
import net.contentobjects.jnotify.win32.IWin32NotifyListener;
import net.contentobjects.jnotify.win32.JNotify_win32;

public class JNotifyAdapterWin32
implements IJNotify {
    private Hashtable<Integer, WatchData> _id2Data;

    public JNotifyAdapterWin32() {
        JNotify_win32.setNotifyListener(new IWin32NotifyListener(){

            @Override
            public void notifyChange(int n, int n2, String string, String string2) {
                JNotifyAdapterWin32.this.notifyChangeEvent(n, n2, string, string2);
            }
        });
        this._id2Data = new Hashtable();
    }

    @Override
    public int addWatch(String string, int n, boolean bl, JNotifyListener jNotifyListener) throws JNotifyException {
        int n2 = JNotify_win32.addWatch(string, 383L, bl);
        this._id2Data.put(n2, new WatchData(n2, n, jNotifyListener));
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWatch(int n) throws JNotifyException {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            if (this._id2Data.containsKey(n)) {
                this._id2Data.remove(n);
                JNotify_win32.removeWatch(n);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyChangeEvent(int n, int n2, String string, String string2) {
        Hashtable<Integer, WatchData> hashtable = this._id2Data;
        synchronized (hashtable) {
            WatchData watchData = this._id2Data.get(n);
            if (watchData != null) {
                int n3 = watchData._mask;
                int n4 = this.mapAction(n2);
                if (n2 == 1 && (n3 & n4) != 0) {
                    watchData._notifyListener.fileCreated(n, string, string2);
                } else if (n2 == 3 && (n3 & n4) != 0) {
                    watchData._notifyListener.fileModified(n, string, string2);
                } else if (n2 == 2 && (n3 & n4) != 0) {
                    watchData._notifyListener.fileDeleted(n, string, string2);
                } else if (n2 == 4 && (n3 & n4) != 0) {
                    watchData.renameOldName = string2;
                } else if (n2 == 5 && (n3 & n4) != 0) {
                    watchData._notifyListener.fileRenamed(n, string, watchData.renameOldName, string2);
                    watchData.renameOldName = null;
                }
            }
        }
    }

    private int mapAction(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 8;
            }
            case 4: {
                return 8;
            }
        }
        return -1;
    }

    private static class WatchData {
        int _wd;
        int _mask;
        JNotifyListener _notifyListener;
        public String renameOldName;

        WatchData(int n, int n2, JNotifyListener jNotifyListener) {
            this._wd = n;
            this._mask = n2;
            this._notifyListener = jNotifyListener;
        }

        public String toString() {
            return "wd=" + this._wd + ", action " + Util.getMaskDesc(this._mask);
        }
    }
}

