/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;

abstract class AtomicReferenceArrayQueue<E>
extends AbstractQueue<E> {
    protected final AtomicReferenceArray<E> buffer;
    protected final int mask;

    public AtomicReferenceArrayQueue(int n) {
        int n2 = Pow2.roundToPowerOfTwo(n);
        this.mask = n2 - 1;
        this.buffer = new AtomicReferenceArray(n2);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    protected final int calcElementOffset(long l, int n) {
        return (int)l & n;
    }

    protected final int calcElementOffset(long l) {
        return (int)l & this.mask;
    }

    protected final E lvElement(AtomicReferenceArray<E> atomicReferenceArray, int n) {
        return atomicReferenceArray.get(n);
    }

    protected final E lpElement(AtomicReferenceArray<E> atomicReferenceArray, int n) {
        return atomicReferenceArray.get(n);
    }

    protected final E lpElement(int n) {
        return this.buffer.get(n);
    }

    protected final void spElement(AtomicReferenceArray<E> atomicReferenceArray, int n, E e) {
        atomicReferenceArray.lazySet(n, e);
    }

    protected final void spElement(int n, E e) {
        this.buffer.lazySet(n, e);
    }

    protected final void soElement(AtomicReferenceArray<E> atomicReferenceArray, int n, E e) {
        atomicReferenceArray.lazySet(n, e);
    }

    protected final void soElement(int n, E e) {
        this.buffer.lazySet(n, e);
    }

    protected final void svElement(AtomicReferenceArray<E> atomicReferenceArray, int n, E e) {
        atomicReferenceArray.set(n, e);
    }

    protected final E lvElement(int n) {
        return this.lvElement(this.buffer, n);
    }
}

