/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.BaseLinkedQueueConsumerNodeRef;
import io.netty.util.internal.shaded.org.jctools.queues.LinkedQueueNode;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.Iterator;

abstract class BaseLinkedQueue<E>
extends BaseLinkedQueueConsumerNodeRef<E> {
    long p01;
    long p02;
    long p03;
    long p04;
    long p05;
    long p06;
    long p07;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;

    BaseLinkedQueue() {
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        int n;
        LinkedQueueNode linkedQueueNode = this.lvConsumerNode();
        LinkedQueueNode linkedQueueNode2 = this.lvProducerNode();
        for (n = 0; linkedQueueNode != linkedQueueNode2 && linkedQueueNode != null && n < Integer.MAX_VALUE; ++n) {
            LinkedQueueNode linkedQueueNode3 = linkedQueueNode.lvNext();
            if (linkedQueueNode3 == linkedQueueNode) {
                linkedQueueNode3 = this.lvConsumerNode();
            }
            linkedQueueNode = linkedQueueNode3;
        }
        return n;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerNode() == this.lvProducerNode();
    }

    @Override
    public int capacity() {
        return -1;
    }

    protected E getSingleConsumerNodeValue(LinkedQueueNode<E> linkedQueueNode, LinkedQueueNode<E> linkedQueueNode2) {
        E e = linkedQueueNode2.getAndNullValue();
        linkedQueueNode.soNext(linkedQueueNode);
        this.spConsumerNode(linkedQueueNode2);
        return e;
    }

    @Override
    public E relaxedPoll() {
        LinkedQueueNode linkedQueueNode = this.lpConsumerNode();
        LinkedQueueNode linkedQueueNode2 = linkedQueueNode.lvNext();
        if (linkedQueueNode2 != null) {
            return this.getSingleConsumerNodeValue(linkedQueueNode, linkedQueueNode2);
        }
        return null;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        int n;
        long l = 0L;
        while ((n = this.drain(consumer, 4096)) == 4096 && (l += (long)n) <= 0x7FFFEFFFL) {
        }
        return (int)l;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        LinkedQueueNode linkedQueueNode = this.consumerNode;
        for (int i = 0; i < n; ++i) {
            LinkedQueueNode linkedQueueNode2 = linkedQueueNode.lvNext();
            if (linkedQueueNode2 == null) {
                return i;
            }
            Object e = this.getSingleConsumerNodeValue(linkedQueueNode, linkedQueueNode2);
            linkedQueueNode = linkedQueueNode2;
            consumer.accept(e);
        }
        return n;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        LinkedQueueNode linkedQueueNode = this.consumerNode;
        int n = 0;
        while (exitCondition.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                LinkedQueueNode linkedQueueNode2 = linkedQueueNode.lvNext();
                if (linkedQueueNode2 == null) {
                    n = waitStrategy.idle(n);
                    continue;
                }
                n = 0;
                Object e = this.getSingleConsumerNodeValue(linkedQueueNode, linkedQueueNode2);
                linkedQueueNode = linkedQueueNode2;
                consumer.accept(e);
            }
        }
    }

    @Override
    public E relaxedPeek() {
        LinkedQueueNode linkedQueueNode = this.consumerNode;
        LinkedQueueNode linkedQueueNode2 = linkedQueueNode.lvNext();
        if (linkedQueueNode2 != null) {
            return linkedQueueNode2.lpValue();
        }
        return null;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }
}

