/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PriorityQueueNode;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public final class PriorityQueue<T extends PriorityQueueNode<T>>
extends AbstractQueue<T>
implements Queue<T> {
    private static final PriorityQueueNode[] EMPTY_QUEUE = new PriorityQueueNode[0];
    private T[] queue;
    private int size;

    public PriorityQueue() {
        this(8);
    }

    public PriorityQueue(int n) {
        this.queue = n != 0 ? new PriorityQueueNode[n] : EMPTY_QUEUE;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof PriorityQueueNode)) {
            return false;
        }
        PriorityQueueNode priorityQueueNode = (PriorityQueueNode)object;
        int n = priorityQueueNode.priorityQueueIndex();
        return n >= 0 && n < this.size && priorityQueueNode.equals(this.queue[n]);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            T t = this.queue[i];
            if (t == null) continue;
            t.priorityQueueIndex(-1);
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean offer(T t) {
        ObjectUtil.checkNotNull(t, "e");
        if (t.priorityQueueIndex() != -1) {
            throw new IllegalArgumentException("e.priorityQueueIndex(): " + t.priorityQueueIndex() + " (expected: " + -1 + ")");
        }
        if (this.size >= this.queue.length) {
            this.queue = (PriorityQueueNode[])Arrays.copyOf(this.queue, this.queue.length + (this.queue.length < 64 ? this.queue.length + 2 : this.queue.length >>> 1));
        }
        this.bubbleUp(this.size++, t);
        return true;
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            return null;
        }
        T t = this.queue[0];
        t.priorityQueueIndex(-1);
        T t2 = this.queue[--this.size];
        this.queue[this.size] = null;
        if (this.size != 0) {
            this.bubbleDown(0, t2);
        }
        return t;
    }

    @Override
    public T peek() {
        return this.size == 0 ? null : (T)this.queue[0];
    }

    @Override
    public boolean remove(Object object) {
        if (!this.contains(object)) {
            return false;
        }
        PriorityQueueNode priorityQueueNode = (PriorityQueueNode)object;
        int n = priorityQueueNode.priorityQueueIndex();
        priorityQueueNode.priorityQueueIndex(-1);
        if (--this.size == 0 || this.size == n) {
            this.queue[n] = null;
            return true;
        }
        T t = this.queue[n] = this.queue[this.size];
        this.queue[this.size] = null;
        if (priorityQueueNode.compareTo(t) < 0) {
            this.bubbleDown(n, t);
        } else {
            this.bubbleUp(n, t);
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public <X> X[] toArray(X[] XArray) {
        if (XArray.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, XArray.getClass());
        }
        System.arraycopy(this.queue, 0, XArray, 0, this.size);
        if (XArray.length > this.size) {
            XArray[this.size] = null;
        }
        return XArray;
    }

    @Override
    public Iterator<T> iterator() {
        return new PriorityQueueIterator();
    }

    private void bubbleDown(int n, T t) {
        int n2 = this.size >>> 1;
        while (n < n2) {
            int n3 = (n << 1) + 1;
            T t2 = this.queue[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && t2.compareTo(this.queue[n4]) > 0) {
                n3 = n4;
                t2 = this.queue[n3];
            }
            if (t.compareTo(t2) <= 0) break;
            this.queue[n] = t2;
            t2.priorityQueueIndex(n);
            n = n3;
        }
        this.queue[n] = t;
        t.priorityQueueIndex(n);
    }

    private void bubbleUp(int n, T t) {
        int n2;
        T t2;
        while (n > 0 && t.compareTo(t2 = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = t2;
            t2.priorityQueueIndex(n);
            n = n2;
        }
        this.queue[n] = t;
        t.priorityQueueIndex(n);
    }

    private final class PriorityQueueIterator
    implements Iterator<T> {
        private int index;

        private PriorityQueueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < PriorityQueue.this.size;
        }

        @Override
        public T next() {
            if (this.index >= PriorityQueue.this.size) {
                throw new NoSuchElementException();
            }
            return PriorityQueue.this.queue[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

