/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.SequentialDnsServerAddressStream;
import io.netty.util.internal.ThreadLocalRandom;
import java.net.InetSocketAddress;

final class ShuffledDnsServerAddressStream
implements DnsServerAddressStream {
    private final InetSocketAddress[] addresses;
    private int i;

    ShuffledDnsServerAddressStream(InetSocketAddress[] inetSocketAddressArray) {
        this.addresses = (InetSocketAddress[])inetSocketAddressArray.clone();
        this.shuffle();
    }

    private void shuffle() {
        InetSocketAddress[] inetSocketAddressArray = this.addresses;
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        for (int i = inetSocketAddressArray.length - 1; i >= 0; --i) {
            InetSocketAddress inetSocketAddress = inetSocketAddressArray[i];
            int n = threadLocalRandom.nextInt(i + 1);
            inetSocketAddressArray[i] = inetSocketAddressArray[n];
            inetSocketAddressArray[n] = inetSocketAddress;
        }
    }

    @Override
    public InetSocketAddress next() {
        int n = this.i;
        InetSocketAddress inetSocketAddress = this.addresses[n];
        if (++n < this.addresses.length) {
            this.i = n;
        } else {
            this.i = 0;
            this.shuffle();
        }
        return inetSocketAddress;
    }

    public String toString() {
        return SequentialDnsServerAddressStream.toString("shuffled", this.i, this.addresses);
    }
}

