/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;

public final class DnsNameResolverBuilder {
    private final EventLoop eventLoop;
    private ChannelFactory<? extends DatagramChannel> channelFactory;
    private DnsServerAddresses nameServerAddresses = DnsServerAddresses.defaultAddresses();
    private DnsCache resolveCache;
    private Integer minTtl;
    private Integer maxTtl;
    private Integer negativeTtl;
    private long queryTimeoutMillis = 5000L;
    private InternetProtocolFamily[] resolvedAddressTypes = DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES;
    private boolean recursionDesired = true;
    private int maxQueriesPerResolve = 16;
    private boolean traceEnabled;
    private int maxPayloadSize = 4096;
    private boolean optResourceEnabled = true;
    private HostsFileEntriesResolver hostsFileEntriesResolver = HostsFileEntriesResolver.DEFAULT;
    private String[] searchDomains = DnsNameResolver.DEFAULT_SEACH_DOMAINS;
    private int ndots = 1;

    public DnsNameResolverBuilder(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public DnsNameResolverBuilder channelFactory(ChannelFactory<? extends DatagramChannel> channelFactory) {
        this.channelFactory = channelFactory;
        return this;
    }

    public DnsNameResolverBuilder channelType(Class<? extends DatagramChannel> clazz) {
        return this.channelFactory(new ReflectiveChannelFactory<DatagramChannel>(clazz));
    }

    public DnsNameResolverBuilder nameServerAddresses(DnsServerAddresses dnsServerAddresses) {
        this.nameServerAddresses = dnsServerAddresses;
        return this;
    }

    public DnsNameResolverBuilder resolveCache(DnsCache dnsCache) {
        this.resolveCache = dnsCache;
        return this;
    }

    public DnsNameResolverBuilder ttl(int n, int n2) {
        this.maxTtl = n2;
        this.minTtl = n;
        return this;
    }

    public DnsNameResolverBuilder negativeTtl(int n) {
        this.negativeTtl = n;
        return this;
    }

    public DnsNameResolverBuilder queryTimeoutMillis(long l) {
        this.queryTimeoutMillis = l;
        return this;
    }

    public DnsNameResolverBuilder resolvedAddressTypes(InternetProtocolFamily ... internetProtocolFamilyArray) {
        ObjectUtil.checkNotNull(internetProtocolFamilyArray, "resolvedAddressTypes");
        ArrayList<InternetProtocolFamily> arrayList = InternalThreadLocalMap.get().arrayList(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily internetProtocolFamily : internetProtocolFamilyArray) {
            if (internetProtocolFamily == null) break;
            if (arrayList.contains((Object)internetProtocolFamily)) continue;
            arrayList.add(internetProtocolFamily);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolvedAddressTypes = arrayList.toArray(new InternetProtocolFamily[arrayList.size()]);
        return this;
    }

    public DnsNameResolverBuilder resolvedAddressTypes(Iterable<InternetProtocolFamily> iterable) {
        ObjectUtil.checkNotNull(iterable, "resolveAddressTypes");
        ArrayList<InternetProtocolFamily> arrayList = InternalThreadLocalMap.get().arrayList(InternetProtocolFamily.values().length);
        for (InternetProtocolFamily internetProtocolFamily : iterable) {
            if (internetProtocolFamily == null) break;
            if (arrayList.contains((Object)internetProtocolFamily)) continue;
            arrayList.add(internetProtocolFamily);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolvedAddressTypes = arrayList.toArray(new InternetProtocolFamily[arrayList.size()]);
        return this;
    }

    public DnsNameResolverBuilder recursionDesired(boolean bl) {
        this.recursionDesired = bl;
        return this;
    }

    public DnsNameResolverBuilder maxQueriesPerResolve(int n) {
        this.maxQueriesPerResolve = n;
        return this;
    }

    public DnsNameResolverBuilder traceEnabled(boolean bl) {
        this.traceEnabled = bl;
        return this;
    }

    public DnsNameResolverBuilder maxPayloadSize(int n) {
        this.maxPayloadSize = n;
        return this;
    }

    public DnsNameResolverBuilder optResourceEnabled(boolean bl) {
        this.optResourceEnabled = bl;
        return this;
    }

    public DnsNameResolverBuilder hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        return this;
    }

    public DnsNameResolverBuilder searchDomains(Iterable<String> iterable) {
        ObjectUtil.checkNotNull(iterable, "searchDomains");
        ArrayList<String> arrayList = InternalThreadLocalMap.get().arrayList(4);
        for (String string : iterable) {
            if (string == null) break;
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        this.searchDomains = arrayList.toArray(new String[arrayList.size()]);
        return this;
    }

    public DnsNameResolverBuilder ndots(int n) {
        this.ndots = n;
        return this;
    }

    public DnsNameResolver build() {
        if (this.resolveCache != null && (this.minTtl != null || this.maxTtl != null || this.negativeTtl != null)) {
            throw new IllegalStateException("resolveCache and TTLs are mutually exclusive");
        }
        DnsCache dnsCache = this.resolveCache != null ? this.resolveCache : new DefaultDnsCache(ObjectUtil.intValue(this.minTtl, 0), ObjectUtil.intValue(this.maxTtl, Integer.MAX_VALUE), ObjectUtil.intValue(this.negativeTtl, 0));
        return new DnsNameResolver(this.eventLoop, this.channelFactory, this.nameServerAddresses, dnsCache, this.queryTimeoutMillis, this.resolvedAddressTypes, this.recursionDesired, this.maxQueriesPerResolve, this.traceEnabled, this.maxPayloadSize, this.optResourceEnabled, this.hostsFileEntriesResolver, this.searchDomains, this.ndots);
    }
}

