/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelPromiseNotifier;
import io.netty.channel.PendingWriteQueue;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.ssl.ApplicationProtocolAccessor;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final SSLException SSLENGINE_CLOSED = ThrowableUtil.unknownStackTrace(new SSLException("SSLEngine closed already"), SslHandler.class, "wrap(...)");
    private static final SSLException HANDSHAKE_TIMED_OUT = ThrowableUtil.unknownStackTrace(new SSLException("handshake timed out"), SslHandler.class, "handshake(...)");
    private static final ClosedChannelException CHANNEL_CLOSED = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), SslHandler.class, "channelInactive(...)");
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final int maxPacketBufferSize;
    private final Executor delegatedTaskExecutor;
    private final ByteBuffer[] singleBuffer = new ByteBuffer[1];
    private final boolean wantsDirectBuffer;
    private final boolean wantsLargeOutboundNetworkBuffer;
    private final boolean startTls;
    private boolean sentFirstMessage;
    private boolean flushedBeforeHandshake;
    private boolean readDuringHandshake;
    private PendingWriteQueue pendingUnencryptedWrites;
    private Promise<Channel> handshakePromise = new LazyChannelPromise();
    private final LazyChannelPromise sslCloseFuture = new LazyChannelPromise();
    private boolean needsFlush;
    private boolean outboundClosed;
    private int packetLength;
    private boolean firedChannelRead;
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyTimeoutMillis = 3000L;

    public SslHandler(SSLEngine sSLEngine) {
        this(sSLEngine, false);
    }

    public SslHandler(SSLEngine sSLEngine, boolean bl) {
        this(sSLEngine, bl, ImmediateExecutor.INSTANCE);
    }

    @Deprecated
    public SslHandler(SSLEngine sSLEngine, Executor executor) {
        this(sSLEngine, false, executor);
    }

    @Deprecated
    public SslHandler(SSLEngine sSLEngine, boolean bl, Executor executor) {
        boolean bl2;
        if (sSLEngine == null) {
            throw new NullPointerException("engine");
        }
        if (executor == null) {
            throw new NullPointerException("delegatedTaskExecutor");
        }
        this.engine = sSLEngine;
        this.delegatedTaskExecutor = executor;
        this.startTls = bl;
        this.maxPacketBufferSize = sSLEngine.getSession().getPacketBufferSize();
        this.wantsDirectBuffer = bl2 = sSLEngine instanceof OpenSslEngine;
        this.wantsLargeOutboundNetworkBuffer = !bl2;
        this.setCumulator(bl2 ? COMPOSITE_CUMULATOR : MERGE_CUMULATOR);
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeout(long l, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.setHandshakeTimeoutMillis(timeUnit.toMillis(l));
    }

    public void setHandshakeTimeoutMillis(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("handshakeTimeoutMillis: " + l + " (expected: >= 0)");
        }
        this.handshakeTimeoutMillis = l;
    }

    public long getCloseNotifyTimeoutMillis() {
        return this.closeNotifyTimeoutMillis;
    }

    public void setCloseNotifyTimeout(long l, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.setCloseNotifyTimeoutMillis(timeUnit.toMillis(l));
    }

    public void setCloseNotifyTimeoutMillis(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("closeNotifyTimeoutMillis: " + l + " (expected: >= 0)");
        }
        this.closeNotifyTimeoutMillis = l;
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public String applicationProtocol() {
        SSLSession sSLSession = this.engine().getSession();
        if (!(sSLSession instanceof ApplicationProtocolAccessor)) {
            return null;
        }
        return ((ApplicationProtocolAccessor)((Object)sSLSession)).getApplicationProtocol();
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakePromise;
    }

    public ChannelFuture close() {
        return this.close(this.ctx.newPromise());
    }

    public ChannelFuture close(final ChannelPromise channelPromise) {
        final ChannelHandlerContext channelHandlerContext = this.ctx;
        channelHandlerContext.executor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    SslHandler.this.outboundClosed = true;
                    SslHandler.this.engine.closeOutbound();
                    try {
                        SslHandler.this.write(channelHandlerContext, Unpooled.EMPTY_BUFFER, channelPromise);
                        SslHandler.this.flush(channelHandlerContext);
                    }
                    catch (Exception exception) {
                        if (channelPromise.tryFailure(exception)) break block2;
                        logger.warn("{} flush() raised a masked exception.", (Object)channelHandlerContext.channel(), (Object)exception);
                    }
                }
            }
        });
        return channelPromise;
    }

    public Future<Channel> sslCloseFuture() {
        return this.sslCloseFuture;
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.removeAndFailAll(new ChannelException("Pending write on removal of SslHandler"));
        }
        if (this.engine instanceof OpenSslEngine) {
            ((OpenSslEngine)this.engine).shutdown();
        }
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, true);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, false);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.handshakePromise.isDone()) {
            this.readDuringHandshake = true;
        }
        channelHandlerContext.read();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (!(object instanceof ByteBuf)) {
            channelPromise.setFailure(new UnsupportedMessageTypeException(object, ByteBuf.class));
            return;
        }
        this.pendingUnencryptedWrites.add(object, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.startTls && !this.sentFirstMessage) {
            this.sentFirstMessage = true;
            this.pendingUnencryptedWrites.removeAndWriteAll();
            channelHandlerContext.flush();
            return;
        }
        if (this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelHandlerContext.newPromise());
        }
        if (!this.handshakePromise.isDone()) {
            this.flushedBeforeHandshake = true;
        }
        try {
            this.wrap(channelHandlerContext, false);
        }
        finally {
            channelHandlerContext.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void wrap(ChannelHandlerContext channelHandlerContext, boolean bl) throws SSLException {
        ByteBuf byteBuf = null;
        ChannelPromise channelPromise = null;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        boolean bl2 = false;
        try {
            block14: while (true) {
                Object object;
                if ((object = this.pendingUnencryptedWrites.current()) == null) {
                    return;
                }
                ByteBuf byteBuf2 = (ByteBuf)object;
                if (byteBuf == null) {
                    byteBuf = this.allocateOutNetBuf(channelHandlerContext, byteBuf2.readableBytes());
                }
                SSLEngineResult sSLEngineResult = this.wrap(byteBufAllocator, this.engine, byteBuf2, byteBuf);
                channelPromise = !byteBuf2.isReadable() ? this.pendingUnencryptedWrites.remove() : null;
                if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                    this.pendingUnencryptedWrites.removeAndFailAll(SSLENGINE_CLOSED);
                    this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, bl2);
                    return;
                }
                switch (sSLEngineResult.getHandshakeStatus()) {
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        continue block14;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                    }
                    case NOT_HANDSHAKING: {
                        this.setHandshakeSuccessIfStillHandshaking();
                    }
                    case NEED_WRAP: {
                        this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, false);
                        channelPromise = null;
                        byteBuf = null;
                        continue block14;
                    }
                    case NEED_UNWRAP: {
                        bl2 = true;
                        this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, bl2);
                        return;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()));
                    }
                }
                break;
            }
        }
        catch (SSLException sSLException) {
            this.setHandshakeFailure(channelHandlerContext, sSLException);
            throw sSLException;
        }
        finally {
            this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, bl2);
        }
    }

    private void finishWrap(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ChannelPromise channelPromise, boolean bl, boolean bl2) {
        if (byteBuf == null) {
            byteBuf = Unpooled.EMPTY_BUFFER;
        } else if (!byteBuf.isReadable()) {
            byteBuf.release();
            byteBuf = Unpooled.EMPTY_BUFFER;
        }
        if (channelPromise != null) {
            channelHandlerContext.write(byteBuf, channelPromise);
        } else {
            channelHandlerContext.write(byteBuf);
        }
        if (bl) {
            this.needsFlush = true;
        }
        if (bl2) {
            this.readIfNeeded(channelHandlerContext);
        }
    }

    private void wrapNonAppData(ChannelHandlerContext channelHandlerContext, boolean bl) throws SSLException {
        ReferenceCounted referenceCounted = null;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        try {
            SSLEngineResult sSLEngineResult;
            do {
                if (referenceCounted == null) {
                    referenceCounted = this.allocateOutNetBuf(channelHandlerContext, 0);
                }
                if ((sSLEngineResult = this.wrap(byteBufAllocator, this.engine, Unpooled.EMPTY_BUFFER, (ByteBuf)referenceCounted)).bytesProduced() > 0) {
                    channelHandlerContext.write(referenceCounted);
                    if (bl) {
                        this.needsFlush = true;
                    }
                    referenceCounted = null;
                }
                switch (sSLEngineResult.getHandshakeStatus()) {
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        break;
                    }
                    case NEED_UNWRAP: {
                        if (bl) break;
                        this.unwrapNonAppData(channelHandlerContext);
                        break;
                    }
                    case NEED_WRAP: {
                        break;
                    }
                    case NOT_HANDSHAKING: {
                        this.setHandshakeSuccessIfStillHandshaking();
                        if (bl) break;
                        this.unwrapNonAppData(channelHandlerContext);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()));
                    }
                }
                if (sSLEngineResult.bytesProduced() != 0) continue;
                break;
            } while (sSLEngineResult.bytesConsumed() != 0 || sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING);
        }
        catch (SSLException sSLException) {
            this.setHandshakeFailure(channelHandlerContext, sSLException);
            this.flushIfNeeded(channelHandlerContext);
            throw sSLException;
        }
        finally {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    private SSLEngineResult wrap(ByteBufAllocator byteBufAllocator, SSLEngine sSLEngine, ByteBuf byteBuf, ByteBuf byteBuf2) throws SSLException {
        ReferenceCounted referenceCounted = null;
        try {
            ByteBuffer[] byteBufferArray;
            int n = byteBuf.readerIndex();
            int n2 = byteBuf.readableBytes();
            if (byteBuf.isDirect() || !this.wantsDirectBuffer) {
                if (!(byteBuf instanceof CompositeByteBuf) && byteBuf.nioBufferCount() == 1) {
                    byteBufferArray = this.singleBuffer;
                    byteBufferArray[0] = byteBuf.internalNioBuffer(n, n2);
                } else {
                    byteBufferArray = byteBuf.nioBuffers();
                }
            } else {
                referenceCounted = byteBufAllocator.directBuffer(n2);
                ((ByteBuf)referenceCounted).writeBytes(byteBuf, n, n2);
                byteBufferArray = this.singleBuffer;
                byteBufferArray[0] = ((ByteBuf)referenceCounted).internalNioBuffer(0, n2);
            }
            while (true) {
                ByteBuffer byteBuffer = byteBuf2.nioBuffer(byteBuf2.writerIndex(), byteBuf2.writableBytes());
                SSLEngineResult sSLEngineResult = sSLEngine.wrap(byteBufferArray, byteBuffer);
                byteBuf.skipBytes(sSLEngineResult.bytesConsumed());
                byteBuf2.writerIndex(byteBuf2.writerIndex() + sSLEngineResult.bytesProduced());
                switch (sSLEngineResult.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        byteBuf2.ensureWritable(this.maxPacketBufferSize);
                        break;
                    }
                    default: {
                        SSLEngineResult sSLEngineResult2 = sSLEngineResult;
                        return sSLEngineResult2;
                    }
                }
            }
        }
        finally {
            this.singleBuffer[0] = null;
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.setHandshakeFailure(channelHandlerContext, CHANNEL_CLOSED, !this.outboundClosed);
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (this.ignoreException(throwable)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", (Object)channelHandlerContext.channel(), (Object)throwable);
            }
            if (channelHandlerContext.channel().isActive()) {
                channelHandlerContext.close();
            }
        } else {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }

    private boolean ignoreException(Throwable throwable) {
        if (!(throwable instanceof SSLException) && throwable instanceof IOException && this.sslCloseFuture.isDone()) {
            StackTraceElement[] stackTraceElementArray;
            String string = String.valueOf(throwable.getMessage()).toLowerCase();
            if (IGNORABLE_ERROR_MESSAGE.matcher(string).matches()) {
                return true;
            }
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                String string2 = stackTraceElement.getClassName();
                String string3 = stackTraceElement.getMethodName();
                if (string2.startsWith("io.netty.") || !"read".equals(string3)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(string2).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = PlatformDependent.getClassLoader(this.getClass()).loadClass(string2);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean isEncrypted(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        return SslUtils.getEncryptedPacketLength(byteBuf, byteBuf.readerIndex()) != -1;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws SSLException {
        int n;
        int n2 = byteBuf.readerIndex();
        int n3 = byteBuf.writerIndex();
        int n4 = n2;
        int n5 = 0;
        if (this.packetLength > 0) {
            if (n3 - n2 < this.packetLength) {
                return;
            }
            n4 += this.packetLength;
            n5 = this.packetLength;
            this.packetLength = 0;
        }
        boolean bl = false;
        while (n5 < 18713 && (n = n3 - n4) >= 5) {
            int n6 = SslUtils.getEncryptedPacketLength(byteBuf, n4);
            if (n6 == -1) {
                bl = true;
                break;
            }
            assert (n6 > 0);
            if (n6 > n) {
                this.packetLength = n6;
                break;
            }
            int n7 = n5 + n6;
            if (n7 > 18713) break;
            n4 += n6;
            n5 = n7;
        }
        if (n5 > 0) {
            n = 0;
            byteBuf.skipBytes(n5);
            n = this.unwrap(channelHandlerContext, byteBuf, n2, n5) ? 1 : 0;
            if (!this.firedChannelRead) {
                this.firedChannelRead = n;
            }
        }
        if (bl) {
            NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(byteBuf));
            byteBuf.skipBytes(byteBuf.readableBytes());
            channelHandlerContext.fireExceptionCaught(notSslRecordException);
            this.setHandshakeFailure(channelHandlerContext, notSslRecordException);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.discardSomeReadBytes();
        this.flushIfNeeded(channelHandlerContext);
        this.readIfNeeded(channelHandlerContext);
        this.firedChannelRead = false;
        channelHandlerContext.fireChannelReadComplete();
    }

    private void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!(channelHandlerContext.channel().config().isAutoRead() || this.firedChannelRead && this.handshakePromise.isDone())) {
            channelHandlerContext.read();
        }
    }

    private void flushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (this.needsFlush) {
            this.needsFlush = false;
            channelHandlerContext.flush();
        }
    }

    private void unwrapNonAppData(ChannelHandlerContext channelHandlerContext) throws SSLException {
        this.unwrap(channelHandlerContext, Unpooled.EMPTY_BUFFER, 0, 0);
    }

    private boolean unwrap(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n, int n2) throws SSLException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ByteBuf byteBuf2 = this.allocate(channelHandlerContext, n2);
        try {
            SSLEngineResult.HandshakeStatus handshakeStatus;
            block16: while (true) {
                SSLEngineResult sSLEngineResult = this.unwrap(this.engine, byteBuf, n, n2, byteBuf2);
                SSLEngineResult.Status status = sSLEngineResult.getStatus();
                handshakeStatus = sSLEngineResult.getHandshakeStatus();
                int n3 = sSLEngineResult.bytesProduced();
                int n4 = sSLEngineResult.bytesConsumed();
                n += n4;
                n2 -= n4;
                switch (status) {
                    case BUFFER_OVERFLOW: {
                        int n5 = byteBuf2.readableBytes();
                        if (n5 > 0) {
                            bl = true;
                            channelHandlerContext.fireChannelRead(byteBuf2);
                        } else {
                            byteBuf2.release();
                        }
                        byteBuf2 = this.allocate(channelHandlerContext, this.engine.getSession().getApplicationBufferSize() - n5);
                        continue block16;
                    }
                    case CLOSED: {
                        bl3 = true;
                        break;
                    }
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        break;
                    }
                    case NEED_WRAP: {
                        this.wrapNonAppData(channelHandlerContext, true);
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        break;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        bl2 = true;
                        break;
                    }
                    case NOT_HANDSHAKING: {
                        if (this.setHandshakeSuccessIfStillHandshaking()) {
                            bl2 = true;
                            continue block16;
                        }
                        if (!this.flushedBeforeHandshake) break;
                        this.flushedBeforeHandshake = false;
                        bl2 = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown handshake status: " + (Object)((Object)handshakeStatus));
                    }
                }
                if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW || n4 == 0 && n3 == 0) break;
            }
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                this.readIfNeeded(channelHandlerContext);
            }
            if (bl2) {
                this.wrap(channelHandlerContext, true);
            }
            if (bl3) {
                this.sslCloseFuture.trySuccess(channelHandlerContext.channel());
            }
        }
        catch (SSLException sSLException) {
            this.setHandshakeFailure(channelHandlerContext, sSLException);
            throw sSLException;
        }
        finally {
            if (byteBuf2.isReadable()) {
                bl = true;
                channelHandlerContext.fireChannelRead(byteBuf2);
            } else {
                byteBuf2.release();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult unwrap(SSLEngine sSLEngine, ByteBuf byteBuf, int n, int n2, ByteBuf byteBuf2) throws SSLException {
        SSLEngineResult sSLEngineResult;
        int n3 = byteBuf.nioBufferCount();
        int n4 = byteBuf2.writerIndex();
        if (sSLEngine instanceof OpenSslEngine && n3 > 1) {
            OpenSslEngine openSslEngine = (OpenSslEngine)sSLEngine;
            try {
                this.singleBuffer[0] = SslHandler.toByteBuffer(byteBuf2, n4, byteBuf2.writableBytes());
                sSLEngineResult = openSslEngine.unwrap(byteBuf.nioBuffers(n, n2), this.singleBuffer);
                byteBuf2.writerIndex(n4 + sSLEngineResult.bytesProduced());
            }
            finally {
                this.singleBuffer[0] = null;
            }
        } else {
            sSLEngineResult = sSLEngine.unwrap(SslHandler.toByteBuffer(byteBuf, n, n2), SslHandler.toByteBuffer(byteBuf2, n4, byteBuf2.writableBytes()));
        }
        byteBuf2.writerIndex(n4 + sSLEngineResult.bytesProduced());
        return sSLEngineResult;
    }

    private static ByteBuffer toByteBuffer(ByteBuf byteBuf, int n, int n2) {
        return byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(n, n2) : byteBuf.nioBuffer(n, n2);
    }

    private void runDelegatedTasks() {
        if (this.delegatedTaskExecutor == ImmediateExecutor.INSTANCE) {
            Runnable runnable;
            while ((runnable = this.engine.getDelegatedTask()) != null) {
                runnable.run();
            }
        } else {
            Object object;
            final ArrayList<Runnable> arrayList = new ArrayList<Runnable>(2);
            while ((object = this.engine.getDelegatedTask()) != null) {
                arrayList.add((Runnable)object);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            object = new CountDownLatch(1);
            this.delegatedTaskExecutor.execute(new Runnable((CountDownLatch)object){
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$latch = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (Runnable runnable : arrayList) {
                            runnable.run();
                        }
                    }
                    catch (Exception exception) {
                        SslHandler.this.ctx.fireExceptionCaught(exception);
                    }
                    finally {
                        this.val$latch.countDown();
                    }
                }
            });
            boolean bl = false;
            while (((CountDownLatch)object).getCount() != 0L) {
                try {
                    ((CountDownLatch)object).await();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean setHandshakeSuccessIfStillHandshaking() {
        if (!this.handshakePromise.isDone()) {
            this.setHandshakeSuccess();
            return true;
        }
        return false;
    }

    private void setHandshakeSuccess() {
        this.handshakePromise.trySuccess(this.ctx.channel());
        if (logger.isDebugEnabled()) {
            logger.debug("{} HANDSHAKEN: {}", (Object)this.ctx.channel(), (Object)this.engine.getSession().getCipherSuite());
        }
        this.ctx.fireUserEventTriggered(SslHandshakeCompletionEvent.SUCCESS);
        if (this.readDuringHandshake && !this.ctx.channel().config().isAutoRead()) {
            this.readDuringHandshake = false;
            this.ctx.read();
        }
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.setHandshakeFailure(channelHandlerContext, throwable, true);
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl) {
        block3: {
            this.engine.closeOutbound();
            if (bl) {
                try {
                    this.engine.closeInbound();
                }
                catch (SSLException sSLException) {
                    String string = sSLException.getMessage();
                    if (string != null && string.contains("possible truncation attack")) break block3;
                    logger.debug("{} SSLEngine.closeInbound() raised an exception.", (Object)channelHandlerContext.channel(), (Object)sSLException);
                }
            }
        }
        this.notifyHandshakeFailure(throwable);
        this.pendingUnencryptedWrites.removeAndFailAll(throwable);
    }

    private void notifyHandshakeFailure(Throwable throwable) {
        if (this.handshakePromise.tryFailure(throwable)) {
            SslUtils.notifyHandshakeFailure(this.ctx, throwable);
        }
    }

    private void closeOutboundAndChannel(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, boolean bl) throws Exception {
        if (!channelHandlerContext.channel().isActive()) {
            if (bl) {
                channelHandlerContext.disconnect(channelPromise);
            } else {
                channelHandlerContext.close(channelPromise);
            }
            return;
        }
        this.outboundClosed = true;
        this.engine.closeOutbound();
        ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
        this.write(channelHandlerContext, Unpooled.EMPTY_BUFFER, channelPromise2);
        this.flush(channelHandlerContext);
        this.safeClose(channelHandlerContext, channelPromise2, channelPromise);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        this.pendingUnencryptedWrites = new PendingWriteQueue(channelHandlerContext);
        if (channelHandlerContext.channel().isActive() && this.engine.getUseClientMode()) {
            this.handshake(null);
        }
    }

    public Future<Channel> renegotiate() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException();
        }
        return this.renegotiate(channelHandlerContext.executor().newPromise());
    }

    public Future<Channel> renegotiate(final Promise<Channel> promise) {
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException();
        }
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (!eventExecutor.inEventLoop()) {
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SslHandler.this.handshake(promise);
                }
            });
            return promise;
        }
        this.handshake(promise);
        return promise;
    }

    private void handshake(final Promise<Channel> promise) {
        Promise<Channel> promise2;
        Promise<Channel> promise3;
        if (promise != null) {
            promise3 = this.handshakePromise;
            if (!promise3.isDone()) {
                promise3.addListener((GenericFutureListener<Future<Channel>>)new FutureListener<Channel>(){

                    @Override
                    public void operationComplete(Future<Channel> future) throws Exception {
                        if (future.isSuccess()) {
                            promise.setSuccess(future.getNow());
                        } else {
                            promise.setFailure(future.cause());
                        }
                    }
                });
                return;
            }
            this.handshakePromise = promise2 = promise;
        } else {
            if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                return;
            }
            promise2 = this.handshakePromise;
            assert (!promise2.isDone());
        }
        promise3 = this.ctx;
        try {
            this.engine.beginHandshake();
            this.wrapNonAppData((ChannelHandlerContext)((Object)promise3), false);
            promise3.flush();
        }
        catch (Exception exception) {
            this.notifyHandshakeFailure(exception);
        }
        long l = this.handshakeTimeoutMillis;
        if (l <= 0L || promise2.isDone()) {
            return;
        }
        final ScheduledFuture<?> scheduledFuture = promise3.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (promise2.isDone()) {
                    return;
                }
                SslHandler.this.notifyHandshakeFailure(HANDSHAKE_TIMED_OUT);
            }
        }, l, TimeUnit.MILLISECONDS);
        promise2.addListener((GenericFutureListener<Future<Channel>>)new FutureListener<Channel>(){

            @Override
            public void operationComplete(Future<Channel> future) throws Exception {
                scheduledFuture.cancel(false);
            }
        });
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (!this.startTls && this.engine.getUseClientMode()) {
            this.handshake(null);
        }
        channelHandlerContext.fireChannelActive();
    }

    private void safeClose(final ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture, final ChannelPromise channelPromise) {
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        final ScheduledFuture<?> scheduledFuture = this.closeNotifyTimeoutMillis > 0L ? channelHandlerContext.executor().schedule(new Runnable(){

            @Override
            public void run() {
                logger.warn("{} Last write attempt timed out; force-closing the connection.", (Object)channelHandlerContext.channel());
                channelHandlerContext.close(channelHandlerContext.newPromise()).addListener(new ChannelPromiseNotifier(channelPromise));
            }
        }, this.closeNotifyTimeoutMillis, TimeUnit.MILLISECONDS) : null;
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                channelHandlerContext.close(channelHandlerContext.newPromise()).addListener(new ChannelPromiseNotifier(channelPromise));
            }
        });
    }

    private ByteBuf allocate(ChannelHandlerContext channelHandlerContext, int n) {
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        if (this.wantsDirectBuffer) {
            return byteBufAllocator.directBuffer(n);
        }
        return byteBufAllocator.buffer(n);
    }

    private ByteBuf allocateOutNetBuf(ChannelHandlerContext channelHandlerContext, int n) {
        if (this.wantsLargeOutboundNetworkBuffer) {
            return this.allocate(channelHandlerContext, this.maxPacketBufferSize);
        }
        return this.allocate(channelHandlerContext, Math.min(n + 2329, this.maxPacketBufferSize));
    }

    private final class LazyChannelPromise
    extends DefaultPromise<Channel> {
        private LazyChannelPromise() {
        }

        @Override
        protected EventExecutor executor() {
            if (SslHandler.this.ctx == null) {
                throw new IllegalStateException();
            }
            return SslHandler.this.ctx.executor();
        }

        @Override
        protected void checkDeadLock() {
            if (SslHandler.this.ctx == null) {
                return;
            }
            super.checkDeadLock();
        }
    }
}

