/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslCertificateException;
import io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.OpenSslX509Certificate;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.PemX509Certificate;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;

public abstract class OpenSslContext
extends SslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSslContext.class);
    private static final boolean JDK_REJECT_CLIENT_INITIATED_RENEGOTIATION = SystemPropertyUtil.getBoolean("jdk.tls.rejectClientInitiatedRenegotiation", false);
    private static final List<String> DEFAULT_CIPHERS;
    private static final Integer DH_KEY_LENGTH;
    protected static final int VERIFY_DEPTH = 10;
    protected volatile long ctx;
    long aprPool;
    private volatile int aprPoolDestroyed;
    private final List<String> unmodifiableCiphers;
    private final long sessionCacheSize;
    private final long sessionTimeout;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final OpenSslEngineMap engineMap = new DefaultOpenSslEngineMap();
    volatile boolean rejectRemoteInitiatedRenegotiation;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;

    OpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2, int n, Certificate[] certificateArray, ClientAuth clientAuth) throws SSLException {
        this(iterable, cipherSuiteFilter, OpenSslContext.toNegotiator(applicationProtocolConfig), l, l2, n, certificateArray, clientAuth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    OpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2, int n, Certificate[] certificateArray, ClientAuth clientAuth) throws SSLException {
        Object exception;
        ArrayList<String> arrayList;
        OpenSsl.ensureAvailability();
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        this.mode = n;
        ClientAuth clientAuth2 = this.clientAuth = this.isServer() ? ObjectUtil.checkNotNull(clientAuth, "clientAuth") : ClientAuth.NONE;
        if (n == 1) {
            this.rejectRemoteInitiatedRenegotiation = JDK_REJECT_CLIENT_INITIATED_RENEGOTIATION;
        }
        Certificate[] certificateArray2 = this.keyCertChain = certificateArray == null ? null : (Certificate[])certificateArray.clone();
        if (iterable == null) {
            arrayList = null;
        } else {
            arrayList = new ArrayList<String>();
            for (String string : iterable) {
                void object2;
                if (string == null) break;
                exception = CipherSuiteConverter.toOpenSsl(string);
                if (exception != null) {
                    String string2 = exception;
                }
                arrayList.add((String)object2);
            }
        }
        this.unmodifiableCiphers = Arrays.asList(ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites(arrayList, DEFAULT_CIPHERS, OpenSsl.availableCipherSuites()));
        this.apn = ObjectUtil.checkNotNull(openSslApplicationProtocolNegotiator, "apn");
        this.aprPool = Pool.create((long)0L);
        boolean bl = false;
        try {
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                try {
                    this.ctx = SSLContext.make((long)this.aprPool, (int)31, (int)n);
                }
                catch (Exception exception2) {
                    throw new SSLException("failed to create an SSL_CTX", exception2);
                }
                SSLContext.setOptions((long)this.ctx, (int)4095);
                SSLContext.setOptions((long)this.ctx, (int)0x1000000);
                SSLContext.setOptions((long)this.ctx, (int)0x2000000);
                SSLContext.setOptions((long)this.ctx, (int)0x400000);
                SSLContext.setOptions((long)this.ctx, (int)524288);
                SSLContext.setOptions((long)this.ctx, (int)0x100000);
                SSLContext.setOptions((long)this.ctx, (int)65536);
                SSLContext.setOptions((long)this.ctx, (int)16384);
                SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | 2));
                if (DH_KEY_LENGTH != null) {
                    SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
                }
                try {
                    SSLContext.setCipherSuite((long)this.ctx, (String)CipherSuiteConverter.toOpenSsl(this.unmodifiableCiphers));
                }
                catch (SSLException sSLException) {
                    throw sSLException;
                }
                catch (Exception exception3) {
                    throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, exception3);
                }
                exception = openSslApplicationProtocolNegotiator.protocols();
                if (!exception.isEmpty()) {
                    String[] stringArray = exception.toArray(new String[exception.size()]);
                    int n2 = OpenSslContext.opensslSelectorFailureBehavior(openSslApplicationProtocolNegotiator.selectorFailureBehavior());
                    switch (openSslApplicationProtocolNegotiator.protocol()) {
                        case NPN: {
                            SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray, (int)n2);
                            break;
                        }
                        case ALPN: {
                            SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray, (int)n2);
                            break;
                        }
                        case NPN_AND_ALPN: {
                            SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray, (int)n2);
                            SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray, (int)n2);
                            break;
                        }
                        default: {
                            throw new Error();
                        }
                    }
                }
                if (l > 0L) {
                    this.sessionCacheSize = l;
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)l);
                } else {
                    this.sessionCacheSize = l = SSLContext.setSessionCacheSize((long)this.ctx, (long)20480L);
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)l);
                }
                if (l2 > 0L) {
                    this.sessionTimeout = l2;
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)l2);
                } else {
                    this.sessionTimeout = l2 = SSLContext.setSessionCacheTimeout((long)this.ctx, (long)300L);
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)l2);
                }
                // ** MonitorExit[var13_15] (shouldn't be in output)
                bl = true;
            }
        }
        finally {
            if (!bl) {
                this.destroy();
            }
        }
        {
            return;
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior) {
        switch (selectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public final long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public final long sessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n) {
        return new OpenSslEngine(this, byteBufAllocator, string, n);
    }

    abstract OpenSslKeyMaterialManager keyMaterialManager();

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.newEngine(byteBufAllocator, null, -1);
    }

    @Deprecated
    public final long context() {
        return this.ctx;
    }

    @Deprecated
    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    public void setRejectRemoteInitiatedRenegotiation(boolean bl) {
        this.rejectRemoteInitiatedRenegotiation = bl;
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    @Deprecated
    public final void setTicketKeys(byte[] byArray) {
        this.sessionContext().setTicketKeys(byArray);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    public final long sslCtxPointer() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void destroy() {
        Class<OpenSslContext> clazz = OpenSslContext.class;
        synchronized (OpenSslContext.class) {
            if (this.ctx != 0L) {
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
            }
            if (this.aprPool != 0L) {
                Pool.destroy((long)this.aprPool);
                this.aprPool = 0L;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static X509Certificate[] certificates(byte[][] byArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = new OpenSslX509Certificate(byArray[i]);
        }
        return x509CertificateArray;
    }

    protected static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] keyManagerArray) {
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig) {
        if (applicationProtocolConfig == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (applicationProtocolConfig.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(applicationProtocolConfig);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    static boolean useExtendedTrustManager(X509TrustManager x509TrustManager) {
        return PlatformDependent.javaVersion() >= 7 && x509TrustManager instanceof X509ExtendedTrustManager;
    }

    static boolean useExtendedKeyManager(X509KeyManager x509KeyManager) {
        return PlatformDependent.javaVersion() >= 7 && x509KeyManager instanceof X509ExtendedKeyManager;
    }

    static void setKeyMaterial(long l, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) throws SSLException {
        long l2 = 0L;
        long l3 = 0L;
        try {
            l3 = OpenSslContext.toBIO(x509CertificateArray);
            l2 = OpenSslContext.toBIO(privateKey);
            SSLContext.setCertificateBio((long)l, (long)l3, (long)l2, (String)(string == null ? "" : string), (int)0);
            SSLContext.setCertificateChainBio((long)l, (long)l3, (boolean)false);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException("failed to set certificate and key", exception);
        }
        finally {
            if (l2 != 0L) {
                SSL.freeBIO((long)l2);
            }
            if (l3 != 0L) {
                SSL.freeBIO((long)l3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(PrivateKey privateKey) throws Exception {
        if (privateKey == null) {
            return 0L;
        }
        ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
        PemEncoded pemEncoded = PemPrivateKey.toPEM(byteBufAllocator, true, privateKey);
        try {
            long l = OpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(X509Certificate ... x509CertificateArray) throws Exception {
        if (x509CertificateArray == null) {
            return 0L;
        }
        if (x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("certChain can't be empty");
        }
        ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        try {
            long l = OpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long toBIO(ByteBufAllocator byteBufAllocator, PemEncoded pemEncoded) throws Exception {
        try {
            long l;
            ByteBuf byteBuf = pemEncoded.content();
            if (byteBuf.isDirect()) {
                long l2 = OpenSslContext.newBIO(byteBuf.retainedSlice());
                return l2;
            }
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(byteBuf.readableBytes());
            try {
                byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                l = OpenSslContext.newBIO(byteBuf2.retainedSlice());
            }
            catch (Throwable throwable) {
                try {
                    if (pemEncoded.isSensitive()) {
                        SslUtils.zeroout(byteBuf2);
                    }
                }
                finally {
                    byteBuf2.release();
                }
                throw throwable;
            }
            try {
                if (pemEncoded.isSensitive()) {
                    SslUtils.zeroout(byteBuf2);
                }
            }
            finally {
                byteBuf2.release();
            }
            return l;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long newBIO(ByteBuf byteBuf) throws Exception {
        try {
            long l = SSL.newMemBIO();
            int n = byteBuf.readableBytes();
            if (SSL.writeToBIO((long)l, (long)OpenSsl.memoryAddress(byteBuf), (int)n) != n) {
                SSL.freeBIO((long)l);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            long l2 = l;
            return l2;
        }
        finally {
            byteBuf.release();
        }
    }

    static {
        NONE_PROTOCOL_NEGOTIATOR = new OpenSslApplicationProtocolNegotiator(){

            @Override
            public ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.NONE;
            }

            @Override
            public List<String> protocols() {
                return Collections.emptyList();
            }

            @Override
            public ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior() {
                return ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL;
            }

            @Override
            public ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior() {
                return ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT;
            }
        };
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, "ECDHE-RSA-AES128-GCM-SHA256", "ECDHE-RSA-AES128-SHA", "ECDHE-RSA-AES256-SHA", "AES128-GCM-SHA256", "AES128-SHA", "AES256-SHA", "DES-CBC3-SHA");
        DEFAULT_CIPHERS = Collections.unmodifiableList(arrayList);
        if (logger.isDebugEnabled()) {
            logger.debug("Default cipher suite (OpenSSL): " + arrayList);
        }
        Integer n = null;
        try {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return SystemPropertyUtil.get("jdk.tls.ephemeralDHKeySize");
                }
            });
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("OpenSslContext only support -Djdk.tls.ephemeralDHKeySize={int}, but got: " + string);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DH_KEY_LENGTH = n;
    }

    private static final class DefaultOpenSslEngineMap
    implements OpenSslEngineMap {
        private final Map<Long, OpenSslEngine> engines = PlatformDependent.newConcurrentHashMap();

        private DefaultOpenSslEngineMap() {
        }

        @Override
        public OpenSslEngine remove(long l) {
            return this.engines.remove(l);
        }

        @Override
        public void add(OpenSslEngine openSslEngine) {
            this.engines.put(openSslEngine.sslPointer(), openSslEngine);
        }

        @Override
        public OpenSslEngine get(long l) {
            return this.engines.get(l);
        }
    }

    static abstract class AbstractCertificateVerifier
    implements CertificateVerifier {
        private final OpenSslEngineMap engineMap;

        AbstractCertificateVerifier(OpenSslEngineMap openSslEngineMap) {
            this.engineMap = openSslEngineMap;
        }

        public final int verify(long l, byte[][] byArray, String string) {
            X509Certificate[] x509CertificateArray = OpenSslContext.certificates(byArray);
            OpenSslEngine openSslEngine = this.engineMap.get(l);
            try {
                this.verify(openSslEngine, x509CertificateArray, string);
                return 0;
            }
            catch (Throwable throwable) {
                logger.debug("verification of certificate failed", throwable);
                SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
                sSLHandshakeException.initCause(throwable);
                openSslEngine.handshakeException = sSLHandshakeException;
                if (throwable instanceof OpenSslCertificateException) {
                    return ((OpenSslCertificateException)throwable).errorCode();
                }
                if (throwable instanceof CertificateExpiredException) {
                    return 10;
                }
                if (throwable instanceof CertificateNotYetValidException) {
                    return 9;
                }
                if (PlatformDependent.javaVersion() >= 7 && throwable instanceof CertificateRevokedException) {
                    return 23;
                }
                return 1;
            }
        }

        abstract void verify(OpenSslEngine var1, X509Certificate[] var2, String var3) throws Exception;
    }
}

