/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class Http2ServerDowngrader
extends MessageToMessageCodec<Http2StreamFrame, HttpObject> {
    private final boolean validateHeaders;

    public Http2ServerDowngrader(boolean bl) {
        this.validateHeaders = bl;
    }

    public Http2ServerDowngrader() {
        this(true);
    }

    @Override
    public boolean acceptInboundMessage(Object object) throws Exception {
        return object instanceof Http2HeadersFrame || object instanceof Http2DataFrame;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, Http2StreamFrame http2StreamFrame, List<Object> list) throws Exception {
        if (http2StreamFrame instanceof Http2HeadersFrame) {
            int n = 0;
            Http2HeadersFrame http2HeadersFrame = (Http2HeadersFrame)http2StreamFrame;
            Http2Headers http2Headers = http2HeadersFrame.headers();
            if (http2HeadersFrame.isEndStream()) {
                if (http2Headers.method() == null) {
                    DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
                    HttpConversionUtil.addHttp2ToHttpHeaders(n, http2Headers, defaultLastHttpContent.trailingHeaders(), HttpVersion.HTTP_1_1, true, true);
                    list.add(defaultLastHttpContent);
                } else {
                    FullHttpRequest fullHttpRequest = HttpConversionUtil.toFullHttpRequest(n, http2Headers, channelHandlerContext.alloc(), this.validateHeaders);
                    list.add(fullHttpRequest);
                }
            } else {
                list.add(HttpConversionUtil.toHttpRequest(n, http2HeadersFrame.headers(), this.validateHeaders));
            }
        } else if (http2StreamFrame instanceof Http2DataFrame) {
            Http2DataFrame http2DataFrame = (Http2DataFrame)http2StreamFrame;
            if (http2DataFrame.isEndStream()) {
                list.add(new DefaultLastHttpContent(http2DataFrame.content(), this.validateHeaders));
            } else {
                list.add(new DefaultHttpContent(http2DataFrame.content()));
            }
        }
        ReferenceCountUtil.retain(http2StreamFrame);
    }

    private void encodeLastContent(LastHttpContent lastHttpContent, List<Object> list) {
        boolean bl;
        boolean bl2 = bl = !(lastHttpContent instanceof FullHttpResponse) && lastHttpContent.trailingHeaders().isEmpty();
        if (lastHttpContent.content().isReadable() || bl) {
            list.add(new DefaultHttp2DataFrame(lastHttpContent.content(), lastHttpContent.trailingHeaders().isEmpty()));
        }
        if (!lastHttpContent.trailingHeaders().isEmpty()) {
            Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers(lastHttpContent.trailingHeaders(), this.validateHeaders);
            list.add(new DefaultHttp2HeadersFrame(http2Headers, true));
        }
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) throws Exception {
        Object object;
        if (httpObject instanceof HttpResponse) {
            object = HttpConversionUtil.toHttp2Headers((HttpResponse)httpObject, this.validateHeaders);
            boolean bl = false;
            if (httpObject instanceof FullHttpResponse) {
                FullHttpResponse fullHttpResponse = (FullHttpResponse)httpObject;
                bl = !fullHttpResponse.content().isReadable() && fullHttpResponse.trailingHeaders().isEmpty();
            }
            list.add(new DefaultHttp2HeadersFrame((Http2Headers)object, bl));
        }
        if (httpObject instanceof LastHttpContent) {
            object = (LastHttpContent)httpObject;
            this.encodeLastContent((LastHttpContent)object, list);
        } else if (httpObject instanceof HttpContent) {
            object = (HttpContent)httpObject;
            list.add(new DefaultHttp2DataFrame(object.content(), false));
        }
        ReferenceCountUtil.retain(httpObject);
    }
}

