/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamActiveEvent;
import io.netty.handler.codec.http2.Http2StreamClosedEvent;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.InboundHttpToHttp2Adapter;
import io.netty.handler.logging.LogLevel;
import io.netty.util.ReferenceCountUtil;

public class Http2FrameCodec
extends ChannelDuplexHandler {
    private static final Http2FrameLogger HTTP2_FRAME_LOGGER = new Http2FrameLogger(LogLevel.INFO, Http2FrameCodec.class);
    private final Http2ConnectionHandler http2Handler;
    private ChannelHandlerContext ctx;
    private ChannelHandlerContext http2HandlerCtx;

    public Http2FrameCodec(boolean bl) {
        this(bl, new DefaultHttp2FrameWriter());
    }

    Http2FrameCodec(boolean bl, Http2FrameWriter http2FrameWriter) {
        DefaultHttp2Connection defaultHttp2Connection = new DefaultHttp2Connection(bl);
        http2FrameWriter = new Http2OutboundFrameLogger(http2FrameWriter, HTTP2_FRAME_LOGGER);
        DefaultHttp2ConnectionEncoder defaultHttp2ConnectionEncoder = new DefaultHttp2ConnectionEncoder(defaultHttp2Connection, http2FrameWriter);
        Http2InboundFrameLogger http2InboundFrameLogger = new Http2InboundFrameLogger(new DefaultHttp2FrameReader(), HTTP2_FRAME_LOGGER);
        DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder = new DefaultHttp2ConnectionDecoder(defaultHttp2Connection, defaultHttp2ConnectionEncoder, http2InboundFrameLogger);
        defaultHttp2ConnectionDecoder.frameListener(new FrameListener());
        this.http2Handler = new InternalHttp2ConnectionHandler(defaultHttp2ConnectionDecoder, defaultHttp2ConnectionEncoder, new Http2Settings());
        this.http2Handler.connection().addListener(new ConnectionListener());
    }

    Http2ConnectionHandler connectionHandler() {
        return this.http2Handler;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        channelHandlerContext.pipeline().addBefore(channelHandlerContext.executor(), channelHandlerContext.name(), null, this.http2Handler);
        this.http2HandlerCtx = channelHandlerContext.pipeline().context(this.http2Handler);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.pipeline().remove(this.http2Handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (!(object instanceof HttpServerUpgradeHandler.UpgradeEvent)) {
            super.userEventTriggered(channelHandlerContext, object);
            return;
        }
        HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)object;
        channelHandlerContext.fireUserEventTriggered(upgradeEvent.retain());
        try {
            Http2Stream http2Stream = this.http2Handler.connection().stream(1);
            new ConnectionListener().onStreamActive(http2Stream);
            upgradeEvent.upgradeRequest().headers().setInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 1);
            new InboundHttpToHttp2Adapter(this.http2Handler.connection(), this.http2Handler.decoder().frameListener()).channelRead(channelHandlerContext, upgradeEvent.upgradeRequest().retain());
        }
        finally {
            upgradeEvent.release();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        block7: {
            if (!(object instanceof Http2Frame)) {
                channelHandlerContext.write(object, channelPromise);
                return;
            }
            try {
                if (object instanceof Http2WindowUpdateFrame) {
                    Http2WindowUpdateFrame http2WindowUpdateFrame = (Http2WindowUpdateFrame)object;
                    this.consumeBytes(http2WindowUpdateFrame.streamId(), http2WindowUpdateFrame.windowSizeIncrement(), channelPromise);
                    break block7;
                }
                if (object instanceof Http2StreamFrame) {
                    this.writeStreamFrame((Http2StreamFrame)object, channelPromise);
                    break block7;
                }
                if (object instanceof Http2GoAwayFrame) {
                    this.writeGoAwayFrame((Http2GoAwayFrame)object, channelPromise);
                    break block7;
                }
                throw new UnsupportedMessageTypeException(object, new Class[0]);
            }
            finally {
                ReferenceCountUtil.release(object);
            }
        }
    }

    private void consumeBytes(int n, int n2, ChannelPromise channelPromise) {
        try {
            Http2Stream http2Stream = this.http2Handler.connection().stream(n);
            this.http2Handler.connection().local().flowController().consumeBytes(http2Stream, n2);
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    private void writeGoAwayFrame(Http2GoAwayFrame http2GoAwayFrame, ChannelPromise channelPromise) {
        if (http2GoAwayFrame.lastStreamId() > -1) {
            throw new IllegalArgumentException("Last stream id must not be set on GOAWAY frame");
        }
        int n = this.http2Handler.connection().remote().lastStreamCreated();
        int n2 = n + http2GoAwayFrame.extraStreamIds() * 2;
        if (n2 < n) {
            n2 = Integer.MAX_VALUE;
        }
        this.http2Handler.goAway(this.http2HandlerCtx, n2, http2GoAwayFrame.errorCode(), http2GoAwayFrame.content().retain(), channelPromise);
    }

    private void writeStreamFrame(Http2StreamFrame http2StreamFrame, ChannelPromise channelPromise) {
        int n = http2StreamFrame.streamId();
        if (http2StreamFrame instanceof Http2DataFrame) {
            Http2DataFrame http2DataFrame = (Http2DataFrame)http2StreamFrame;
            this.http2Handler.encoder().writeData(this.http2HandlerCtx, n, http2DataFrame.content().retain(), http2DataFrame.padding(), http2DataFrame.isEndStream(), channelPromise);
        } else if (http2StreamFrame instanceof Http2HeadersFrame) {
            Http2HeadersFrame http2HeadersFrame = (Http2HeadersFrame)http2StreamFrame;
            this.http2Handler.encoder().writeHeaders(this.http2HandlerCtx, n, http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
        } else if (http2StreamFrame instanceof Http2ResetFrame) {
            Http2ResetFrame http2ResetFrame = (Http2ResetFrame)http2StreamFrame;
            this.http2Handler.resetStream(this.http2HandlerCtx, n, http2ResetFrame.errorCode(), channelPromise);
        } else {
            throw new UnsupportedMessageTypeException(http2StreamFrame, new Class[0]);
        }
    }

    private final class FrameListener
    extends Http2FrameAdapter {
        private FrameListener() {
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) {
            DefaultHttp2ResetFrame defaultHttp2ResetFrame = new DefaultHttp2ResetFrame(l);
            defaultHttp2ResetFrame.setStreamId(n);
            channelHandlerContext.fireChannelRead(defaultHttp2ResetFrame);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) {
            this.onHeadersRead(channelHandlerContext, n, http2Headers, n3, bl2);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) {
            DefaultHttp2HeadersFrame defaultHttp2HeadersFrame = new DefaultHttp2HeadersFrame(http2Headers, bl, n2);
            defaultHttp2HeadersFrame.setStreamId(n);
            channelHandlerContext.fireChannelRead(defaultHttp2HeadersFrame);
        }

        @Override
        public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) {
            DefaultHttp2DataFrame defaultHttp2DataFrame = new DefaultHttp2DataFrame(byteBuf.retain(), bl, n2);
            defaultHttp2DataFrame.setStreamId(n);
            channelHandlerContext.fireChannelRead(defaultHttp2DataFrame);
            return 0;
        }
    }

    private static final class InternalHttp2ConnectionHandler
    extends Http2ConnectionHandler {
        InternalHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings) {
            super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onStreamError(ChannelHandlerContext channelHandlerContext, Throwable throwable, Http2Exception.StreamException streamException) {
            try {
                Http2Stream http2Stream = this.connection().stream(streamException.streamId());
                if (http2Stream == null) {
                    return;
                }
                channelHandlerContext.fireExceptionCaught(streamException);
            }
            finally {
                super.onStreamError(channelHandlerContext, throwable, streamException);
            }
        }
    }

    private final class ConnectionListener
    extends Http2ConnectionAdapter {
        private ConnectionListener() {
        }

        @Override
        public void onStreamActive(Http2Stream http2Stream) {
            if (Http2FrameCodec.this.ctx == null) {
                return;
            }
            Http2FrameCodec.this.ctx.fireUserEventTriggered(new Http2StreamActiveEvent(http2Stream.id()));
        }

        @Override
        public void onStreamClosed(Http2Stream http2Stream) {
            Http2FrameCodec.this.ctx.fireUserEventTriggered(new Http2StreamClosedEvent(http2Stream.id()));
        }

        @Override
        public void onGoAwayReceived(int n, long l, ByteBuf byteBuf) {
            Http2FrameCodec.this.ctx.fireChannelRead(new DefaultHttp2GoAwayFrame(n, l, byteBuf));
        }
    }
}

