/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import io.netty.util.BooleanSupplier;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;

public class DefaultHttp2RemoteFlowController
implements Http2RemoteFlowController {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2RemoteFlowController.class);
    private static final int MIN_WRITABLE_CHUNK = 32768;
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private final StreamByteDistributor streamByteDistributor;
    private final FlowState connectionState;
    private int initialWindowSize = 65535;
    private WritabilityMonitor monitor;
    private ChannelHandlerContext ctx;

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection) {
        this(http2Connection, (Http2RemoteFlowController.Listener)null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, StreamByteDistributor streamByteDistributor) {
        this(http2Connection, streamByteDistributor, null);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, Http2RemoteFlowController.Listener listener) {
        this(http2Connection, new WeightedFairQueueByteDistributor(http2Connection), listener);
    }

    public DefaultHttp2RemoteFlowController(Http2Connection http2Connection, StreamByteDistributor streamByteDistributor, Http2RemoteFlowController.Listener listener) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.streamByteDistributor = ObjectUtil.checkNotNull(streamByteDistributor, "streamWriteDistributor");
        this.stateKey = http2Connection.newKey();
        this.connectionState = new FlowState(http2Connection.connectionStream());
        http2Connection.connectionStream().setProperty(this.stateKey, this.connectionState);
        this.listener(listener);
        this.monitor.windowSize(this.connectionState, this.initialWindowSize);
        http2Connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream http2Stream) {
                http2Stream.setProperty(DefaultHttp2RemoteFlowController.this.stateKey, new FlowState(http2Stream));
            }

            @Override
            public void onStreamActive(Http2Stream http2Stream) {
                DefaultHttp2RemoteFlowController.this.monitor.windowSize(DefaultHttp2RemoteFlowController.this.state(http2Stream), DefaultHttp2RemoteFlowController.this.initialWindowSize);
            }

            @Override
            public void onStreamClosed(Http2Stream http2Stream) {
                DefaultHttp2RemoteFlowController.this.state(http2Stream).cancel();
            }

            @Override
            public void onStreamHalfClosed(Http2Stream http2Stream) {
                if (Http2Stream.State.HALF_CLOSED_LOCAL.equals((Object)http2Stream.state())) {
                    DefaultHttp2RemoteFlowController.this.state(http2Stream).cancel();
                }
            }
        });
    }

    @Override
    public void channelHandlerContext(ChannelHandlerContext channelHandlerContext) throws Http2Exception {
        this.ctx = ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
        this.channelWritabilityChanged();
        if (this.isChannelWritable()) {
            this.writePendingBytes();
        }
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.ctx;
    }

    @Override
    public void initialWindowSize(int n) throws Http2Exception {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.initialWindowSize(n);
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    @Override
    public int windowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).windowSize();
    }

    @Override
    public boolean isWritable(Http2Stream http2Stream) {
        return this.monitor.isWritable(this.state(http2Stream));
    }

    @Override
    public void channelWritabilityChanged() throws Http2Exception {
        this.monitor.channelWritabilityChange();
    }

    private boolean isChannelWritable() {
        return this.ctx != null && this.isChannelWritable0();
    }

    private boolean isChannelWritable0() {
        return this.ctx.channel().isWritable();
    }

    @Override
    public void listener(Http2RemoteFlowController.Listener listener) {
        this.monitor = listener == null ? new WritabilityMonitor() : new ListenerWritabilityMonitor(listener);
    }

    @Override
    public void incrementWindowSize(Http2Stream http2Stream, int n) throws Http2Exception {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        this.monitor.incrementWindowSize(this.state(http2Stream), n);
    }

    @Override
    public void addFlowControlled(Http2Stream http2Stream, Http2RemoteFlowController.FlowControlled flowControlled) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        ObjectUtil.checkNotNull(flowControlled, "frame");
        try {
            this.monitor.enqueueFrame(this.state(http2Stream), flowControlled);
        }
        catch (Throwable throwable) {
            flowControlled.error(this.ctx, throwable);
        }
    }

    @Override
    public boolean hasFlowControlled(Http2Stream http2Stream) {
        return this.state(http2Stream).hasFrame();
    }

    private FlowState state(Http2Stream http2Stream) {
        return (FlowState)http2Stream.getProperty(this.stateKey);
    }

    private int connectionWindowSize() {
        return this.connectionState.windowSize();
    }

    private int minUsableChannelBytes() {
        return Math.max(this.ctx.channel().config().getWriteBufferLowWaterMark(), 32768);
    }

    private int maxUsableChannelBytes() {
        int n = (int)Math.min(Integer.MAX_VALUE, this.ctx.channel().bytesBeforeUnwritable());
        int n2 = n > 0 ? Math.max(n, this.minUsableChannelBytes()) : 0;
        return Math.min(this.connectionState.windowSize(), n2);
    }

    private int writableBytes() {
        return Math.min(this.connectionWindowSize(), this.maxUsableChannelBytes());
    }

    @Override
    public void writePendingBytes() throws Http2Exception {
        this.monitor.writePendingBytes();
    }

    private final class ListenerWritabilityMonitor
    extends WritabilityMonitor {
        private final Http2RemoteFlowController.Listener listener;
        private final Http2StreamVisitor checkStreamWritabilityVisitor;

        ListenerWritabilityMonitor(Http2RemoteFlowController.Listener listener) {
            this.checkStreamWritabilityVisitor = new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream http2Stream) throws Http2Exception {
                    FlowState flowState = DefaultHttp2RemoteFlowController.this.state(http2Stream);
                    if (ListenerWritabilityMonitor.this.isWritable(flowState) != flowState.markedWritability()) {
                        ListenerWritabilityMonitor.this.notifyWritabilityChanged(flowState);
                    }
                    return true;
                }
            };
            this.listener = listener;
        }

        @Override
        void windowSize(FlowState flowState, int n) {
            super.windowSize(flowState, n);
            try {
                this.checkStateWritability(flowState);
            }
            catch (Http2Exception http2Exception) {
                throw new RuntimeException("Caught unexpected exception from window", http2Exception);
            }
        }

        @Override
        void incrementWindowSize(FlowState flowState, int n) throws Http2Exception {
            super.incrementWindowSize(flowState, n);
            this.checkStateWritability(flowState);
        }

        @Override
        void initialWindowSize(int n) throws Http2Exception {
            super.initialWindowSize(n);
            if (this.isWritableConnection()) {
                this.checkAllWritabilityChanged();
            }
        }

        @Override
        void enqueueFrame(FlowState flowState, Http2RemoteFlowController.FlowControlled flowControlled) throws Http2Exception {
            super.enqueueFrame(flowState, flowControlled);
            this.checkConnectionThenStreamWritabilityChanged(flowState);
        }

        @Override
        void stateCancelled(FlowState flowState) {
            try {
                this.checkConnectionThenStreamWritabilityChanged(flowState);
            }
            catch (Http2Exception http2Exception) {
                throw new RuntimeException("Caught unexpected exception from checkAllWritabilityChanged", http2Exception);
            }
        }

        @Override
        void channelWritabilityChange() throws Http2Exception {
            if (DefaultHttp2RemoteFlowController.this.connectionState.markedWritability() != DefaultHttp2RemoteFlowController.this.isChannelWritable()) {
                this.checkAllWritabilityChanged();
            }
        }

        private void checkStateWritability(FlowState flowState) throws Http2Exception {
            if (this.isWritable(flowState) != flowState.markedWritability()) {
                if (flowState == DefaultHttp2RemoteFlowController.this.connectionState) {
                    this.checkAllWritabilityChanged();
                } else {
                    this.notifyWritabilityChanged(flowState);
                }
            }
        }

        private void notifyWritabilityChanged(FlowState flowState) {
            flowState.markedWritability(!flowState.markedWritability());
            try {
                this.listener.writabilityChanged(flowState.stream);
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener.writabilityChanged", throwable);
            }
        }

        private void checkConnectionThenStreamWritabilityChanged(FlowState flowState) throws Http2Exception {
            if (this.isWritableConnection() != DefaultHttp2RemoteFlowController.this.connectionState.markedWritability()) {
                this.checkAllWritabilityChanged();
            } else if (this.isWritable(flowState) != flowState.markedWritability()) {
                this.notifyWritabilityChanged(flowState);
            }
        }

        private void checkAllWritabilityChanged() throws Http2Exception {
            DefaultHttp2RemoteFlowController.this.connectionState.markedWritability(this.isWritableConnection());
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(this.checkStreamWritabilityVisitor);
        }
    }

    private class WritabilityMonitor {
        private boolean inWritePendingBytes;
        private long totalPendingBytes;
        private final StreamByteDistributor.Writer writer = new StreamByteDistributor.Writer(){

            @Override
            public void write(Http2Stream http2Stream, int n) {
                DefaultHttp2RemoteFlowController.this.state(http2Stream).writeAllocatedBytes(n);
            }
        };

        private WritabilityMonitor() {
        }

        void channelWritabilityChange() throws Http2Exception {
        }

        void stateCancelled(FlowState flowState) {
        }

        void windowSize(FlowState flowState, int n) {
            flowState.windowSize(n);
        }

        void incrementWindowSize(FlowState flowState, int n) throws Http2Exception {
            flowState.incrementStreamWindow(n);
        }

        void enqueueFrame(FlowState flowState, Http2RemoteFlowController.FlowControlled flowControlled) throws Http2Exception {
            flowState.enqueueFrame(flowControlled);
        }

        final void incrementPendingBytes(int n) {
            this.totalPendingBytes += (long)n;
        }

        final boolean isWritable(FlowState flowState) {
            return this.isWritableConnection() && flowState.isWritable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void writePendingBytes() throws Http2Exception {
            if (this.inWritePendingBytes) {
                return;
            }
            this.inWritePendingBytes = true;
            try {
                int n = DefaultHttp2RemoteFlowController.this.writableBytes();
                while (DefaultHttp2RemoteFlowController.this.streamByteDistributor.distribute(n, this.writer) && (n = DefaultHttp2RemoteFlowController.this.writableBytes()) > 0 && DefaultHttp2RemoteFlowController.this.isChannelWritable0()) {
                }
            }
            finally {
                this.inWritePendingBytes = false;
            }
        }

        void initialWindowSize(int n) throws Http2Exception {
            if (n < 0) {
                throw new IllegalArgumentException("Invalid initial window size: " + n);
            }
            final int n2 = n - DefaultHttp2RemoteFlowController.this.initialWindowSize;
            DefaultHttp2RemoteFlowController.this.initialWindowSize = n;
            DefaultHttp2RemoteFlowController.this.connection.forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream http2Stream) throws Http2Exception {
                    DefaultHttp2RemoteFlowController.this.state(http2Stream).incrementStreamWindow(n2);
                    return true;
                }
            });
            if (n2 > 0 && DefaultHttp2RemoteFlowController.this.isChannelWritable()) {
                this.writePendingBytes();
            }
        }

        final boolean isWritableConnection() {
            return (long)DefaultHttp2RemoteFlowController.this.connectionState.windowSize() - this.totalPendingBytes > 0L && DefaultHttp2RemoteFlowController.this.isChannelWritable();
        }
    }

    private final class FlowState
    implements StreamByteDistributor.StreamState {
        private final Http2Stream stream;
        private final Deque<Http2RemoteFlowController.FlowControlled> pendingWriteQueue;
        private int window;
        private int pendingBytes;
        private boolean markedWritable;
        private boolean writing;
        private boolean cancelled;
        private BooleanSupplier isWritableSupplier = new BooleanSupplier(){

            @Override
            public boolean get() throws Exception {
                return FlowState.this.windowSize() - FlowState.this.pendingBytes() > 0;
            }
        };

        FlowState(Http2Stream http2Stream) {
            this.stream = http2Stream;
            this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController.FlowControlled>(2);
        }

        boolean isWritable() {
            try {
                return this.isWritableSupplier.get();
            }
            catch (Throwable throwable) {
                throw new Error("isWritableSupplier should never throw!", throwable);
            }
        }

        @Override
        public Http2Stream stream() {
            return this.stream;
        }

        boolean markedWritability() {
            return this.markedWritable;
        }

        void markedWritability(boolean bl) {
            this.markedWritable = bl;
        }

        @Override
        public int windowSize() {
            return this.window;
        }

        void windowSize(int n) {
            this.window = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int writeAllocatedBytes(int n) {
            int n2;
            int n3 = n;
            Throwable throwable = null;
            try {
                int n4;
                Http2RemoteFlowController.FlowControlled flowControlled;
                assert (!this.writing);
                this.writing = true;
                boolean bl = false;
                while (!(this.cancelled || (flowControlled = this.peek()) == null || (n4 = Math.min(n, this.writableWindow())) <= 0 && flowControlled.size() > 0)) {
                    bl = true;
                    int n5 = flowControlled.size();
                    try {
                        flowControlled.write(DefaultHttp2RemoteFlowController.this.ctx, Math.max(0, n4));
                        if (flowControlled.size() != 0) continue;
                        this.pendingWriteQueue.remove();
                        flowControlled.writeComplete();
                    }
                    finally {
                        n -= n5 - flowControlled.size();
                    }
                }
                if (!bl) {
                    n4 = -1;
                    return n4;
                }
            }
            catch (Throwable throwable2) {
                this.cancelled = true;
                throwable = throwable2;
            }
            finally {
                this.writing = false;
                int n6 = n3 - n;
                this.decrementPendingBytes(n6, false);
                this.decrementFlowControlWindow(n6);
                if (this.cancelled) {
                    this.cancel(throwable);
                }
            }
            return n2;
        }

        int incrementStreamWindow(int n) throws Http2Exception {
            if (n > 0 && Integer.MAX_VALUE - n < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Window size overflow for stream: %d", this.stream.id());
            }
            this.window += n;
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            return this.window;
        }

        private int writableWindow() {
            return Math.min(this.window, DefaultHttp2RemoteFlowController.this.connectionWindowSize());
        }

        @Override
        public int pendingBytes() {
            return this.pendingBytes;
        }

        void enqueueFrame(Http2RemoteFlowController.FlowControlled flowControlled) {
            Http2RemoteFlowController.FlowControlled flowControlled2 = this.pendingWriteQueue.peekLast();
            if (flowControlled2 == null) {
                this.enqueueFrameWithoutMerge(flowControlled);
                return;
            }
            int n = flowControlled2.size();
            if (flowControlled2.merge(DefaultHttp2RemoteFlowController.this.ctx, flowControlled)) {
                this.incrementPendingBytes(flowControlled2.size() - n, true);
                return;
            }
            this.enqueueFrameWithoutMerge(flowControlled);
        }

        private void enqueueFrameWithoutMerge(Http2RemoteFlowController.FlowControlled flowControlled) {
            this.pendingWriteQueue.offer(flowControlled);
            this.incrementPendingBytes(flowControlled.size(), true);
        }

        @Override
        public boolean hasFrame() {
            return !this.pendingWriteQueue.isEmpty();
        }

        private Http2RemoteFlowController.FlowControlled peek() {
            return this.pendingWriteQueue.peek();
        }

        void cancel() {
            this.cancel(null);
        }

        private void cancel(Throwable throwable) {
            Http2RemoteFlowController.FlowControlled flowControlled;
            this.cancelled = true;
            if (this.writing) {
                return;
            }
            while ((flowControlled = this.pendingWriteQueue.poll()) != null) {
                this.writeError(flowControlled, Http2Exception.streamError(this.stream.id(), Http2Error.INTERNAL_ERROR, throwable, "Stream closed before write could take place", new Object[0]));
            }
            DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            this.isWritableSupplier = BooleanSupplier.FALSE_SUPPLIER;
            DefaultHttp2RemoteFlowController.this.monitor.stateCancelled(this);
        }

        private void incrementPendingBytes(int n, boolean bl) {
            this.pendingBytes += n;
            DefaultHttp2RemoteFlowController.this.monitor.incrementPendingBytes(n);
            if (bl) {
                DefaultHttp2RemoteFlowController.this.streamByteDistributor.updateStreamableBytes(this);
            }
        }

        private void decrementPendingBytes(int n, boolean bl) {
            this.incrementPendingBytes(-n, bl);
        }

        private void decrementFlowControlWindow(int n) {
            try {
                int n2 = -n;
                DefaultHttp2RemoteFlowController.this.connectionState.incrementStreamWindow(n2);
                this.incrementStreamWindow(n2);
            }
            catch (Http2Exception http2Exception) {
                throw new IllegalStateException("Invalid window state when writing frame: " + http2Exception.getMessage(), http2Exception);
            }
        }

        private void writeError(Http2RemoteFlowController.FlowControlled flowControlled, Http2Exception http2Exception) {
            assert (DefaultHttp2RemoteFlowController.this.ctx != null);
            this.decrementPendingBytes(flowControlled.size(), true);
            flowControlled.error(DefaultHttp2RemoteFlowController.this.ctx, http2Exception);
        }
    }
}

