/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.collection.IntCollections;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.UnaryPromiseNotifier;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class DefaultHttp2Connection
implements Http2Connection {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2Connection.class);
    final IntObjectMap<Http2Stream> streamMap = new IntObjectHashMap<Http2Stream>();
    final PropertyKeyRegistry propertyKeyRegistry = new PropertyKeyRegistry();
    final ConnectionStream connectionStream = new ConnectionStream();
    final DefaultEndpoint<Http2LocalFlowController> localEndpoint;
    final DefaultEndpoint<Http2RemoteFlowController> remoteEndpoint;
    private static final int INITIAL_CHILDREN_MAP_SIZE = Math.max(1, SystemPropertyUtil.getInt("io.netty.http2.childrenMapSize", 4));
    final List<Http2Connection.Listener> listeners = new ArrayList<Http2Connection.Listener>(4);
    final ActiveStreams activeStreams = new ActiveStreams(this.listeners);
    Promise<Void> closePromise;

    public DefaultHttp2Connection(boolean bl) {
        this.localEndpoint = new DefaultEndpoint(bl);
        this.remoteEndpoint = new DefaultEndpoint(!bl);
        this.streamMap.put(this.connectionStream.id(), (Http2Stream)this.connectionStream);
    }

    final boolean isClosed() {
        return this.closePromise != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close(Promise<Void> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        if (this.closePromise != null) {
            if (this.closePromise != promise) {
                if (promise instanceof ChannelPromise && ((ChannelPromise)this.closePromise).isVoid()) {
                    this.closePromise = promise;
                } else {
                    this.closePromise.addListener(new UnaryPromiseNotifier<Void>(promise));
                }
            }
        } else {
            this.closePromise = promise;
        }
        if (this.isStreamMapEmpty()) {
            promise.trySuccess(null);
            return promise;
        }
        Iterator<IntObjectMap.PrimitiveEntry<Http2Stream>> iterator = this.streamMap.entries().iterator();
        if (this.activeStreams.allowModifications()) {
            this.activeStreams.incrementPendingIterations();
            try {
                while (iterator.hasNext()) {
                    DefaultStream defaultStream = (DefaultStream)iterator.next().value();
                    if (defaultStream.id() == 0) continue;
                    defaultStream.close(iterator);
                }
            }
            finally {
                this.activeStreams.decrementPendingIterations();
            }
        } else {
            while (iterator.hasNext()) {
                Http2Stream http2Stream = iterator.next().value();
                if (http2Stream.id() == 0) continue;
                http2Stream.close();
            }
        }
        return this.closePromise;
    }

    @Override
    public void addListener(Http2Connection.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Http2Connection.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isServer() {
        return this.localEndpoint.isServer();
    }

    @Override
    public Http2Stream connectionStream() {
        return this.connectionStream;
    }

    @Override
    public Http2Stream stream(int n) {
        return this.streamMap.get(n);
    }

    @Override
    public boolean streamMayHaveExisted(int n) {
        return this.remoteEndpoint.mayHaveCreatedStream(n) || this.localEndpoint.mayHaveCreatedStream(n);
    }

    @Override
    public int numActiveStreams() {
        return this.activeStreams.size();
    }

    @Override
    public Http2Stream forEachActiveStream(Http2StreamVisitor http2StreamVisitor) throws Http2Exception {
        return this.activeStreams.forEachActiveStream(http2StreamVisitor);
    }

    @Override
    public Http2Connection.Endpoint<Http2LocalFlowController> local() {
        return this.localEndpoint;
    }

    @Override
    public Http2Connection.Endpoint<Http2RemoteFlowController> remote() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean goAwayReceived() {
        return ((DefaultEndpoint)this.localEndpoint).lastStreamKnownByPeer >= 0;
    }

    @Override
    public void goAwayReceived(final int n, long l, ByteBuf byteBuf) {
        ((DefaultEndpoint)this.localEndpoint).lastStreamKnownByPeer(n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onGoAwayReceived(n, l, byteBuf);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onGoAwayReceived.", throwable);
            }
        }
        try {
            this.forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream http2Stream) {
                    if (http2Stream.id() > n && DefaultHttp2Connection.this.localEndpoint.isValidStreamId(http2Stream.id())) {
                        http2Stream.close();
                    }
                    return true;
                }
            });
        }
        catch (Http2Exception http2Exception) {
            PlatformDependent.throwException(http2Exception);
        }
    }

    @Override
    public boolean goAwaySent() {
        return ((DefaultEndpoint)this.remoteEndpoint).lastStreamKnownByPeer >= 0;
    }

    @Override
    public void goAwaySent(final int n, long l, ByteBuf byteBuf) {
        ((DefaultEndpoint)this.remoteEndpoint).lastStreamKnownByPeer(n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onGoAwaySent(n, l, byteBuf);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onGoAwaySent.", throwable);
            }
        }
        try {
            this.forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream http2Stream) {
                    if (http2Stream.id() > n && DefaultHttp2Connection.this.remoteEndpoint.isValidStreamId(http2Stream.id())) {
                        http2Stream.close();
                    }
                    return true;
                }
            });
        }
        catch (Http2Exception http2Exception) {
            PlatformDependent.throwException(http2Exception);
        }
    }

    private boolean isStreamMapEmpty() {
        return this.streamMap.size() == 1;
    }

    void removeStream(DefaultStream defaultStream, Iterator<?> iterator) {
        if (defaultStream.parent().removeChild(defaultStream)) {
            if (iterator == null) {
                this.streamMap.remove(defaultStream.id());
            } else {
                iterator.remove();
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    this.listeners.get(i).onStreamRemoved(defaultStream);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.error("Caught Throwable from listener onStreamRemoved.", throwable);
                }
            }
            if (this.closePromise != null && this.isStreamMapEmpty()) {
                this.closePromise.trySuccess(null);
            }
        }
    }

    static Http2Stream.State activeState(int n, Http2Stream.State state, boolean bl, boolean bl2) throws Http2Exception {
        switch (state) {
            case IDLE: {
                return bl2 ? (bl ? Http2Stream.State.HALF_CLOSED_LOCAL : Http2Stream.State.HALF_CLOSED_REMOTE) : Http2Stream.State.OPEN;
            }
            case RESERVED_LOCAL: {
                return Http2Stream.State.HALF_CLOSED_REMOTE;
            }
            case RESERVED_REMOTE: {
                return Http2Stream.State.HALF_CLOSED_LOCAL;
            }
        }
        throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Attempting to open a stream in an invalid state: " + (Object)((Object)state), new Object[0]);
    }

    void notifyHalfClosed(Http2Stream http2Stream) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onStreamHalfClosed(http2Stream);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onStreamHalfClosed.", throwable);
            }
        }
    }

    void notifyClosed(Http2Stream http2Stream) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onStreamClosed(http2Stream);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onStreamClosed.", throwable);
            }
        }
    }

    @Override
    public Http2Connection.PropertyKey newKey() {
        return this.propertyKeyRegistry.newKey();
    }

    final DefaultPropertyKey verifyKey(Http2Connection.PropertyKey propertyKey) {
        return ObjectUtil.checkNotNull((DefaultPropertyKey)propertyKey, "key").verifyConnection(this);
    }

    private void notifyParentChanged(List<ParentChangedEvent> list) {
        for (int i = 0; i < list.size(); ++i) {
            ParentChangedEvent parentChangedEvent = list.get(i);
            for (int j = 0; j < this.listeners.size(); ++j) {
                parentChangedEvent.notifyListener(this.listeners.get(j));
            }
        }
    }

    private void notifyParentChanging(Http2Stream http2Stream, Http2Stream http2Stream2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).onPriorityTreeParentChanging(http2Stream, http2Stream2);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onPriorityTreeParentChanging.", throwable);
            }
        }
    }

    private final class PropertyKeyRegistry {
        final List<DefaultPropertyKey> keys = new ArrayList<DefaultPropertyKey>(4);

        private PropertyKeyRegistry() {
        }

        DefaultPropertyKey newKey() {
            DefaultPropertyKey defaultPropertyKey = new DefaultPropertyKey(this.keys.size());
            this.keys.add(defaultPropertyKey);
            return defaultPropertyKey;
        }

        int size() {
            return this.keys.size();
        }
    }

    final class DefaultPropertyKey
    implements Http2Connection.PropertyKey {
        final int index;

        DefaultPropertyKey(int n) {
            this.index = n;
        }

        DefaultPropertyKey verifyConnection(Http2Connection http2Connection) {
            if (http2Connection != DefaultHttp2Connection.this) {
                throw new IllegalArgumentException("Using a key that was not created by this connection");
            }
            return this;
        }
    }

    private final class ActiveStreams {
        private final List<Http2Connection.Listener> listeners;
        private final Queue<Event> pendingEvents = new ArrayDeque<Event>(4);
        private final Set<Http2Stream> streams = new LinkedHashSet<Http2Stream>();
        private int pendingIterations;

        public ActiveStreams(List<Http2Connection.Listener> list) {
            this.listeners = list;
        }

        public int size() {
            return this.streams.size();
        }

        public void activate(final DefaultStream defaultStream) {
            if (this.allowModifications()) {
                this.addToActiveStreams(defaultStream);
            } else {
                this.pendingEvents.add(new Event(){

                    @Override
                    public void process() {
                        ActiveStreams.this.addToActiveStreams(defaultStream);
                    }
                });
            }
        }

        public void deactivate(final DefaultStream defaultStream, final Iterator<?> iterator) {
            if (this.allowModifications() || iterator != null) {
                this.removeFromActiveStreams(defaultStream, iterator);
            } else {
                this.pendingEvents.add(new Event(){

                    @Override
                    public void process() {
                        if (defaultStream.parent() == null) {
                            return;
                        }
                        ActiveStreams.this.removeFromActiveStreams(defaultStream, iterator);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Http2Stream forEachActiveStream(Http2StreamVisitor http2StreamVisitor) throws Http2Exception {
            this.incrementPendingIterations();
            try {
                for (Http2Stream http2Stream : this.streams) {
                    if (http2StreamVisitor.visit(http2Stream)) continue;
                    Http2Stream http2Stream2 = http2Stream;
                    return http2Stream2;
                }
                Iterator<Http2Stream> iterator = null;
                return iterator;
            }
            finally {
                this.decrementPendingIterations();
            }
        }

        void addToActiveStreams(DefaultStream defaultStream) {
            if (this.streams.add(defaultStream)) {
                ++defaultStream.createdBy().numActiveStreams;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        this.listeners.get(i).onStreamActive(defaultStream);
                        continue;
                    }
                    catch (Throwable throwable) {
                        logger.error("Caught Throwable from listener onStreamActive.", throwable);
                    }
                }
            }
        }

        void removeFromActiveStreams(DefaultStream defaultStream, Iterator<?> iterator) {
            if (this.streams.remove(defaultStream)) {
                --defaultStream.createdBy().numActiveStreams;
                DefaultHttp2Connection.this.notifyClosed(defaultStream);
            }
            DefaultHttp2Connection.this.removeStream(defaultStream, iterator);
        }

        boolean allowModifications() {
            return this.pendingIterations == 0;
        }

        void incrementPendingIterations() {
            ++this.pendingIterations;
        }

        void decrementPendingIterations() {
            --this.pendingIterations;
            if (this.allowModifications()) {
                Event event;
                while ((event = this.pendingEvents.poll()) != null) {
                    try {
                        event.process();
                    }
                    catch (Throwable throwable) {
                        logger.error("Caught Throwable while processing pending ActiveStreams$Event.", throwable);
                    }
                }
            }
        }
    }

    static interface Event {
        public void process();
    }

    private final class DefaultEndpoint<F extends Http2FlowController>
    implements Http2Connection.Endpoint<F> {
        private final boolean server;
        private int nextStreamIdToCreate;
        private int nextReservationStreamId;
        private int lastStreamKnownByPeer = -1;
        private boolean pushToAllowed = true;
        private F flowController;
        private int maxActiveStreams;
        int numActiveStreams;

        DefaultEndpoint(boolean bl) {
            this.server = bl;
            if (bl) {
                this.nextStreamIdToCreate = 2;
                this.nextReservationStreamId = 0;
            } else {
                this.nextStreamIdToCreate = 1;
                this.nextReservationStreamId = 1;
            }
            this.pushToAllowed = !bl;
            this.maxActiveStreams = Integer.MAX_VALUE;
        }

        @Override
        public int incrementAndGetNextStreamId() {
            return this.nextReservationStreamId >= 0 ? (this.nextReservationStreamId = this.nextReservationStreamId + 2) : this.nextReservationStreamId;
        }

        private void incrementExpectedStreamId(int n) {
            if (n > this.nextReservationStreamId && this.nextReservationStreamId >= 0) {
                this.nextReservationStreamId = n;
            }
            this.nextStreamIdToCreate = n + 2;
        }

        @Override
        public boolean isValidStreamId(int n) {
            boolean bl = (n & 1) == 0;
            return n > 0 && this.server == bl;
        }

        @Override
        public boolean mayHaveCreatedStream(int n) {
            return this.isValidStreamId(n) && n <= this.lastStreamCreated();
        }

        @Override
        public boolean canOpenStream() {
            return this.numActiveStreams + 1 <= this.maxActiveStreams;
        }

        private DefaultStream createStream(int n, Http2Stream.State state) throws Http2Exception {
            this.checkNewStreamAllowed(n, state);
            DefaultStream defaultStream = new DefaultStream(n, state);
            this.incrementExpectedStreamId(n);
            this.addStream(defaultStream);
            return defaultStream;
        }

        @Override
        public DefaultStream createIdleStream(int n) throws Http2Exception {
            return this.createStream(n, Http2Stream.State.IDLE);
        }

        @Override
        public DefaultStream createStream(int n, boolean bl) throws Http2Exception {
            DefaultStream defaultStream = this.createStream(n, DefaultHttp2Connection.activeState(n, Http2Stream.State.IDLE, this.isLocal(), bl));
            defaultStream.activate();
            return defaultStream;
        }

        @Override
        public boolean created(Http2Stream http2Stream) {
            return http2Stream instanceof DefaultStream && ((DefaultStream)http2Stream).createdBy() == this;
        }

        @Override
        public boolean isServer() {
            return this.server;
        }

        @Override
        public DefaultStream reservePushStream(int n, Http2Stream http2Stream) throws Http2Exception {
            if (http2Stream == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Parent stream missing", new Object[0]);
            }
            if (this.isLocal() ? !http2Stream.state().localSideOpen() : !http2Stream.state().remoteSideOpen()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d is not open for sending push promise", http2Stream.id());
            }
            if (!this.opposite().allowPushTo()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server push not allowed to opposite endpoint.", new Object[0]);
            }
            Http2Stream.State state = this.isLocal() ? Http2Stream.State.RESERVED_LOCAL : Http2Stream.State.RESERVED_REMOTE;
            this.checkNewStreamAllowed(n, state);
            DefaultStream defaultStream = new DefaultStream(n, state);
            this.incrementExpectedStreamId(n);
            this.addStream(defaultStream);
            return defaultStream;
        }

        private void addStream(DefaultStream defaultStream) {
            DefaultHttp2Connection.this.streamMap.put(defaultStream.id(), (Http2Stream)defaultStream);
            ArrayList<ParentChangedEvent> arrayList = new ArrayList<ParentChangedEvent>(1);
            DefaultHttp2Connection.this.connectionStream.takeChild(defaultStream, false, arrayList);
            for (int i = 0; i < DefaultHttp2Connection.this.listeners.size(); ++i) {
                try {
                    DefaultHttp2Connection.this.listeners.get(i).onStreamAdded(defaultStream);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.error("Caught Throwable from listener onStreamAdded.", throwable);
                }
            }
            DefaultHttp2Connection.this.notifyParentChanged(arrayList);
        }

        @Override
        public void allowPushTo(boolean bl) {
            if (bl && this.server) {
                throw new IllegalArgumentException("Servers do not allow push");
            }
            this.pushToAllowed = bl;
        }

        @Override
        public boolean allowPushTo() {
            return this.pushToAllowed;
        }

        @Override
        public int numActiveStreams() {
            return this.numActiveStreams;
        }

        @Override
        public int maxActiveStreams() {
            return this.maxActiveStreams;
        }

        @Override
        public void maxActiveStreams(int n) {
            this.maxActiveStreams = n;
        }

        @Override
        public int lastStreamCreated() {
            return this.nextStreamIdToCreate > 1 ? this.nextStreamIdToCreate - 2 : 0;
        }

        @Override
        public int lastStreamKnownByPeer() {
            return this.lastStreamKnownByPeer;
        }

        private void lastStreamKnownByPeer(int n) {
            this.lastStreamKnownByPeer = n;
        }

        @Override
        public F flowController() {
            return this.flowController;
        }

        @Override
        public void flowController(F f) {
            this.flowController = (Http2FlowController)ObjectUtil.checkNotNull(f, "flowController");
        }

        @Override
        public Http2Connection.Endpoint<? extends Http2FlowController> opposite() {
            return this.isLocal() ? DefaultHttp2Connection.this.remoteEndpoint : DefaultHttp2Connection.this.localEndpoint;
        }

        private void checkNewStreamAllowed(int n, Http2Stream.State state) throws Http2Exception {
            if (DefaultHttp2Connection.this.goAwayReceived() && n > DefaultHttp2Connection.this.localEndpoint.lastStreamKnownByPeer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Cannot create stream %d since this endpoint has received a GOAWAY frame with last stream id %d.", n, DefaultHttp2Connection.this.localEndpoint.lastStreamKnownByPeer());
            }
            if (n < 0) {
                throw new Http2NoMoreStreamIdsException();
            }
            if (!this.isValidStreamId(n)) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Request stream %d is not correct for %s connection", n, this.server ? "server" : "client");
            }
            if (n < this.nextStreamIdToCreate) {
                throw Http2Exception.closedStreamError(Http2Error.PROTOCOL_ERROR, "Request stream %d is behind the next expected stream %d", n, this.nextStreamIdToCreate);
            }
            if (this.nextStreamIdToCreate <= 0) {
                throw Http2Exception.connectionError(Http2Error.REFUSED_STREAM, "Stream IDs are exhausted for this endpoint.", new Object[0]);
            }
            if ((state.localSideOpen() || state.remoteSideOpen()) && !this.canOpenStream()) {
                throw Http2Exception.connectionError(Http2Error.REFUSED_STREAM, "Maximum active streams violated for this endpoint.", new Object[0]);
            }
            if (DefaultHttp2Connection.this.isClosed()) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Attempted to create stream id %d after connection was closed", n);
            }
        }

        private boolean isLocal() {
            return this == DefaultHttp2Connection.this.localEndpoint;
        }
    }

    private final class ConnectionStream
    extends DefaultStream {
        ConnectionStream() {
            super(0, Http2Stream.State.IDLE);
        }

        @Override
        public boolean isResetSent() {
            return false;
        }

        @Override
        DefaultEndpoint<? extends Http2FlowController> createdBy() {
            return null;
        }

        @Override
        public Http2Stream resetSent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Http2Stream setPriority(int n, short s, boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Http2Stream open(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Http2Stream close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Http2Stream closeLocalSide() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Http2Stream closeRemoteSide() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ParentChangedEvent {
        private final Http2Stream stream;
        private final Http2Stream oldParent;

        ParentChangedEvent(Http2Stream http2Stream, Http2Stream http2Stream2) {
            this.stream = http2Stream;
            this.oldParent = http2Stream2;
        }

        public void notifyListener(Http2Connection.Listener listener) {
            try {
                listener.onPriorityTreeParentChanged(this.stream, this.oldParent);
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onPriorityTreeParentChanged.", throwable);
            }
        }
    }

    private class DefaultStream
    implements Http2Stream {
        private final int id;
        private final PropertyMap properties = new PropertyMap();
        private Http2Stream.State state;
        private short weight = (short)16;
        private DefaultStream parent;
        private IntObjectMap<DefaultStream> children = IntCollections.emptyMap();
        private boolean resetSent;

        DefaultStream(int n, Http2Stream.State state) {
            this.id = n;
            this.state = state;
        }

        @Override
        public final int id() {
            return this.id;
        }

        @Override
        public final Http2Stream.State state() {
            return this.state;
        }

        @Override
        public boolean isResetSent() {
            return this.resetSent;
        }

        @Override
        public Http2Stream resetSent() {
            this.resetSent = true;
            return this;
        }

        @Override
        public final <V> V setProperty(Http2Connection.PropertyKey propertyKey, V v) {
            return this.properties.add(DefaultHttp2Connection.this.verifyKey(propertyKey), v);
        }

        @Override
        public final <V> V getProperty(Http2Connection.PropertyKey propertyKey) {
            return this.properties.get(DefaultHttp2Connection.this.verifyKey(propertyKey));
        }

        @Override
        public final <V> V removeProperty(Http2Connection.PropertyKey propertyKey) {
            return this.properties.remove(DefaultHttp2Connection.this.verifyKey(propertyKey));
        }

        @Override
        public final boolean isRoot() {
            return this.parent == null;
        }

        @Override
        public final short weight() {
            return this.weight;
        }

        @Override
        public final DefaultStream parent() {
            return this.parent;
        }

        @Override
        public final boolean isDescendantOf(Http2Stream http2Stream) {
            for (Http2Stream http2Stream2 = this.parent(); http2Stream2 != null; http2Stream2 = http2Stream2.parent()) {
                if (http2Stream2 != http2Stream) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean isLeaf() {
            return this.numChildren() == 0;
        }

        @Override
        public final int numChildren() {
            return this.children.size();
        }

        @Override
        public Http2Stream forEachChild(Http2StreamVisitor http2StreamVisitor) throws Http2Exception {
            for (DefaultStream defaultStream : this.children.values()) {
                if (http2StreamVisitor.visit(defaultStream)) continue;
                return defaultStream;
            }
            return null;
        }

        @Override
        public Http2Stream setPriority(int n, short s, boolean bl) throws Http2Exception {
            if (s < 1 || s > 256) {
                throw new IllegalArgumentException(String.format("Invalid weight: %d.  Must be between %d and %d (inclusive).", s, (short)1, (short)256));
            }
            DefaultStream defaultStream = (DefaultStream)DefaultHttp2Connection.this.stream(n);
            if (defaultStream == null) {
                defaultStream = this.createdBy().createIdleStream(n);
            } else if (this == defaultStream) {
                throw new IllegalArgumentException("A stream cannot depend on itself");
            }
            this.weight(s);
            if (defaultStream != this.parent() || bl && defaultStream.numChildren() != 1) {
                ArrayList<ParentChangedEvent> arrayList;
                if (defaultStream.isDescendantOf(this)) {
                    arrayList = new ArrayList<ParentChangedEvent>(2 + (bl ? defaultStream.numChildren() : 0));
                    this.parent.takeChild(defaultStream, false, arrayList);
                } else {
                    arrayList = new ArrayList(1 + (bl ? defaultStream.numChildren() : 0));
                }
                defaultStream.takeChild(this, bl, arrayList);
                DefaultHttp2Connection.this.notifyParentChanged(arrayList);
            }
            return this;
        }

        @Override
        public Http2Stream open(boolean bl) throws Http2Exception {
            this.state = DefaultHttp2Connection.activeState(this.id, this.state, this.isLocal(), bl);
            if (!this.createdBy().canOpenStream()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Maximum active streams violated for this endpoint.", new Object[0]);
            }
            this.activate();
            return this;
        }

        void activate() {
            DefaultHttp2Connection.this.activeStreams.activate(this);
        }

        Http2Stream close(Iterator<?> iterator) {
            if (this.state == Http2Stream.State.CLOSED) {
                return this;
            }
            this.state = Http2Stream.State.CLOSED;
            DefaultHttp2Connection.this.activeStreams.deactivate(this, iterator);
            return this;
        }

        @Override
        public Http2Stream close() {
            return this.close(null);
        }

        @Override
        public Http2Stream closeLocalSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_LOCAL;
                    DefaultHttp2Connection.this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        @Override
        public Http2Stream closeRemoteSide() {
            switch (this.state) {
                case OPEN: {
                    this.state = Http2Stream.State.HALF_CLOSED_REMOTE;
                    DefaultHttp2Connection.this.notifyHalfClosed(this);
                    break;
                }
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    this.close();
                }
            }
            return this;
        }

        private void initChildrenIfEmpty() {
            if (this.children == IntCollections.emptyMap()) {
                this.initChildren();
            }
        }

        private void initChildren() {
            this.children = new IntObjectHashMap<DefaultStream>(INITIAL_CHILDREN_MAP_SIZE);
        }

        DefaultEndpoint<? extends Http2FlowController> createdBy() {
            return DefaultHttp2Connection.this.localEndpoint.isValidStreamId(this.id) ? DefaultHttp2Connection.this.localEndpoint : DefaultHttp2Connection.this.remoteEndpoint;
        }

        final boolean isLocal() {
            return DefaultHttp2Connection.this.localEndpoint.isValidStreamId(this.id);
        }

        final void weight(short s) {
            if (s != this.weight) {
                short s2 = this.weight;
                this.weight = s;
                for (int i = 0; i < DefaultHttp2Connection.this.listeners.size(); ++i) {
                    try {
                        DefaultHttp2Connection.this.listeners.get(i).onWeightChanged(this, s2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        logger.error("Caught Throwable from listener onWeightChanged.", throwable);
                    }
                }
            }
        }

        private IntObjectMap<DefaultStream> retain(DefaultStream defaultStream) {
            defaultStream = this.children.remove(defaultStream.id());
            IntObjectMap<DefaultStream> intObjectMap = this.children;
            this.initChildren();
            if (defaultStream != null) {
                this.children.put(defaultStream.id(), defaultStream);
            }
            return intObjectMap;
        }

        final void takeChild(DefaultStream defaultStream, boolean bl, List<ParentChangedEvent> list) {
            DefaultStream defaultStream2 = defaultStream.parent();
            if (defaultStream2 != this) {
                list.add(new ParentChangedEvent(defaultStream, defaultStream2));
                DefaultHttp2Connection.this.notifyParentChanging(defaultStream, this);
                defaultStream.parent = this;
                if (defaultStream2 != null) {
                    defaultStream2.children.remove(defaultStream.id());
                }
                this.initChildrenIfEmpty();
                Http2Stream http2Stream = this.children.put(defaultStream.id(), defaultStream);
                assert (http2Stream == null) : "A stream with the same stream ID was already in the child map.";
            }
            if (bl && !this.children.isEmpty()) {
                for (DefaultStream defaultStream3 : this.retain(defaultStream).values()) {
                    defaultStream.takeChild(defaultStream3, false, list);
                }
            }
        }

        final boolean removeChild(DefaultStream defaultStream) {
            if (this.children.remove(defaultStream.id()) != null) {
                ArrayList<ParentChangedEvent> arrayList = new ArrayList<ParentChangedEvent>(1 + defaultStream.numChildren());
                arrayList.add(new ParentChangedEvent(defaultStream, defaultStream.parent()));
                DefaultHttp2Connection.this.notifyParentChanging(defaultStream, null);
                defaultStream.parent = null;
                for (DefaultStream defaultStream2 : defaultStream.children.values()) {
                    this.takeChild(defaultStream2, false, arrayList);
                }
                DefaultHttp2Connection.this.notifyParentChanged(arrayList);
                return true;
            }
            return false;
        }

        private class PropertyMap {
            Object[] values = EmptyArrays.EMPTY_OBJECTS;

            private PropertyMap() {
            }

            <V> V add(DefaultPropertyKey defaultPropertyKey, V v) {
                this.resizeIfNecessary(defaultPropertyKey.index);
                Object object = this.values[defaultPropertyKey.index];
                this.values[defaultPropertyKey.index] = v;
                return (V)object;
            }

            <V> V get(DefaultPropertyKey defaultPropertyKey) {
                if (defaultPropertyKey.index >= this.values.length) {
                    return null;
                }
                return (V)this.values[defaultPropertyKey.index];
            }

            <V> V remove(DefaultPropertyKey defaultPropertyKey) {
                Object object = null;
                if (defaultPropertyKey.index < this.values.length) {
                    object = this.values[defaultPropertyKey.index];
                    this.values[defaultPropertyKey.index] = null;
                }
                return (V)object;
            }

            void resizeIfNecessary(int n) {
                if (n >= this.values.length) {
                    this.values = Arrays.copyOf(this.values, DefaultHttp2Connection.this.propertyKeyRegistry.size());
                }
            }
        }
    }
}

