/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cors;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class CorsHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CorsHandler.class);
    private static final String ANY_ORIGIN = "*";
    private static final String NULL_ORIGIN = "null";
    private final CorsConfig config;
    private HttpRequest request;

    public CorsHandler(CorsConfig corsConfig) {
        this.config = ObjectUtil.checkNotNull(corsConfig, "config");
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (this.config.isCorsSupportEnabled() && object instanceof HttpRequest) {
            this.request = (HttpRequest)object;
            if (CorsHandler.isPreflightRequest(this.request)) {
                this.handlePreflight(channelHandlerContext, this.request);
                return;
            }
            if (this.config.isShortCircuit() && !this.validateOrigin()) {
                CorsHandler.forbidden(channelHandlerContext, this.request);
                return;
            }
        }
        channelHandlerContext.fireChannelRead(object);
    }

    private void handlePreflight(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.OK, true, true);
        if (this.setOrigin(defaultFullHttpResponse)) {
            this.setAllowMethods(defaultFullHttpResponse);
            this.setAllowHeaders(defaultFullHttpResponse);
            this.setAllowCredentials(defaultFullHttpResponse);
            this.setMaxAge(defaultFullHttpResponse);
            this.setPreflightHeaders(defaultFullHttpResponse);
        }
        ReferenceCountUtil.release(httpRequest);
        channelHandlerContext.writeAndFlush(defaultFullHttpResponse).addListener(ChannelFutureListener.CLOSE);
    }

    private void setPreflightHeaders(HttpResponse httpResponse) {
        httpResponse.headers().add(this.config.preflightResponseHeaders());
    }

    private boolean setOrigin(HttpResponse httpResponse) {
        String string = this.request.headers().get(HttpHeaderNames.ORIGIN);
        if (string != null) {
            if (NULL_ORIGIN.equals(string) && this.config.isNullOriginAllowed()) {
                CorsHandler.setNullOrigin(httpResponse);
                return true;
            }
            if (this.config.isAnyOriginSupported()) {
                if (this.config.isCredentialsAllowed()) {
                    this.echoRequestOrigin(httpResponse);
                    CorsHandler.setVaryHeader(httpResponse);
                } else {
                    CorsHandler.setAnyOrigin(httpResponse);
                }
                return true;
            }
            if (this.config.origins().contains(string)) {
                CorsHandler.setOrigin(httpResponse, string);
                CorsHandler.setVaryHeader(httpResponse);
                return true;
            }
            logger.debug("Request origin [{}]] was not among the configured origins [{}]", (Object)string, (Object)this.config.origins());
        }
        return false;
    }

    private boolean validateOrigin() {
        if (this.config.isAnyOriginSupported()) {
            return true;
        }
        String string = this.request.headers().get(HttpHeaderNames.ORIGIN);
        if (string == null) {
            return true;
        }
        if (NULL_ORIGIN.equals(string) && this.config.isNullOriginAllowed()) {
            return true;
        }
        return this.config.origins().contains(string);
    }

    private void echoRequestOrigin(HttpResponse httpResponse) {
        CorsHandler.setOrigin(httpResponse, this.request.headers().get(HttpHeaderNames.ORIGIN));
    }

    private static void setVaryHeader(HttpResponse httpResponse) {
        httpResponse.headers().set((CharSequence)HttpHeaderNames.VARY, (Object)HttpHeaderNames.ORIGIN);
    }

    private static void setAnyOrigin(HttpResponse httpResponse) {
        CorsHandler.setOrigin(httpResponse, ANY_ORIGIN);
    }

    private static void setNullOrigin(HttpResponse httpResponse) {
        CorsHandler.setOrigin(httpResponse, NULL_ORIGIN);
    }

    private static void setOrigin(HttpResponse httpResponse, String string) {
        httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)string);
    }

    private void setAllowCredentials(HttpResponse httpResponse) {
        if (this.config.isCredentialsAllowed() && !httpResponse.headers().get(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN).equals(ANY_ORIGIN)) {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
    }

    private static boolean isPreflightRequest(HttpRequest httpRequest) {
        HttpHeaders httpHeaders = httpRequest.headers();
        return httpRequest.method().equals(HttpMethod.OPTIONS) && httpHeaders.contains(HttpHeaderNames.ORIGIN) && httpHeaders.contains(HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
    }

    private void setExposeHeaders(HttpResponse httpResponse) {
        if (!this.config.exposedHeaders().isEmpty()) {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, this.config.exposedHeaders());
        }
    }

    private void setAllowMethods(HttpResponse httpResponse) {
        httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, this.config.allowedRequestMethods());
    }

    private void setAllowHeaders(HttpResponse httpResponse) {
        httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, this.config.allowedRequestHeaders());
    }

    private void setMaxAge(HttpResponse httpResponse) {
        httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, (Object)this.config.maxAge());
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        HttpResponse httpResponse;
        if (this.config.isCorsSupportEnabled() && object instanceof HttpResponse && this.setOrigin(httpResponse = (HttpResponse)object)) {
            this.setAllowCredentials(httpResponse);
            this.setAllowHeaders(httpResponse);
            this.setExposeHeaders(httpResponse);
        }
        channelHandlerContext.writeAndFlush(object, channelPromise);
    }

    private static void forbidden(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest) {
        channelHandlerContext.writeAndFlush(new DefaultFullHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.FORBIDDEN)).addListener(ChannelFutureListener.CLOSE);
        ReferenceCountUtil.release(httpRequest);
    }
}

