/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.IovArray;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.util.IntSupplier;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class EpollEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollEventLoop.class);
    private static final AtomicIntegerFieldUpdater<EpollEventLoop> WAKEN_UP_UPDATER;
    private final FileDescriptor epollFd;
    private final FileDescriptor eventFd;
    private final IntObjectMap<AbstractEpollChannel> channels = new IntObjectHashMap<AbstractEpollChannel>(4096);
    private final boolean allowGrowing;
    private final EpollEventArray events;
    private final IovArray iovArray = new IovArray();
    private final SelectStrategy selectStrategy;
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        @Override
        public int get() throws Exception {
            return Native.epollWait(EpollEventLoop.this.epollFd.intValue(), EpollEventLoop.this.events, 0);
        }
    };
    private final Callable<Integer> pendingTasksCallable = new Callable<Integer>(){

        @Override
        public Integer call() throws Exception {
            return EpollEventLoop.super.pendingTasks();
        }
    };
    private volatile int wakenUp;
    private volatile int ioRatio = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EpollEventLoop(EventLoopGroup eventLoopGroup, Executor executor, int n, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventLoopGroup, executor, false, DEFAULT_MAX_PENDING_TASKS, rejectedExecutionHandler);
        this.selectStrategy = ObjectUtil.checkNotNull(selectStrategy, "strategy");
        if (n == 0) {
            this.allowGrowing = true;
            this.events = new EpollEventArray(4096);
        } else {
            this.allowGrowing = false;
            this.events = new EpollEventArray(n);
        }
        boolean bl = false;
        FileDescriptor fileDescriptor = null;
        FileDescriptor fileDescriptor2 = null;
        try {
            this.epollFd = fileDescriptor = Native.newEpollCreate();
            this.eventFd = fileDescriptor2 = Native.newEventFd();
            try {
                Native.epollCtlAdd(fileDescriptor.intValue(), fileDescriptor2.intValue(), Native.EPOLLIN);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to add eventFd filedescriptor to epoll", iOException);
            }
            bl = true;
        }
        finally {
            if (!bl) {
                if (fileDescriptor != null) {
                    try {
                        fileDescriptor.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileDescriptor2 != null) {
                    try {
                        fileDescriptor2.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    @Override
    protected void wakeup(boolean bl) {
        if (!bl && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            Native.eventFdWrite(this.eventFd.intValue(), 1L);
        }
    }

    void add(AbstractEpollChannel abstractEpollChannel) throws IOException {
        assert (this.inEventLoop());
        int n = abstractEpollChannel.fd().intValue();
        Native.epollCtlAdd(this.epollFd.intValue(), n, abstractEpollChannel.flags);
        this.channels.put(n, abstractEpollChannel);
    }

    void modify(AbstractEpollChannel abstractEpollChannel) throws IOException {
        assert (this.inEventLoop());
        Native.epollCtlMod(this.epollFd.intValue(), abstractEpollChannel.fd().intValue(), abstractEpollChannel.flags);
    }

    void remove(AbstractEpollChannel abstractEpollChannel) throws IOException {
        int n;
        assert (this.inEventLoop());
        if (abstractEpollChannel.isOpen() && this.channels.remove(n = abstractEpollChannel.fd().intValue()) != null) {
            Native.epollCtlDel(this.epollFd.intValue(), abstractEpollChannel.fd().intValue());
        }
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int n) {
        return PlatformDependent.newMpscQueue(n);
    }

    @Override
    public int pendingTasks() {
        if (this.inEventLoop()) {
            return super.pendingTasks();
        }
        return (Integer)this.submit(this.pendingTasksCallable).syncUninterruptibly().getNow();
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int n) {
        if (n <= 0 || n > 100) {
            throw new IllegalArgumentException("ioRatio: " + n + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n;
    }

    private int epollWait(boolean bl) throws IOException {
        int n = 0;
        long l = System.nanoTime();
        long l2 = l + this.delayNanos(l);
        while (true) {
            int n2;
            long l3;
            if ((l3 = (l2 - l + 500000L) / 1000000L) <= 0L) {
                if (n != 0 || (n2 = Native.epollWait(this.epollFd.intValue(), this.events, 0)) <= 0) break;
                return n2;
            }
            if (this.hasTasks() && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
                return Native.epollWait(this.epollFd.intValue(), this.events, 0);
            }
            n2 = Native.epollWait(this.epollFd.intValue(), this.events, (int)l3);
            ++n;
            if (n2 != 0 || bl || this.wakenUp == 1 || this.hasTasks() || this.hasScheduledTasks()) {
                return n2;
            }
            l = System.nanoTime();
        }
        return 0;
    }

    @Override
    protected void run() {
        while (true) {
            try {
                block9: while (true) {
                    int n = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                    switch (n) {
                        case -2: {
                            continue block9;
                        }
                        case -1: {
                            n = this.epollWait(WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                            if (this.wakenUp != 1) break;
                            Native.eventFdWrite(this.eventFd.intValue(), 1L);
                        }
                    }
                    int n2 = this.ioRatio;
                    if (n2 == 100) {
                        if (n > 0) {
                            this.processReady(this.events, n);
                        }
                        this.runAllTasks();
                    } else {
                        long l = System.nanoTime();
                        if (n > 0) {
                            this.processReady(this.events, n);
                        }
                        long l2 = System.nanoTime() - l;
                        this.runAllTasks(l2 * (long)(100 - n2) / (long)n2);
                    }
                    if (this.allowGrowing && n == this.events.length()) {
                        this.events.increase();
                    }
                    if (!this.isShuttingDown()) continue;
                    this.closeAll();
                    if (this.confirmShutdown()) break;
                }
            }
            catch (Throwable throwable) {
                logger.warn("Unexpected exception in the selector loop.", throwable);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private void closeAll() {
        try {
            Native.epollWait(this.epollFd.intValue(), this.events, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<AbstractEpollChannel> arrayList = new ArrayList<AbstractEpollChannel>(this.channels.size());
        for (AbstractEpollChannel abstractEpollChannel : this.channels.values()) {
            arrayList.add(abstractEpollChannel);
        }
        for (AbstractEpollChannel abstractEpollChannel : arrayList) {
            abstractEpollChannel.unsafe().close(abstractEpollChannel.unsafe().voidPromise());
        }
    }

    private void processReady(EpollEventArray epollEventArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = epollEventArray.fd(i);
            if (n2 == this.eventFd.intValue()) {
                Native.eventFdRead(this.eventFd.intValue());
                continue;
            }
            long l = epollEventArray.events(i);
            AbstractEpollChannel abstractEpollChannel = this.channels.get(n2);
            if (abstractEpollChannel != null) {
                AbstractEpollChannel.AbstractEpollUnsafe abstractEpollUnsafe = (AbstractEpollChannel.AbstractEpollUnsafe)abstractEpollChannel.unsafe();
                if ((l & (long)(Native.EPOLLERR | Native.EPOLLOUT)) != 0L) {
                    abstractEpollUnsafe.epollOutReady();
                }
                if ((l & (long)(Native.EPOLLERR | Native.EPOLLIN)) != 0L) {
                    abstractEpollUnsafe.epollInReady();
                }
                if ((l & (long)Native.EPOLLRDHUP) == 0L) continue;
                abstractEpollUnsafe.epollRdHupReady();
                continue;
            }
            try {
                Native.epollCtlDel(this.epollFd.intValue(), n2);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanup() {
        try {
            try {
                this.epollFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the epoll fd.", iOException);
            }
            try {
                this.eventFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the event fd.", iOException);
            }
        }
        finally {
            this.iovArray.release();
            this.events.free();
        }
    }

    static {
        AtomicIntegerFieldUpdater<EpollEventLoop> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(EpollEventLoop.class, "wakenUp");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(EpollEventLoop.class, "wakenUp");
        }
        WAKEN_UP_UPDATER = atomicIntegerFieldUpdater;
    }
}

