/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelPromiseNotifier;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;

public final class CoalescingBufferQueue {
    private final Channel channel;
    private final ArrayDeque<Object> bufAndListenerPairs;
    private int readableBytes;

    public CoalescingBufferQueue(Channel channel) {
        this(channel, 4);
    }

    public CoalescingBufferQueue(Channel channel, int n) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
        this.bufAndListenerPairs = new ArrayDeque(n);
    }

    public void add(ByteBuf byteBuf) {
        this.add(byteBuf, (ChannelFutureListener)null);
    }

    public void add(ByteBuf byteBuf, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(channelPromise, "promise");
        this.add(byteBuf, channelPromise.isVoid() ? null : new ChannelPromiseNotifier(channelPromise));
    }

    public void add(ByteBuf byteBuf, ChannelFutureListener channelFutureListener) {
        ObjectUtil.checkNotNull(byteBuf, "buf");
        if (this.readableBytes > Integer.MAX_VALUE - byteBuf.readableBytes()) {
            throw new IllegalStateException("buffer queue length overflow: " + this.readableBytes + " + " + byteBuf.readableBytes());
        }
        this.bufAndListenerPairs.add(byteBuf);
        if (channelFutureListener != null) {
            this.bufAndListenerPairs.add(channelFutureListener);
        }
        this.readableBytes += byteBuf.readableBytes();
    }

    public ByteBuf remove(int n, ChannelPromise channelPromise) {
        Object object;
        if (n < 0) {
            throw new IllegalArgumentException("bytes (expected >= 0): " + n);
        }
        ObjectUtil.checkNotNull(channelPromise, "aggregatePromise");
        if (this.bufAndListenerPairs.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        n = Math.min(n, this.readableBytes);
        ByteBuf byteBuf = null;
        int n2 = n;
        while ((object = this.bufAndListenerPairs.poll()) != null) {
            if (object instanceof ChannelFutureListener) {
                channelPromise.addListener((ChannelFutureListener)object);
                continue;
            }
            ByteBuf byteBuf2 = (ByteBuf)object;
            if (byteBuf2.readableBytes() > n) {
                this.bufAndListenerPairs.addFirst(byteBuf2);
                if (n <= 0) break;
                byteBuf = this.compose(byteBuf, byteBuf2.readRetainedSlice(n));
                n = 0;
                break;
            }
            byteBuf = this.compose(byteBuf, byteBuf2);
            n -= byteBuf2.readableBytes();
        }
        this.readableBytes -= n2 - n;
        assert (this.readableBytes >= 0);
        return byteBuf;
    }

    private ByteBuf compose(ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (byteBuf == null) {
            return byteBuf2;
        }
        if (byteBuf instanceof CompositeByteBuf) {
            CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
            compositeByteBuf.addComponent(true, byteBuf2);
            return compositeByteBuf;
        }
        CompositeByteBuf compositeByteBuf = this.channel.alloc().compositeBuffer(this.bufAndListenerPairs.size() + 2);
        compositeByteBuf.addComponent(true, byteBuf);
        compositeByteBuf.addComponent(true, byteBuf2);
        return compositeByteBuf;
    }

    public int readableBytes() {
        return this.readableBytes;
    }

    public boolean isEmpty() {
        return this.bufAndListenerPairs.isEmpty();
    }

    public void releaseAndFailAll(Throwable throwable) {
        this.releaseAndCompleteAll(this.channel.newFailedFuture(throwable));
    }

    private void releaseAndCompleteAll(ChannelFuture channelFuture) {
        Object object;
        this.readableBytes = 0;
        Throwable throwable = null;
        while ((object = this.bufAndListenerPairs.poll()) != null) {
            try {
                if (object instanceof ByteBuf) {
                    ReferenceCountUtil.safeRelease(object);
                    continue;
                }
                ((ChannelFutureListener)object).operationComplete(channelFuture);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        }
        if (throwable != null) {
            throw new IllegalStateException(throwable);
        }
    }

    public void copyTo(CoalescingBufferQueue coalescingBufferQueue) {
        coalescingBufferQueue.bufAndListenerPairs.addAll(this.bufAndListenerPairs);
        coalescingBufferQueue.readableBytes += this.readableBytes;
    }
}

