/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.addons.systemmonitor;

import de.javasoft.synthetica.addons.systemmonitor.Collector;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;

public class CollectorFactory {
    private static final CollectorFactory instance = new CollectorFactory();
    private MBeanServerConnection mbs = ManagementFactory.getPlatformMBeanServer();
    private ObjectName sysName = null;
    private ObjectName memName = null;
    private ObjectName threadName = null;

    private CollectorFactory() {
        try {
            this.sysName = new ObjectName("java.lang:type=OperatingSystem");
            this.memName = new ObjectName("java.lang:type=Memory");
            this.threadName = new ObjectName("java.lang:type=Threading");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException(malformedObjectNameException);
        }
    }

    public static CollectorFactory getFactory() {
        return instance;
    }

    public Collector createCollector(String string) {
        switch (CollectorID.getCollectorID(string)) {
            case CPU_USAGE: {
                return this.createCPUUsageCollector();
            }
            case THREADS: {
                return this.createThreadsCollector();
            }
            case PHYSICAL_MEMORY_USAGE: {
                return this.createPhysicalMemoryUsageCollector();
            }
            case NON_HEAP_MEMORY_USAGE: {
                return this.createNonHeapMemoryUsageCollector();
            }
            case HEAP_MEMORY_USAGE: {
                return this.createHeapMemoryUsageCollector();
            }
            case PERM_GEN_MEMORY_USAGE: {
                return this.createPermGenMemoryUsageCollector();
            }
        }
        return null;
    }

    private Collector createCPUUsageCollector() {
        return new Collector(){
            private long time;
            private long ptime;

            public double getValue() {
                try {
                    float f = (Long)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.sysName, "ProcessCpuTime") - this.ptime;
                    this.time = System.nanoTime();
                    this.ptime = (Long)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.sysName, "ProcessCpuTime");
                    return f /= (float)(System.nanoTime() - this.time);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            public double getMaxValue() {
                return 1.0;
            }
        };
    }

    private Collector createThreadsCollector() {
        return new Collector(){

            public double getValue() {
                try {
                    return ((Integer)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.threadName, "ThreadCount")).intValue();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            public double getMaxValue() {
                try {
                    return ((Integer)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.threadName, "PeakThreadCount")).intValue();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }

    private Collector createPhysicalMemoryUsageCollector() {
        return new Collector(){

            public double getValue() {
                try {
                    double d = (double)((Long)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.sysName, "FreePhysicalMemorySize")).longValue() / 1024.0 / 1024.0;
                    return this.getMaxValue() - d;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            public double getMaxValue() {
                try {
                    return (double)((Long)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.sysName, "TotalPhysicalMemorySize")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }

    private Collector createHeapMemoryUsageCollector() {
        return new Collector(){

            public double getValue() {
                try {
                    return (double)((Long)((CompositeDataSupport)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.memName, "HeapMemoryUsage")).get("used")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            public double getMaxValue() {
                try {
                    return (double)((Long)((CompositeDataSupport)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.memName, "HeapMemoryUsage")).get("committed")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }

    private Collector createNonHeapMemoryUsageCollector() {
        return new Collector(){

            public double getValue() {
                try {
                    return (double)((Long)((CompositeDataSupport)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.memName, "NonHeapMemoryUsage")).get("used")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            public double getMaxValue() {
                try {
                    return (double)((Long)((CompositeDataSupport)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.memName, "NonHeapMemoryUsage")).get("committed")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }

    private Collector createPermGenMemoryUsageCollector() {
        MemoryPoolMXBean memoryPoolMXBean3;
        MemoryPoolMXBean memoryPoolMXBean2 = null;
        List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
        for (final MemoryPoolMXBean memoryPoolMXBean3 : list) {
            if (!memoryPoolMXBean3.getName().equals("Perm Gen")) continue;
            memoryPoolMXBean2 = memoryPoolMXBean3;
        }
        memoryPoolMXBean3 = memoryPoolMXBean2;
        return new Collector(){

            public double getValue() {
                try {
                    return (double)memoryPoolMXBean3.getUsage().getUsed() / 1024.0 / 1024.0;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            public double getMaxValue() {
                try {
                    return (double)memoryPoolMXBean3.getUsage().getCommitted() / 1024.0 / 1024.0;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CollectorID {
        CPU_USAGE("CPU_USAGE"),
        THREADS("THREADS"),
        PHYSICAL_MEMORY_USAGE("PHYSICAL_MEMORY_USAGE"),
        HEAP_MEMORY_USAGE("HEAP_MEMORY_USAGE"),
        NON_HEAP_MEMORY_USAGE("NON_HEAP_MEMORY_USAGE"),
        PERM_GEN_MEMORY_USAGE("PERM_GEN_MEMORY_USAGE");

        public final String id;
        private static HashMap<String, CollectorID> collectorIDs;

        static {
            collectorIDs = new HashMap();
            CollectorID[] collectorIDArray = CollectorID.values();
            int n = collectorIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                CollectorID collectorID = collectorIDArray[n2];
                collectorIDs.put(collectorID.id, collectorID);
                ++n2;
            }
        }

        private CollectorID(String string2) {
            this.id = string2;
        }

        private static CollectorID getCollectorID(String string) {
            return collectorIDs.get(string);
        }
    }
}

