/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.datecombobox;

import de.javasoft.swing.DateComboBox;
import de.javasoft.swing.plaf.datecombobox.DateComboBoxMonthView;
import de.javasoft.swing.plaf.datecombobox.DateComboBoxPopup;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DatePickerFormatter;

public class DateComboBoxEditor
extends BasicComboBoxEditor.UIResource {
    private DateComboBox dateComboBox;
    private DateComboBoxPopup popup;
    private Date lastDate;

    public DateComboBoxEditor(DateComboBox dateComboBox, DateComboBoxPopup dateComboBoxPopup) {
        this.dateComboBox = dateComboBox;
        this.popup = dateComboBoxPopup;
        this.editor = new FormattedTextField();
        this.editor.setInheritsPopupMenu(true);
        this.editor.putClientProperty("Synthetica.opaque", false);
        ((FormattedTextField)this.editor).setFormatterFactory(new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)new DatePickerFormatter(dateComboBox.getDateFormats())));
        if (!dateComboBoxPopup.getMonthView().getSelection().isEmpty()) {
            dateComboBox.configureEditor(this, dateComboBoxPopup.getMonthView().getSelection().first());
        }
        this.editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            this.editor.setBorder(((JComponent)new MetalComboBoxEditor().getEditorComponent()).getBorder());
        } else if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.editor.addFocusListener(this);
        this.editor.setName("ComboBox.textField");
        dateComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DateComboBoxEditor.this.lastDate = DateComboBoxEditor.this.dateComboBox.getDateTime();
            }
        });
    }

    public void setItem(Object object) {
        if (this.popup.getMonthView().isSelectionEmpty()) {
            object = null;
        }
        if (object != null) {
            object = DateComboBoxEditor.getDateTime((Date)object, (Date)this.getItem(), this.popup.getMonthView().getTimeZone());
            ((JFormattedTextField)this.editor).setValue(object);
        } else {
            this.editor.setText("");
        }
    }

    public Object getItem() {
        return ((JFormattedTextField)this.editor).getValue();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.dateComboBox.isPopupVisible()) {
            this.dateComboBox.hidePopup();
        }
        if (this.commit() && this.dateComboBox.isShowing()) {
            this.actionPerformed();
        }
    }

    boolean commit() {
        Date date = null;
        Object object = ((JFormattedTextField)this.editor).getValue();
        if (object instanceof Long) {
            date = new Date((Long)object);
        } else if (object instanceof Date) {
            date = (Date)object;
        } else if (object == null) {
            date = new Date(Long.MAX_VALUE);
        }
        try {
            if (!this.editor.getText().equals(this.dateComboBox.getDateFormats()[0].format(date))) {
                ((JFormattedTextField)this.editor).commitEdit();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        object = ((JFormattedTextField)this.editor).getValue();
        JXMonthView jXMonthView = this.popup.getMonthView();
        if (object instanceof Long) {
            date = new Date((Long)object);
        } else if (object instanceof Date) {
            date = (Date)object;
        } else if (object == null) {
            jXMonthView.clearSelection();
            return true;
        }
        if (this.lastDate == null && this.dateComboBox.getItemCount() > 0) {
            this.lastDate = (Date)this.dateComboBox.getItemAt(0);
        }
        if (!jXMonthView.isSelectionEmpty() && date.equals(this.lastDate)) {
            return false;
        }
        jXMonthView.setSelectionInterval(date, date);
        return true;
    }

    private void actionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this.dateComboBox, 1001, "comboBoxEdited", System.currentTimeMillis(), 0);
        ActionListener[] actionListenerArray = this.dateComboBox.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener actionListener = actionListenerArray[n2];
            actionListener.actionPerformed(actionEvent);
            ++n2;
        }
    }

    static Date getDateTime(Date date, Date date2, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(timeZone);
        if (date2 != null) {
            gregorianCalendar.setTime(date2);
        }
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        ((Calendar)gregorianCalendar2).setTimeZone(timeZone);
        gregorianCalendar2.setTime(date);
        gregorianCalendar2.set(11, gregorianCalendar.get(11));
        gregorianCalendar2.set(12, gregorianCalendar.get(12));
        gregorianCalendar2.set(13, gregorianCalendar.get(13));
        return gregorianCalendar2.getTime();
    }

    private class FormattedTextField
    extends JFormattedTextField {
        private static final long serialVersionUID = 1888278314272092430L;

        private FormattedTextField() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                dimension.height += 4;
            }
            return dimension;
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                dimension.height += 4;
            }
            return dimension;
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = DateComboBoxEditor.this.dateComboBox.isPopupVisible();
            boolean bl3 = bl = keyEvent.getKeyCode() == 40 && keyEvent.getModifiers() == 8;
            if (bl) {
                keyEvent = new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), 0, keyEvent.getKeyCode(), keyEvent.getKeyChar());
            }
            if (!(keyEvent.getKeyCode() != 40 && keyEvent.getKeyCode() != 38 || bl2)) {
                DateComboBoxEditor.this.commit();
                DateComboBoxEditor.this.dateComboBox.processKeyEvent(keyEvent);
                DateComboBoxMonthView dateComboBoxMonthView = (DateComboBoxMonthView)DateComboBoxEditor.this.popup.getMonthView();
                if (!dateComboBoxMonthView.isSelectionEmpty()) {
                    DateComboBoxEditor.this.setItem(dateComboBoxMonthView.getSelection().first());
                    dateComboBoxMonthView.ensureDateVisible();
                }
                return;
            }
            if ((keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10) && bl2) {
                DateComboBoxEditor.this.dateComboBox.hidePopup();
            }
            if (bl2 && keyEvent.getID() == 401) {
                ((DateComboBoxMonthView)DateComboBoxEditor.this.popup.getMonthView()).processKeyEvent(keyEvent);
            } else {
                if (keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401) {
                    if (DateComboBoxEditor.this.commit()) {
                        DateComboBoxEditor.this.actionPerformed();
                    }
                    if (!DateComboBoxEditor.this.popup.getMonthView().isSelectionEmpty()) {
                        DateComboBoxEditor.this.setItem(DateComboBoxEditor.this.popup.getMonthView().getSelection().first());
                    }
                }
                super.processKeyEvent(keyEvent);
            }
        }
    }
}

