/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.pattern;

import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.pattern.CompiledPattern;
import de.dal33t.powerfolder.util.pattern.DefaultExcludes;
import de.dal33t.powerfolder.util.pattern.EndMatchPattern;
import de.dal33t.powerfolder.util.pattern.ExactMatchPattern;
import de.dal33t.powerfolder.util.pattern.OfficeTempFilesMatchPattern;
import de.dal33t.powerfolder.util.pattern.Pattern;
import de.dal33t.powerfolder.util.pattern.StartMatchPattern;
import java.util.logging.Logger;

public class PatternFactory {
    private static Logger LOG = Logger.getLogger(PatternFactory.class.getName());

    private PatternFactory() {
    }

    public static Pattern createPattern(String string) {
        Reject.ifNull(string, "patternText");
        if (string.indexOf(42) == -1) {
            return new ExactMatchPattern(string);
        }
        if (string.lastIndexOf(42) == 0) {
            return new EndMatchPattern(string);
        }
        if (string.indexOf(42) == string.length() - 1) {
            return new StartMatchPattern(string);
        }
        if (string.toLowerCase().equalsIgnoreCase(DefaultExcludes.OFFICE_TEMP.getPattern())) {
            return new OfficeTempFilesMatchPattern("~", "*.tmp");
        }
        if (string.toLowerCase().equalsIgnoreCase(DefaultExcludes.OFFICEX_TEMP.getPattern())) {
            return new OfficeTempFilesMatchPattern("~$", "*");
        }
        if (string.toLowerCase().equalsIgnoreCase(DefaultExcludes.LIBRE_TEMP.getPattern())) {
            return new OfficeTempFilesMatchPattern(".~lock.", "*");
        }
        LOG.fine("Using fallback for pattern '" + string + "'");
        return new CompiledPattern(string);
    }
}

