/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.pattern;

import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.pattern.AbstractPattern;

public class ExactMatchPattern
extends AbstractPattern {
    private char[] matchLower;
    private char[] matchUpper;

    public ExactMatchPattern(String string) {
        super(string);
        Reject.ifFalse(string.indexOf("*") == -1, "Pattern must not contain any stars");
        this.matchLower = this.getPatternText().toLowerCase().toCharArray();
        this.matchUpper = this.getPatternText().toUpperCase().toCharArray();
    }

    @Override
    public boolean isMatch(String string) {
        if (string.length() != this.matchLower.length) {
            return false;
        }
        for (int i = 0; i < this.matchLower.length; ++i) {
            char c = string.charAt(i);
            if (ExactMatchPattern.equalChar(c, this.matchLower[i], this.matchUpper[i])) continue;
            return false;
        }
        return true;
    }
}

