/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.os.mac;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.jni.osx.Util;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.logging.Loggable;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class MacUtils
extends Loggable {
    private Object application;
    private Object reOpenedListener;
    private static MacUtils instance;

    private MacUtils() {
    }

    public static boolean isSupported() {
        return MacUtils.getInstance() != null;
    }

    public static synchronized MacUtils getInstance() {
        if (!OSUtil.isMacOS()) {
            return null;
        }
        if (instance == null && OSUtil.isMacOS()) {
            instance = new MacUtils();
        }
        return instance;
    }

    public void setPFPlaces(boolean bl, Controller controller) throws IOException {
        if (!Util.loaded) {
            this.logFine("JNI bindings not loaded");
            return;
        }
        Path path = controller.getFolderRepository().getFoldersBasedir();
        if (bl) {
            this.logInfo("Setting Favorite item: " + path.toAbsolutePath().toString());
            Util.addFavorite(path.toAbsolutePath().toString());
        } else {
            Util.removeFavorite(path.toAbsolutePath().toString());
        }
    }

    public void setAppReOpenedListener(final Controller controller) {
        try {
            Class<?> clazz;
            Method method;
            Class<?> clazz2 = Class.forName("com.apple.eawt.Application");
            Method method2 = clazz2.getDeclaredMethod("getApplication", new Class[0]);
            try {
                method = clazz2.getMethod("addAppEventListener", Class.forName("com.apple.eawt.AppEventListener"));
            }
            catch (Exception exception) {
                method = clazz2.getMethod("addAppEventListener", Class.forName("java.awt.desktop.SystemEventListener"));
            }
            try {
                clazz = Class.forName("com.apple.eawt.AppReOpenedListener");
            }
            catch (Exception exception) {
                clazz = Class.forName("java.awt.desktop.AppReopenedListener");
            }
            this.application = method2.invoke(null, new Object[0]);
            InvocationHandler invocationHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    if (!controller.isUIEnabled()) {
                        return null;
                    }
                    controller.getUIController().getMainFrame().toFront();
                    return null;
                }
            };
            this.reOpenedListener = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
            method.invoke(this.application, this.reOpenedListener);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            this.logWarning("Could not add the AppReOpenedListener: " + exception);
            exception.printStackTrace();
        }
    }

    public void removeAppReOpenedListener() {
        if (this.reOpenedListener == null) {
            return;
        }
        try {
            Method method;
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            try {
                method = clazz.getMethod("removeAppEventListener", Class.forName("com.apple.eawt.AppEventListener"));
            }
            catch (Exception exception) {
                method = clazz.getMethod("removeAppEventListener", Class.forName("java.awt.desktop.SystemEventListener"));
            }
            method.invoke(this.application, this.reOpenedListener);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            this.logWarning("Could not remove the AppReOpenedListener: " + exception);
            exception.printStackTrace();
        }
    }

    public String getRecourcesLocation() {
        return this.getBundleLocation() + "/Contents/Resources";
    }

    public String getBundleLocation() throws UnsupportedOperationException {
        try {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method method = clazz.getMethod("getPathToApplicationBundle", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            String string = Translation.get("exception.startup_item.unsupported_system.text", System.getProperty("os.name"), System.getProperty("os.version"));
            this.logWarning(string);
            throw new UnsupportedOperationException(string);
        }
    }

    public void setPFStartup(boolean bl, Controller controller) throws UnsupportedOperationException {
        if (!Util.loaded) {
            this.logFine("JNI bindings not loaded");
            return;
        }
        String string = this.getBundleLocation();
        Path path = Paths.get(string, new String[0]).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            this.logFine("Reset bundle path");
            path = Paths.get(controller.getDistribution().getBinaryName() + ".app", new String[0]).toAbsolutePath();
            if (Files.notExists(path, new LinkOption[0])) {
                String string2 = Translation.get("exception.startup_item.executable_not_found.text", controller.getDistribution().getBinaryName(), path.getFileName().toString());
                this.logWarning(string2);
                throw new UnsupportedOperationException(string2);
            }
        }
        if (bl) {
            Util.addLoginItem(path.toAbsolutePath().toString());
        } else {
            Util.removeLoginItem(path.toAbsolutePath().toString());
        }
    }

    public boolean hasPFStartup(Controller controller) throws UnsupportedOperationException {
        if (!Util.loaded) {
            this.logFine("JNI bindings not loaded");
            return false;
        }
        String string = this.getBundleLocation();
        Path path = Paths.get(string, new String[0]).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            this.logFine("Reset bundle path");
            path = Paths.get(controller.getDistribution().getBinaryName() + ".app", new String[0]).toAbsolutePath();
            if (Files.notExists(path, new LinkOption[0])) {
                String string2 = Translation.get("exception.startup_item.executable_not_found.text", controller.getDistribution().getBinaryName(), path.getFileName().toString());
                this.logWarning(string2);
                throw new UnsupportedOperationException(string2);
            }
        }
        return Util.hasLoginItem(path.toAbsolutePath().toString());
    }

    public boolean isNetworkPath(Path path) {
        if (!Util.loaded) {
            this.logFine("JNI bindings not loaded");
            return false;
        }
        return !Util.isOnLocalVolume("file://" + path.toAbsolutePath().toString());
    }
}

