/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.os.Win32;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.distribution.Distribution;
import de.dal33t.powerfolder.distribution.PowerFolderBasic;
import de.dal33t.powerfolder.distribution.PowerFolderGeneric;
import de.dal33t.powerfolder.distribution.PowerFolderPro;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

public class Spacetree {
    private static final String CLSID = "{5107667c-149a-47c8-b0c9-e4bf9132f17d}";
    private String name;
    private Path pathToExe;
    private Path targetDir;

    public static boolean isSupported(Controller controller) {
        return OSUtil.isWindowsSystem() && !OSUtil.isSystemService() && controller.isUIEnabled();
    }

    public static final Spacetree create(Controller controller) {
        Path path;
        Reject.ifNull(controller, "Controller");
        Distribution distribution = controller.getDistribution();
        String string = distribution.getName();
        if (distribution instanceof PowerFolderBasic || distribution instanceof PowerFolderPro || distribution instanceof PowerFolderGeneric) {
            string = distribution.getBinaryName();
        }
        String string2 = distribution.getBinaryName() + ".exe";
        Path path2 = WinUtils.getProgramInstallationPath(controller).resolve(string2);
        if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(controller).booleanValue()) {
            path = controller.getFolderRepository().getFoldersBasedir();
        } else {
            String string3 = controller.getDistribution().getBinaryName().substring(0, 1);
            path = Paths.get(string3 + ":", new String[0]);
        }
        if (Files.notExists(path2, new LinkOption[0])) {
            Logger.getLogger(Spacetree.class.getName()).warning("Unable to install. Not found: " + path2);
            return null;
        }
        return new Spacetree(string, path2, path);
    }

    private Spacetree(String string, Path path, Path path2) {
        Reject.ifBlank(string, "Name");
        Reject.ifNull(path, "Path to exe");
        Reject.ifFalse(Files.exists(path, new LinkOption[0]), "Exe file with icon not found: " + path);
        Reject.ifNull(path2, "Target dir");
        this.name = string;
        this.pathToExe = path;
        this.targetDir = path2;
    }

    public void install() throws IOException {
        Spacetree.regAddCLSID(" /ve /t REG_SZ /d \"" + this.name + "\" /f");
        Spacetree.regAddCLSID("\\DefaultIcon /VE /T REG_EXPAND_SZ /D \"" + this.pathToExe + ",0\" /F");
        Spacetree.regAddCLSID(" /v System.IsPinnedToNameSpaceTree /t REG_DWORD /d 0x1 /f");
        Spacetree.regAddCLSID(" /v SortOrderIndex /t REG_DWORD /d 0x42 /f");
        Spacetree.regAddCLSID("\\InProcServer32 /ve /t REG_EXPAND_SZ /d %systemroot%\\system32\\shell32.dll /f");
        Spacetree.regAddCLSID("\\Instance /v CLSID /t REG_SZ /d {0E5AAE11-A475-4c5b-AB00-C66DE400274E} /f");
        Spacetree.regAddCLSID("\\Instance\\InitPropertyBag /v Attributes /t REG_DWORD /d 0x11 /f");
        Spacetree.regAddCLSID("\\Instance\\InitPropertyBag /v TargetFolderPath /t REG_EXPAND_SZ /d \"" + this.targetDir + "\" /f");
        Spacetree.regAddCLSID("\\ShellFolder /v FolderValueFlags /t REG_DWORD /d 0x28 /f");
        Spacetree.regAddCLSID("\\ShellFolder /v Attributes /t REG_DWORD /d 0xF080004D /f");
        Spacetree.regAdd("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Desktop\\NameSpace\\{5107667c-149a-47c8-b0c9-e4bf9132f17d} /ve /t REG_SZ /d \"" + this.name + "\" /f");
        Spacetree.regAdd("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\HideDesktopIcons\\NewStartPanel /v {5107667c-149a-47c8-b0c9-e4bf9132f17d} /t REG_DWORD /d 0x1 /f");
    }

    public static void uninstall() throws IOException {
        Spacetree.regDelete("HKCU\\Software\\Classes\\CLSID\\{5107667c-149a-47c8-b0c9-e4bf9132f17d} /f");
        Spacetree.regDelete("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Desktop\\NameSpace\\{5107667c-149a-47c8-b0c9-e4bf9132f17d} /f");
    }

    private static void regAddCLSID(String string) throws IOException {
        Spacetree.regAdd("HKCU\\Software\\Classes\\CLSID\\{5107667c-149a-47c8-b0c9-e4bf9132f17d}" + string);
    }

    private static void regAdd(String string) throws IOException {
        String string2 = "reg add " + string;
        Runtime.getRuntime().exec(string2);
    }

    private static void regDelete(String string) throws IOException {
        String string2 = "reg delete " + string;
        Runtime.getRuntime().exec(string2);
    }

    public static void main(String ... stringArray) throws IOException {
        Path path = WinUtils.getProgramInstallationPath(null);
        Spacetree spacetree = new Spacetree("PowerFolder", path.resolve("PowerFolder.exe"), Paths.get("%userprofile%\\PowerFolders", new String[0]));
        spacetree.uninstall();
        spacetree.install();
    }
}

