/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.logging.handlers;

import de.dal33t.powerfolder.util.logging.handlers.AbstractSyslogHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TCPTLSSyslogHandler
extends AbstractSyslogHandler {
    private String host;
    private int port;
    private boolean useTLS;
    private Socket socket;
    private OutputStream outputStream;

    public void init(String string, String string2, int n, boolean bl) {
        super.init(string);
        this.host = string2;
        this.port = n;
        this.useTLS = bl;
    }

    @Override
    protected boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    @Override
    public void connect() throws IOException {
        this.close();
        if (this.useTLS) {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(this.host, this.port), 5000);
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.socket = sSLSocketFactory.createSocket(socket, this.host, this.port, true);
            ((SSLSocket)this.socket).startHandshake();
        } else {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.host, this.port), 5000);
        }
        this.outputStream = this.socket.getOutputStream();
    }

    @Override
    protected void send(byte[] byArray) throws IOException {
        if (this.outputStream == null) {
            throw new IOException("No open Syslog output stream");
        }
        this.outputStream.write(byArray);
        this.outputStream.write(10);
        this.outputStream.flush();
    }

    @Override
    public void flush() {
        try {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }
        catch (IOException iOException) {
            this.reportError("Flush failed", iOException, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outputStream = null;
        this.socket = null;
    }
}

