/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.logging.handlers;

import de.dal33t.powerfolder.util.logging.LoggingFormatter;
import java.awt.Color;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class DocumentHandler
extends Handler {
    private static int numberOfLogCharacters = 50000;
    private final StyledDocument logBuffer = new DefaultStyledDocument();
    private static final Map<String, SimpleAttributeSet> logColors = new HashMap<String, SimpleAttributeSet>();
    private static ThreadLocal<LoggingFormatter> formatterThreadLocal = new ThreadLocal<LoggingFormatter>(){

        @Override
        protected LoggingFormatter initialValue() {
            return new LoggingFormatter();
        }
    };

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(final LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)logColors.get(logRecord.getLevel().getName());
                    String string = ((LoggingFormatter)formatterThreadLocal.get()).format(logRecord);
                    StyledDocument styledDocument = DocumentHandler.this.logBuffer;
                    synchronized (styledDocument) {
                        int n;
                        DocumentHandler.this.logBuffer.insertString(DocumentHandler.this.logBuffer.getLength(), string, mutableAttributeSet);
                        if (DocumentHandler.this.logBuffer.getLength() > numberOfLogCharacters && (n = DocumentHandler.this.logBuffer.getLength() - numberOfLogCharacters) > 0) {
                            DocumentHandler.this.logBuffer.remove(0, n);
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    public static void setLogBuffer(int n) {
        if (n < 20) {
            throw new IllegalArgumentException("Number of logbuffer characters must be at least 20");
        }
        numberOfLogCharacters = n;
    }

    public StyledDocument getLogBuffer() {
        return this.logBuffer;
    }

    static {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.RED);
        logColors.put(Level.SEVERE.getName(), simpleAttributeSet);
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet2, Color.BLUE);
        logColors.put(Level.WARNING.getName(), simpleAttributeSet2);
        SimpleAttributeSet simpleAttributeSet3 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet3, Color.BLACK);
        logColors.put(Level.INFO.getName(), simpleAttributeSet3);
        SimpleAttributeSet simpleAttributeSet4 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet4, Color.GREEN.darker());
        logColors.put(Level.FINE.getName(), simpleAttributeSet4);
        SimpleAttributeSet simpleAttributeSet5 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet5, Color.GRAY);
        logColors.put(Level.FINER.getName(), simpleAttributeSet5);
    }
}

