/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.logging;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.util.logging.LoggingManager;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class Loggable {
    private static boolean logNickPrefix;
    private transient Logger log;

    public static boolean isLogNickPrefix() {
        return logNickPrefix;
    }

    public static void setLogNickPrefix(boolean bl) {
        logNickPrefix = bl;
    }

    protected final String getLoggerName() {
        return this.getClass().getName();
    }

    protected boolean isSevere() {
        return this.isLog(Level.SEVERE);
    }

    protected boolean isWarning() {
        return this.isLog(Level.WARNING);
    }

    protected boolean isInfo() {
        return this.isLog(Level.INFO);
    }

    protected boolean isFine() {
        return this.isLog(Level.FINE);
    }

    protected boolean isFiner() {
        return this.isLog(Level.FINER);
    }

    protected void logSevere(String string) {
        this.logIt(Level.SEVERE, string, null);
    }

    protected void logSevere(String string, Object ... objectArray) {
        this.logIt(Level.SEVERE, String.format(string, objectArray), null);
    }

    protected void logWarning(String string) {
        this.logIt(Level.WARNING, string, null);
    }

    protected void logWarning(String string, Object ... objectArray) {
        this.logIt(Level.WARNING, String.format(string, objectArray), null);
    }

    protected void logInfo(String string) {
        this.logIt(Level.INFO, string, null);
    }

    protected void logInfo(String string, Object ... objectArray) {
        this.logIt(Level.INFO, String.format(string, objectArray), null);
    }

    protected void logFine(String string) {
        this.logIt(Level.FINE, string, null);
    }

    protected void logFine(String string, Object ... objectArray) {
        this.logIt(Level.FINE, String.format(string, objectArray), null);
    }

    protected void logFiner(String string) {
        this.logIt(Level.FINER, string, null);
    }

    protected void logFiner(String string, Object ... objectArray) {
        this.logIt(Level.FINER, String.format(string, objectArray), null);
    }

    protected void logSevere(String string, Throwable throwable) {
        this.logIt(Level.SEVERE, string, throwable);
    }

    protected void logWarning(String string, Throwable throwable) {
        this.logIt(Level.WARNING, string, throwable);
    }

    protected void logInfo(String string, Throwable throwable) {
        this.logIt(Level.INFO, string, throwable);
    }

    protected void logFine(String string, Throwable throwable) {
        this.logIt(Level.FINE, string, throwable);
    }

    protected void logFiner(String string, Throwable throwable) {
        this.logIt(Level.FINER, string, throwable);
    }

    protected void logSevere(Throwable throwable) {
        this.logIt(Level.SEVERE, throwable.getMessage(), throwable);
    }

    protected void logWarning(Throwable throwable) {
        this.logIt(Level.WARNING, throwable.getMessage(), throwable);
    }

    protected void logInfo(Throwable throwable) {
        this.logIt(Level.INFO, throwable.getMessage(), throwable);
    }

    protected void logFine(Throwable throwable) {
        this.logIt(Level.FINE, throwable.getMessage(), throwable);
    }

    protected void logFiner(Throwable throwable) {
        this.logIt(Level.FINER, throwable.getMessage(), throwable);
    }

    protected boolean isLog(Level level) {
        if (level.intValue() < LoggingManager.getMinimumLoggingLevel().intValue()) {
            return false;
        }
        if (this.log == null) {
            this.log = Logger.getLogger(this.getLoggerName());
        }
        return this.log.isLoggable(level);
    }

    protected void logIt(Level level, String string, Throwable throwable) {
        Object object;
        if (this.log == null) {
            this.log = Logger.getLogger(this.getLoggerName());
        }
        String string2 = null;
        if (logNickPrefix && this instanceof PFComponent && (object = ((PFComponent)this).getController()) != null && ((Controller)object).getMySelf() != null) {
            string2 = ((Controller)object).getMySelf().getNick();
        }
        if (string2 != null) {
            object = new LogRecord(level, string);
            ((LogRecord)object).setThrown(throwable);
            ((LogRecord)object).setParameters(new Object[]{string2});
            ((LogRecord)object).setLoggerName(this.log.getName());
            this.log.log((LogRecord)object);
        } else {
            this.log.log(level, string, throwable);
        }
    }
}

