/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.intern;

import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.intern.Internalizer;
import java.util.Map;
import java.util.WeakHashMap;

public class AccountInfoInternalizer
implements Internalizer<AccountInfo> {
    private final Map<AccountInfo, AccountInfo> INSTANCES = new WeakHashMap<AccountInfo, AccountInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountInfo intern(AccountInfo accountInfo) {
        if (accountInfo == null) {
            return null;
        }
        AccountInfo accountInfo2 = this.INSTANCES.get(accountInfo);
        if (accountInfo2 != null) {
            return accountInfo2;
        }
        Map<AccountInfo, AccountInfo> map = this.INSTANCES;
        synchronized (map) {
            accountInfo2 = this.INSTANCES.get(accountInfo);
            if (accountInfo2 == null) {
                if (StringUtils.isBlank(accountInfo.getUsername())) {
                    return accountInfo;
                }
                this.INSTANCES.put(accountInfo, accountInfo);
                accountInfo2 = accountInfo;
            }
        }
        return accountInfo2;
    }

    @Override
    public AccountInfo rename(AccountInfo accountInfo) {
        if (accountInfo == null) {
            return null;
        }
        AccountInfo accountInfo2 = this.INSTANCES.get(accountInfo);
        if (accountInfo2 != null && accountInfo2.getUsername().equals(accountInfo.getUsername())) {
            return accountInfo2;
        }
        if (accountInfo2 != null && accountInfo2.getDisplayName() != null && accountInfo2.getDisplayName().equals(accountInfo.getDisplayName())) {
            return accountInfo2;
        }
        this.INSTANCES.put(accountInfo, accountInfo);
        return accountInfo;
    }
}

