/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.security.SecurityException;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Waiter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;

public class WrappedRunnable
implements Runnable {
    private static final Logger LOG = Logger.getLogger(WrappedRunnable.class.getName());
    private Runnable deligate;

    public WrappedRunnable(Runnable runnable) {
        if (runnable instanceof WrappedRunnable) {
            LOG.log(Level.WARNING, "unnecessary wrapped runnable chain!", new RuntimeException("here"));
        }
        Reject.ifNull(runnable, "Deligate is null");
        this.deligate = runnable;
    }

    @Override
    public void run() {
        try {
            this.deligate.run();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            LOG.log(Level.SEVERE, "Out of memory or process/resource limits reached in " + this.deligate + ": " + outOfMemoryError.toString(), outOfMemoryError);
            LOG.log(Level.SEVERE, "Shutting down java virtual machine. Exit code: 107");
            if (outOfMemoryError.getMessage() != null && outOfMemoryError.getMessage().toLowerCase().contains("unable to create new native thread")) {
                LOG.log(Level.WARNING, "Current threads: ");
                LOG.log(Level.WARNING, Debug.dumpCurrentStacktraces(false));
            }
            System.exit(107);
            throw outOfMemoryError;
        }
        catch (Error error) {
            error.printStackTrace();
            LOG.log(Level.SEVERE, "Error in " + this.deligate + ": " + error.toString(), error);
            throw error;
        }
        catch (HibernateException hibernateException) {
            LOG.log(Level.SEVERE, "Database connection problem: " + hibernateException.getMessage());
        }
        catch (Waiter.WaiterInterruptedException waiterInterruptedException) {
            LOG.log(Level.INFO, "Interrupted " + this.deligate);
        }
        catch (RemoteCallException | SecurityException runtimeException) {
            LOG.log(Level.WARNING, this.deligate + ": " + runtimeException, runtimeException);
        }
        catch (RuntimeException runtimeException) {
            LOG.log(Level.SEVERE, "RuntimeException in " + this.deligate + ": " + runtimeException.toString(), runtimeException);
            throw runtimeException;
        }
    }
}

