/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.UTF8Control;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class Translation {
    private static final Logger log = Logger.getLogger(Translation.class.getName());
    public static final Locale DUTCH = new Locale("nl");
    public static final Locale SPANISH = new Locale("es");
    public static final Locale RUSSIAN = new Locale("ru");
    public static final Locale SWEDISH = new Locale("sv");
    public static final Locale ARABIC = new Locale("ar");
    public static final Locale POLISH = new Locale("pl");
    public static final Locale PORTUGUESE = new Locale("pt");
    public static final Locale HUNGARIAN = new Locale("hu");
    public static final Locale TURKISH = new Locale("tr");
    private static List<Locale> supportedLocales;
    private static Map<String, String> placeHolders;
    private static ResourceBundle resourceBundle;
    private static Object INIT_LOCK;

    private Translation() {
    }

    public static synchronized List<Locale> getSupportedLocales() {
        if (supportedLocales == null) {
            supportedLocales = new ArrayList<Locale>();
            supportedLocales.add(Locale.ENGLISH);
            supportedLocales.add(Locale.GERMAN);
            supportedLocales.add(POLISH);
            supportedLocales.add(PORTUGUESE);
            supportedLocales.add(SPANISH);
            supportedLocales.add(Locale.ITALIAN);
            supportedLocales.add(DUTCH);
        }
        Collections.sort(supportedLocales, LocaleComparator.INSTANCE);
        return Collections.unmodifiableList(supportedLocales);
    }

    public static synchronized void addSupportedLocales(Locale locale) {
        Reject.ifNull(locale, "Locale");
        if (!Translation.getSupportedLocales().contains(locale)) {
            supportedLocales.add(locale);
        } else {
            log.warning("Not adding locale. Already supported: " + locale);
        }
    }

    public static Locale getActiveLocale() {
        Locale locale = Translation.getResourceBundle().getLocale();
        if (locale == null || StringUtils.isEmpty(locale.getLanguage())) {
            return Locale.ENGLISH;
        }
        return Translation.getResourceBundle().getLocale();
    }

    public static void saveLocalSetting(Locale locale) {
        if (locale != null) {
            if (locale.getCountry().length() == 0) {
                Preferences.userNodeForPackage(Translation.class).put("locale", locale.getLanguage());
            } else {
                Preferences.userNodeForPackage(Translation.class).put("locale", locale.getLanguage() + "_" + locale.getCountry());
            }
        } else {
            Preferences.userNodeForPackage(Translation.class).remove("locale");
        }
    }

    public static void resetResourceBundle() {
        resourceBundle = null;
    }

    public static void setResourceBundle(ResourceBundle resourceBundle) {
        Translation.resourceBundle = resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getResourceBundle() {
        if (resourceBundle != null) {
            return resourceBundle;
        }
        Object object = INIT_LOCK;
        synchronized (object) {
            try {
                Locale locale;
                String string = Preferences.userNodeForPackage(Translation.class).get("locale", null);
                Locale locale2 = locale = string != null ? new Locale(string) : null;
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                if (string != null) {
                    if (string.equals("en_GB")) {
                        locale = Locale.UK;
                    } else if (string.equals("en")) {
                        locale = new Locale("");
                    }
                }
                resourceBundle = ResourceBundle.getBundle("Translation", locale, new UTF8Control());
                log.fine("Default Locale '" + Locale.getDefault() + "', using '" + resourceBundle.getLocale() + "', in config '" + locale + "'");
            }
            catch (MissingResourceException missingResourceException) {
                log.log(Level.SEVERE, "Unable to load translation file", missingResourceException);
            }
            return resourceBundle;
        }
    }

    public static synchronized String getCurrentLanguage() {
        Locale locale = null;
        try {
            String string = Preferences.userNodeForPackage(Translation.class).get("locale", null);
            Locale locale2 = locale = string != null ? new Locale(string) : null;
            if (locale == null) {
                locale = Locale.getDefault();
            }
        }
        catch (MissingResourceException missingResourceException) {
            log.log(Level.SEVERE, "Unable to load translation file", missingResourceException);
        }
        return locale.toString();
    }

    public static String get(String string) {
        ResourceBundle resourceBundle = Translation.getResourceBundle();
        if (resourceBundle == null) {
            return "- " + string + " -";
        }
        try {
            String string2 = resourceBundle.getString(string);
            if (string2.contains("{")) {
                for (Map.Entry<String, String> entry : placeHolders.entrySet()) {
                    if (!string2.contains(entry.getKey())) continue;
                    string2 = string2.replace(entry.getKey(), entry.getValue());
                }
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            if (string != null && !string.startsWith("date_format.") && StringUtils.isNotBlank(string)) {
                log.warning("Unable to find translation for ID '" + string + "'");
                log.log(Level.FINER, "MissingResourceException", missingResourceException);
            }
            return "- " + string + " -";
        }
    }

    public static String get(String string, String ... stringArray) {
        Object object = Translation.get(string);
        int n = 0;
        for (String string2 : stringArray) {
            int n2;
            String string3 = "{" + n++ + "}";
            while ((n2 = ((String)object).indexOf(string3)) >= 0) {
                object = ((String)object).substring(0, n2) + string2 + ((String)object).substring(n2 + 3, ((String)object).length());
            }
        }
        return object;
    }

    public static void setPlaceHolder(String string, String string2) {
        if (string2 == null) {
            placeHolders.remove("{" + string + "}");
        } else {
            placeHolders.put("{" + string + "}", string2);
        }
    }

    static {
        placeHolders = new ConcurrentHashMap<String, String>();
        Translation.setPlaceHolder("APPNAME", "PowerFolder");
        Translation.setPlaceHolder("APPDESCRIPTION", "Sync your World");
        INIT_LOCK = new Object();
    }

    private static final class LocaleComparator
    implements Comparator<Locale> {
        private static LocaleComparator INSTANCE = new LocaleComparator();

        private LocaleComparator() {
        }

        @Override
        public int compare(Locale locale, Locale locale2) {
            return locale.getDisplayName(locale).compareTo(locale2.getDisplayName(locale2));
        }
    }
}

