/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Pair;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Visitor;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleCache<K, E>
extends Loggable {
    private long entryTimeout;
    private Map<K, Pair<Date, E>> cache;
    private AtomicInteger cacheHits = new AtomicInteger();
    private AtomicInteger cacheMisses = new AtomicInteger();

    public SimpleCache(long l, TimeUnit timeUnit) {
        this(Util.createConcurrentHashMap(), l, timeUnit);
    }

    public SimpleCache(Map<K, Pair<Date, E>> map, long l, TimeUnit timeUnit) {
        Reject.ifNull(map, "Backing map");
        Reject.ifFalse(this.entryTimeout <= 0L, "Illegal timeout value");
        this.cache = map;
        this.entryTimeout = timeUnit.toMillis(l);
    }

    public void put(K k, E e) {
        Reject.ifNull(k, "Key is null. Not supported");
        Reject.ifNull(e, "Value is null. Not supported");
        this.cache.put(k, new Pair<Date, E>(new Date(), e));
    }

    public E getValidEntry(K k) {
        Pair<Date, E> pair = this.cache.get(k);
        if (pair == null) {
            this.cacheMisses.incrementAndGet();
            return null;
        }
        Date date = pair.getFirst();
        long l = System.currentTimeMillis() - date.getTime();
        if (l > this.entryTimeout) {
            this.cache.remove(k);
            this.cacheMisses.incrementAndGet();
            return null;
        }
        this.cacheHits.incrementAndGet();
        return pair.getSecond();
    }

    public E invalidate(K k) {
        Pair<Date, E> pair = this.cache.remove(k);
        if (pair == null) {
            return null;
        }
        return pair.getSecond();
    }

    public void invalidateEntry(Visitor<E> visitor) {
        Reject.ifNull(visitor, "Entry");
        for (Map.Entry<K, Pair<Date, E>> entry : this.cache.entrySet()) {
            E e = entry.getValue().getSecond();
            if (!visitor.visit(e)) continue;
            this.invalidate(entry.getKey());
        }
    }

    public void invalidateAll() {
        this.cache.clear();
    }

    public int getCacheHits() {
        return this.cacheHits.get();
    }

    public int getCacheMisses() {
        return this.cacheMisses.get();
    }

    public String toString() {
        int n = this.cacheHits.get() + this.cacheMisses.get();
        String string = "n/a";
        if (n > 0) {
            double d = (double)this.cacheHits.get() / (double)n;
            string = Format.formatPercent(d * 100.0);
        }
        return "SimpleCache [efficiency=" + string + ", entries=" + this.cache.size() + ", timeoutMS=" + this.entryTimeout + ", cacheHits=" + this.cacheHits + ", cacheMisses=" + this.cacheMisses + "]";
    }
}

