/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.security.Token;
import de.dal33t.powerfolder.util.Base64;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoginUtil {
    private static final int OBF_BYTE = 170;
    public static final String MD5_HASH_DIGEST = "MD5";
    public static final String SHA256_HASH_DIGEST = "SHA-256";
    public static final long OTP_DEFAULT_VALIDITY_PERIOD = 60000L;

    private LoginUtil() {
    }

    public static String obfuscate(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        byte[] byArray = new byte[cArray.length * 3];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharsetEncoder charsetEncoder = Convert.UTF8.newEncoder();
        charsetEncoder.encode(charBuffer, byteBuffer, true);
        int n = byteBuffer.position();
        if (n != byArray.length) {
            byArray = Arrays.copyOf(byArray, n);
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] ^ 0xAA);
            byArray[i] = (byte)(byArray[i] + 127);
        }
        return Base64.encodeBytes(byArray, 8);
    }

    public static char[] deobfuscate(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode(string, 8);
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(byArray[i] - 127);
                byArray[i] = (byte)(byArray[i] ^ 0xAA);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            char[] cArray = new char[byArray.length];
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            CharsetDecoder charsetDecoder = Convert.UTF8.newDecoder();
            charsetDecoder.decode(byteBuffer, charBuffer, true);
            int n = charBuffer.position();
            if (n != cArray.length) {
                cArray = Arrays.copyOf(cArray, n);
            }
            return cArray;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(LoginUtil.class.getName()).log(Level.FINER, "Unable to decode obfuscated password: " + string + ". " + illegalArgumentException, illegalArgumentException);
            return null;
        }
        catch (Exception exception) {
            Logger.getLogger(LoginUtil.class.getName()).log(Level.SEVERE, "Unable to decode obfuscated password: " + string + ". " + exception, exception);
            return null;
        }
    }

    public static String decorateURL(String string, String string2, char[] cArray) {
        Object object = string;
        if (StringUtils.isNotBlank(string2)) {
            object = (String)object + "?";
            object = (String)object + "Username";
            object = (String)object + "=";
            object = (String)object + Util.encodeForURL(string2);
            if (cArray != null && cArray.length > 0) {
                object = (String)object + "&";
                object = (String)object + "PasswordOBF";
                object = (String)object + "=";
                object = (String)object + Util.encodeForURL(LoginUtil.obfuscate(cArray));
            }
        }
        return object;
    }

    public static String decorateURL(String string, String string2, String string3) {
        Object object = string;
        if (StringUtils.isNotBlank(string2)) {
            object = (String)object + "?";
            object = (String)object + "Username";
            object = (String)object + "=";
            object = (String)object + Util.encodeForURL(string2);
        }
        if (StringUtils.isNotBlank(string3)) {
            object = ((String)object).contains("?") ? (String)object + "&" : (String)object + "?";
            object = (String)object + "PasswordOBF";
            object = (String)object + "=";
            object = (String)object + Util.encodeForURL(string3);
        }
        return object;
    }

    public static boolean matches(char[] cArray, String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        String[] stringArray = string.split(":");
        if (stringArray.length != 3) {
            return string != null && !string.startsWith(MD5_HASH_DIGEST) && !string.startsWith(SHA256_HASH_DIGEST) && Arrays.equals(cArray, Util.toCharArray(string));
        }
        String string2 = stringArray[0];
        if (string2.equalsIgnoreCase(MD5_HASH_DIGEST) || string2.equalsIgnoreCase(SHA256_HASH_DIGEST)) {
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            String string5 = LoginUtil.hash(string2, Util.toString(cArray), string3);
            return string4.equals(string5);
        }
        return false;
    }

    public static String hashAndSalt(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        String string2 = IdGenerator.makeId();
        String string3 = LoginUtil.getPreferredDigest().getAlgorithm();
        return string3 + ":" + string2 + ":" + LoginUtil.hash(string3, string, string2);
    }

    public static String hash(String string, String string2, String string3) {
        String string4 = string2 + string3;
        byte[] byArray = string4.getBytes(Convert.UTF8);
        for (int i = 0; i < 1597; ++i) {
            byArray = LoginUtil.digest(string, byArray);
        }
        return Base64.encodeBytes(byArray);
    }

    public static void clear(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return;
        }
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
    }

    public static String generateOTP() {
        return LoginUtil.generateOTP(60000L);
    }

    public static String generateOTP(long l) {
        return Token.generate(new Date(System.currentTimeMillis() + l));
    }

    public static boolean isOTPValid(String string) {
        return !Token.isExpired(string);
    }

    public static String getInviteUsernameLabel(Controller controller) {
        if (LoginUtil.isUsernameShibboleth(controller)) {
            return Translation.get("general.email") + ":";
        }
        return LoginUtil.getUsernameLabel(controller);
    }

    public static String getUsernameLabel(Controller controller) {
        return LoginUtil.getUsernameText(controller) + ":";
    }

    public static String getUsernameText(Controller controller) {
        Reject.ifNull(controller, "Controller");
        if (LoginUtil.isUsernameEmailOnly(controller)) {
            return Translation.get("general.email");
        }
        if (LoginUtil.isUsernameAny(controller)) {
            return Translation.get("general.username") + "/" + Translation.get("general.email");
        }
        if (LoginUtil.isBoolConfValue(controller)) {
            return Translation.get("general.username");
        }
        return ConfigurationEntry.SERVER_USERNAME_IS_EMAIL.getValue(controller);
    }

    public static boolean isValidUsername(Controller controller, String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        if (LoginUtil.isUsernameAny(controller)) {
            return true;
        }
        if (ConfigurationEntry.SERVER_USERNAME_IS_EMAIL.getValueBoolean(controller).booleanValue()) {
            return Util.isValidEmail(string);
        }
        return true;
    }

    private static boolean isUsernameShibboleth(Controller controller) {
        String string = ConfigurationEntry.SERVER_USERNAME_IS_EMAIL.getValue(controller);
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains("shibboleth") || string.toLowerCase().contains("bwidm") || string.toLowerCase().contains("nutzerkennung");
    }

    public static boolean isUsernameEmailOnly(Controller controller) {
        if (LoginUtil.isUsernameAny(controller)) {
            return false;
        }
        if (!LoginUtil.isBoolConfValue(controller)) {
            return false;
        }
        return ConfigurationEntry.SERVER_USERNAME_IS_EMAIL.getValueBoolean(controller);
    }

    public static boolean isUsernameAny(Controller controller) {
        String string = ConfigurationEntry.SERVER_USERNAME_IS_EMAIL.getValue(controller);
        return "both".equalsIgnoreCase(string);
    }

    public static boolean isBoolConfValue(Controller controller) {
        String string = ConfigurationEntry.SERVER_USERNAME_IS_EMAIL.getValue(controller);
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false");
    }

    private static byte[] digest(String string, byte[] byArray) {
        return LoginUtil.getDigest(string).digest(byArray);
    }

    private static MessageDigest getDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
    }

    private static MessageDigest getPreferredDigest() {
        return LoginUtil.getDigest(SHA256_HASH_DIGEST);
    }

    public static boolean satisfiesUnixPolicy(String string) {
        if (string == null) {
            return false;
        }
        String string2 = "(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=\\S*?[^a-zA-Z0-9])(?=\\S+$).{8,}";
        return string.matches(string2);
    }
}

