/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.NodeInformation;
import de.dal33t.powerfolder.net.ConnectionQuality;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.Upload;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.JavaVersion;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.PropertiesUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.compare.FileInfoComparator;
import de.dal33t.powerfolder.util.compare.MemberComparator;
import de.dal33t.powerfolder.util.logging.LoggingManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    private static final Logger log = Logger.getLogger(Debug.class.getName());
    private static final MyThreadLocal DATE_FORMAT = new MyThreadLocal();

    private Debug() {
    }

    public static long countDataitems(Controller controller) {
        long l = 0L;
        for (Folder folder : controller.getFolderRepository().getFolders(true)) {
            for (Member member : folder.getMembersAsCollection()) {
                l += (long)folder.getDAO().count(member.getId(), true, false);
            }
        }
        return l;
    }

    public static void writeSystemProperties() {
        if (!LoggingManager.isLogToFile()) {
            return;
        }
        Path path = LoggingManager.getDebugDir().resolve("system_properties.txt");
        try {
            Properties properties = System.getProperties();
            PropertiesUtil.saveConfig(path, properties, "Current time: " + new Date());
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.severe("Unable to create SystemInfo file");
        }
        catch (IOException iOException) {
            log.severe("Unable to Write to '" + path + "'");
        }
    }

    public static Path writeFileListCSV(String string, String string2, Collection<FileInfo> collection, String string3) {
        Reject.ifBlank(string, "folderName is null");
        Reject.ifBlank(string2, "memberName is null");
        Reject.ifNull(collection, "Files are null");
        Path path = LoggingManager.getDebugDir().resolve("filelists");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            return null;
        }
        Path path2 = path.resolve(PathUtils.removeInvalidFilenameChars(string) + "/" + PathUtils.removeInvalidFilenameChars(string2) + ".list.txt");
        return Debug.writeFileListCSV(path2, collection, string3);
    }

    public static Path writeFileListCSV(Path path, Collection<FileInfo> collection, String string) {
        Path throwable;
        block16: {
            if (Files.notExists(path, new LinkOption[0])) {
                try {
                    if (path.getParent() != null && Files.notExists(path.getParent(), new LinkOption[0])) {
                        try {
                            Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                    Files.createFile(path, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    log.severe("Unable to write filelist to " + path.toAbsolutePath().toString());
                    log.log(Level.FINER, "IOException", iOException);
                    return null;
                }
            }
            if (!Files.isWritable(path)) {
                log.severe("Unable to write filelist to " + path.toAbsolutePath().toString());
                return null;
            }
            FileInfo[] fileInfoArray = collection.toArray(new FileInfo[collection.size()]);
            Arrays.sort(fileInfoArray, new FileInfoComparator(5));
            OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
            try {
                outputStream.write(("# " + string + "\n\n").getBytes("UTF-8"));
                outputStream.write("Change time      ;Filename;Changer;Size;Version\n\n".getBytes());
                for (FileInfo fileInfo : fileInfoArray) {
                    outputStream.write(Debug.toCSVLine(fileInfo).getBytes("UTF-8"));
                }
                throwable = path;
                if (outputStream == null) break block16;
            }
            catch (Throwable throwable2) {
                try {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    }
                    throw throwable2;
                }
                catch (IOException iOException) {
                    log.severe("Unable to write nodelist to '" + path.toAbsolutePath().toString() + "'");
                    log.log(Level.FINER, "IOException", iOException);
                    return null;
                }
            }
            outputStream.close();
        }
        return throwable;
    }

    private static String toCSVLine(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo is null");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(fileInfo.getModifiedDate() != null ? ((DateFormat)DATE_FORMAT.get()).format(fileInfo.getModifiedDate()) : "-");
        stringBuilder.append(" ;");
        if (fileInfo.isDeleted()) {
            stringBuilder.append("(del) ");
        }
        stringBuilder.append(fileInfo.getRelativeName());
        stringBuilder.append(fileInfo.isDiretory() ? " (D)" : "");
        stringBuilder.append(';');
        stringBuilder.append(fileInfo.getModifiedBy().nick);
        stringBuilder.append(';');
        stringBuilder.append(Format.formatBytes(fileInfo.getSize()));
        stringBuilder.append(';');
        stringBuilder.append(fileInfo.getVersion());
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildDebugReport(Controller controller) {
        if (controller == null) {
            throw new NullPointerException("Controller is null");
        }
        Controller controller2 = controller;
        synchronized (controller2) {
            Member[] memberArray;
            Object object;
            Collection<DownloadManager> collection;
            Object object2;
            Object object3;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PowerFolder debug report\n");
            stringBuffer.append("------------------------");
            stringBuffer.append("\nVersion: 23.2.102 (" + controller.getBuildTime() + ")");
            stringBuffer.append("\nConfig: " + controller.getConfigName());
            stringBuffer.append("\nCurrent time: " + new Date());
            stringBuffer.append("\nLocale: " + Locale.getDefault() + " (" + Locale.getDefault().getDisplayCountry() + ")");
            stringBuffer.append("\nUptime: " + Format.formatTimeframe(controller.getUptime()));
            stringBuffer.append("\nOS: " + System.getProperty("os.name"));
            stringBuffer.append("\nJava: " + JavaVersion.systemVersion().toString() + " (" + System.getProperty("java.vendor") + ")");
            long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            stringBuffer.append("\nMemory: " + Format.formatBytesShort(l) + "/" + Format.formatBytesShort(Runtime.getRuntime().totalMemory()) + "/" + Format.formatBytesShort(Runtime.getRuntime().maxMemory()));
            stringBuffer.append("\nNetworking mode: ");
            stringBuffer.append(controller.getNetworkingMode().name());
            double d = (double)controller.getUptime() / 1000.0 / 60.0 / 60.0 / 24.0;
            int n = LoggingManager.getCountingHandler().countWarnings();
            stringBuffer.append("\nWarnings: ");
            stringBuffer.append(n);
            stringBuffer.append(" total (~");
            stringBuffer.append(Math.round((double)n / d));
            stringBuffer.append(" per day)");
            int n2 = LoggingManager.getCountingHandler().countSevere();
            stringBuffer.append("\nSevere: ");
            stringBuffer.append(n2);
            stringBuffer.append(" total (~");
            stringBuffer.append(Math.round((double)n2 / d));
            stringBuffer.append(" per day)");
            double d2 = controller.getTransferManager().getTotalUploadTrafficCounter().calculateCurrentKBS();
            double d3 = controller.getTransferManager().getTotalDownloadTrafficCounter().calculateCurrentKBS();
            long l2 = controller.getTransferManager().getTotalUploadTrafficCounter().getBytesTransferred();
            long l3 = controller.getTransferManager().getTotalDownloadTrafficCounter().getBytesTransferred();
            stringBuffer.append("\nTotal traffic: DOWN " + Format.formatDecimal(d3) + " Kbytes/s, " + Format.formatBytes(l3) + " bytes total, UP " + Format.formatDecimal(d2) + " Kbytes/s, " + Format.formatBytes(l2) + " bytes total");
            if (controller.isLimitedConnectivity()) {
                stringBuffer.append("\nWARNING: Has limited connectivity");
            }
            stringBuffer.append("\n\nListener status: ");
            if (controller.hasConnectionListener()) {
                stringBuffer.append("Listening on ");
                stringBuffer.append(controller.getConnectionListener().getAddress());
                if (controller.getMySelf() != null && controller.getMySelf().getInfo().isSupernode) {
                    stringBuffer.append(", acting as supernode");
                } else {
                    stringBuffer.append(", acting as standardnode");
                }
                stringBuffer.append('\n');
            } else {
                stringBuffer.append("Not listening on a local port\n");
            }
            stringBuffer.append("MySelf: ");
            Debug.addDetailInfo(stringBuffer, controller.getMySelf());
            stringBuffer.append('\n');
            if (controller.isStarted()) {
                object3 = controller.getFolderRepository().getFolders(true);
                stringBuffer.append("\nFolders (" + object3.size() + " joined)");
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    collection = object2.next();
                    stringBuffer.append("\n ");
                    Debug.addDetailInfo(stringBuffer, (Folder)((Object)collection));
                }
                stringBuffer.append('\n');
                if (object3.isEmpty()) {
                    stringBuffer.append(" (none)\n");
                }
                object2 = controller.getTransferManager();
                collection = controller.getTransferManager().getActiveDownloads();
                stringBuffer.append("\nDownloads (" + collection.size() + " total, " + Format.formatDecimal(((TransferManager)object2).getDownloadCounter().calculateCurrentKBS()) + " Kbytes/s, " + Format.formatBytes(((TransferManager)object2).getDownloadCounter().getBytesTransferred()) + " bytes total):");
                for (DownloadManager memberArray22 : collection) {
                    for (Download download : memberArray22.getSources()) {
                        stringBuffer.append("\n ");
                        stringBuffer.append(download.isStarted() ? "(active)" : (download.isQueued() ? "(queued)" : "(requested)"));
                        stringBuffer.append(" " + download);
                    }
                }
                stringBuffer.append('\n');
                if (collection.isEmpty()) {
                    stringBuffer.append(" (none)\n");
                }
                stringBuffer.append("\nUploads (" + ((TransferManager)object2).countActiveUploads() + " active, " + ((TransferManager)object2).countQueuedUploads() + " queued, " + Format.formatDecimal(((TransferManager)object2).getUploadCounter().calculateCurrentKBS()) + " Kbytes/s, " + Format.formatDecimal(((TransferManager)object2).getUploadCPSForWAN() / 1024L) + " Kbyte/s allowed, " + Format.formatBytes(((TransferManager)object2).getUploadCounter().getBytesTransferred()) + " bytes total):");
                object = new ArrayList();
                object.addAll(((TransferManager)object2).getActiveUploads());
                object.addAll(((TransferManager)object2).getQueuedUploads());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    memberArray = iterator.next();
                    Upload upload = (Upload)memberArray;
                    stringBuffer.append("\n ");
                    stringBuffer.append(upload.isStarted() ? "(active)" : "(queued)");
                    stringBuffer.append(" " + upload);
                }
                stringBuffer.append('\n');
                if (object.isEmpty()) {
                    stringBuffer.append(" (none)\n");
                }
                Member[] memberArray2 = controller.getNodeManager().getNodesAsCollection().toArray(new Member[controller.getNodeManager().getNodesAsCollection().size()]);
                Arrays.sort(memberArray2, MemberComparator.IN_GUI);
                stringBuffer.append("\nAll online nodes (" + controller.getNodeManager().countConnectedNodes() + " connected, " + controller.getNodeManager().countOnlineNodes() + " online, " + controller.getNodeManager().getNodesAsCollection().size() + " known, " + controller.getNodeManager().countSupernodes() + " supernodes, " + controller.getNodeManager().countFriends() + " friend(s)):");
                for (Member member : memberArray2) {
                    if (!member.isConnectedToNetwork()) continue;
                    stringBuffer.append("\n ");
                    Debug.addDetailInfo(stringBuffer, member);
                }
                stringBuffer.append('\n');
                if (memberArray2.length == 0) {
                    stringBuffer.append(" (none)\n");
                }
            } else {
                stringBuffer.append("Controller NOT started yet\n");
            }
            stringBuffer.append("\nConfig:");
            object3 = (Properties)controller.getConfig().clone();
            object2 = new ArrayList<Object>(((Properties)object3).keySet());
            Collections.sort(object2);
            collection = object2.iterator();
            while (collection.hasNext()) {
                object = collection.next();
                String string = (String)object;
                memberArray = ((Properties)object3).getProperty(string);
                if (string.toLowerCase().contains("password")) {
                    memberArray = "XXX-erased-XXX";
                }
                if (string.toLowerCase().contains("passphrase")) {
                    memberArray = "XXX-erased-XXX";
                }
                if (string.toLowerCase().contains("license")) {
                    memberArray = "XXX-erased-XXX";
                }
                if (string.toLowerCase().contains("login.admin.iplist")) {
                    memberArray = "XXX-erased-XXX";
                }
                if (string.toLowerCase().contains("secret.key")) {
                    memberArray = "XXX-erased-XXX";
                }
                stringBuffer.append("\n" + string + "=" + (String)memberArray);
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
    }

    private static void addDetailInfo(StringBuffer stringBuffer, Member member) {
        if (stringBuffer == null || member == null) {
            return;
        }
        stringBuffer.append(Debug.toDetailInfo(member));
    }

    private static String toDetailInfo(Member member) {
        Object object;
        Reject.ifNull(member, "Member is null");
        StringBuilder stringBuilder = new StringBuilder();
        if (member.isMySelf()) {
            stringBuilder.append("(me) ");
        } else if (member.isConnected()) {
            if (member.isOnLAN()) {
                stringBuilder.append("(LAN) ");
            } else {
                object = member.getPeer();
                if (object != null) {
                    ConnectionQuality connectionQuality = object.getConnectionQuality();
                    if (connectionQuality.equals((Object)ConnectionQuality.GOOD)) {
                        stringBuilder.append("(***) ");
                    } else if (connectionQuality.equals((Object)ConnectionQuality.MEDIUM)) {
                        stringBuilder.append("(** ) ");
                    } else {
                        stringBuilder.append("(*  ) ");
                    }
                } else {
                    stringBuilder.append("(???) ");
                }
            }
        } else if (member.isConnectedToNetwork()) {
            stringBuilder.append("(on ) ");
        } else {
            stringBuilder.append("(off) ");
        }
        if (member.getInfo().isSupernode) {
            stringBuilder.append("(s) ");
        }
        stringBuilder.append(member);
        object = member.getIdentity();
        stringBuilder.append(", ver. " + (object != null ? ((Identity)object).getProgramVersion() : "-") + ", ID: " + member.getId());
        stringBuilder.append(", reconnect address " + member.getReconnectAddress());
        return stringBuilder.toString();
    }

    private static String toCSVLine(Member member) {
        Reject.ifNull(member, "Member is null");
        StringBuilder stringBuilder = new StringBuilder();
        if (member.isMySelf()) {
            stringBuilder.append("myself");
        } else if (member.isConnected()) {
            if (member.isOnLAN()) {
                stringBuilder.append("connected (local)");
            } else {
                stringBuilder.append("connected (i-net)");
            }
        } else if (member.isConnectedToNetwork()) {
            stringBuilder.append("online");
        } else {
            stringBuilder.append("offline");
        }
        stringBuilder.append(';');
        if (member.getInfo().isSupernode) {
            stringBuilder.append('s');
        } else {
            stringBuilder.append('n');
        }
        stringBuilder.append(';');
        stringBuilder.append(member.getNick());
        stringBuilder.append(";" + member.getId());
        stringBuilder.append(';');
        Identity identity = member.getIdentity();
        stringBuilder.append(identity != null ? identity.getProgramVersion() : "-");
        stringBuilder.append(";" + member.getReconnectAddress());
        stringBuilder.append(";" + member.getLastConnectTime());
        stringBuilder.append(";" + member.getLastNetworkConnectTime());
        return stringBuilder.toString();
    }

    private static void addDetailInfo(StringBuffer stringBuffer, Folder folder) {
        if (stringBuffer == null || folder == null) {
            return;
        }
        stringBuffer.append(folder);
        stringBuffer.append(", ID: " + folder.getId());
        stringBuffer.append(", files: " + folder.getKnownItemCount() + ", size: " + Format.formatBytes(folder.getStatistic().getLocalSize()) + ", members: " + folder.getMembersCount() + ", mode: " + folder.getSyncProfile().getName() + ", sync: " + Format.formatPercent(folder.getStatistic().getLocalSyncPercentage()));
    }

    public static boolean writeNodeInformation(NodeInformation nodeInformation) {
        if (nodeInformation == null) {
            throw new NullPointerException("NodeInfo is null");
        }
        Object object = nodeInformation.node != null ? PathUtils.removeInvalidFilenameChars(nodeInformation.node.nick) + ".report.txt" : "-unknown-.report.txt";
        try {
            Path path = LoggingManager.getDebugDir().resolve("nodeinfos");
            Files.createDirectories(path, new FileAttribute[0]);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(path.resolve((String)object), new OpenOption[0]));
            ((OutputStream)bufferedOutputStream).write(nodeInformation.debugReport.getBytes());
            ((OutputStream)bufferedOutputStream).close();
            return true;
        }
        catch (IOException iOException) {
            log.log(Level.FINER, "IOException", iOException);
            return false;
        }
    }

    public static String loadDebugReport(MemberInfo memberInfo) {
        Reject.ifNull(memberInfo, "Node is null");
        String string = "Node." + memberInfo.nick + ".report.txt";
        try {
            Path path = LoggingManager.getDebugDir().resolve("nodeinfos/" + string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            byte[] byArray = new byte[(int)Files.size(path)];
            ((InputStream)bufferedInputStream).read(byArray);
            return new String(byArray);
        }
        catch (IOException iOException) {
            log.warning("Debug report for " + memberInfo.nick + " not found (" + string + ")");
            return null;
        }
    }

    public static void writeNodeList(Collection<Member> collection, String string) {
        Reject.ifNull(collection, "Nodelist is null");
        try (OutputStream outputStream = Files.newOutputStream(LoggingManager.getDebugDir().resolve(string), new OpenOption[0]);){
            for (Member member : collection) {
                outputStream.write(Debug.toDetailInfo(member).getBytes());
                outputStream.write("\n".getBytes());
            }
        }
        catch (IOException iOException) {
            log.warning("Unable to write nodelist to '" + string + "'");
            log.log(Level.FINER, "IOException", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeNodeListCSV(Collection<Member> collection, String string) {
        Reject.ifNull(collection, "Nodelist is null");
        try (OutputStream outputStream = Files.newOutputStream(LoggingManager.getDebugDir().resolve(string), new OpenOption[0]);){
            outputStream.write("connect;supernode;nick;id;version;address;last connect time;last online time\n".getBytes());
            Collection<Member> collection2 = collection;
            synchronized (collection2) {
                for (Member member : collection) {
                    outputStream.write(Debug.toCSVLine(member).getBytes());
                    outputStream.write("\n".getBytes());
                }
            }
        }
        catch (IOException iOException) {
            log.warning("Unable to write nodelist to '" + string + "'");
            log.log(Level.FINER, "IOException", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStatistics(Controller controller) {
        OutputStream outputStream = null;
        try {
            Path path = LoggingManager.getDebugDir().resolve(controller.getConfigName() + ".netstat.csv");
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            outputStream = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.APPEND));
            Date date = new Date();
            String string = Format.formatDateShort(date) + ";" + date.getTime() + ";" + controller.getNodeManager().countConnectedNodes() + ";" + controller.getNodeManager().countOnlineNodes() + ";" + controller.getNodeManager().getNodesAsCollection().size() + "\n";
            outputStream.write(string.getBytes());
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Unable to write network statistics file", iOException);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void dumpThreadStacks() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Debug.showGroupInfo(threadGroup);
    }

    public static String getStackTrace(StackTraceElement[] stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            stringBuilder.append(stackTraceElement.toString()).append('\n');
        }
        return stringBuilder.toString();
    }

    public static void dumpCurrentStackTrace() {
        log.fine(Debug.getCurrentStackTrace());
    }

    public static String getCurrentStackTrace() {
        return Debug.getStackTrace(Thread.currentThread().getStackTrace());
    }

    public static String dumpCurrentStacktraces(boolean bl) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        StringBuilder stringBuilder = new StringBuilder("Current Threads - Stacktraces Start:\n");
        for (String string : Debug.getGroupInfo(threadGroup, bl)) {
            stringBuilder.append(string);
        }
        stringBuilder.append("\nCurrent Threads - Stacktraces End");
        return stringBuilder.toString();
    }

    public static String dumpThreadInfo(Thread thread, boolean bl) {
        String string = Debug.dumpStackTrace(thread, bl);
        if (StringUtils.isBlank(string)) {
            return null;
        }
        String string2 = "\"" + thread.getName() + "\" - Thread t@" + thread.hashCode() + "\n";
        string2 = string2 + "   java.lang.Thread.State: " + thread.getState();
        string2 = string2 + "\n";
        string2 = string2 + string;
        string2 = string2 + "\n";
        return string2;
    }

    private static List<String> getGroupInfo(ThreadGroup threadGroup, boolean bl) {
        if (threadGroup == null) {
            return Collections.EMPTY_LIST;
        }
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        LinkedList<String> linkedList = new LinkedList<String>();
        threadGroup.enumerate(threadArray, false);
        for (Thread thread : threadArray) {
            String string;
            if (thread == null || StringUtils.isBlank(string = Debug.dumpThreadInfo(thread, bl))) continue;
            linkedList.add(string);
        }
        Object[] objectArray = new ThreadGroup[threadGroup.activeGroupCount()];
        threadGroup.enumerate((ThreadGroup[])objectArray, false);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            linkedList.addAll(Debug.getGroupInfo((ThreadGroup)objectArray[i], bl));
        }
        return linkedList;
    }

    private static String dumpStackTrace(Thread thread, boolean bl) {
        if (bl && thread.getState() != Thread.State.RUNNABLE) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
            if (bl) {
                if (stackTraceElement.toString().contains("java.lang.ref.Reference.waitForReferencePendingList")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("sun.nio.ch.EPoll.wait")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("sun.nio.ch.Net.poll")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("sun.nio.ch.Net.accept")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("sun.nio.ch.SocketDispatcher.read")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.net.SocketInputStream.socketRead0")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.lang.Thread.sleep")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.lang.Object.wait")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("sun.awt.windows.WToolkit.eventLoop")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("sun.misc.Unsafe.park")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.net.PlainSocketImpl.socketAccept")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.net.SocketOutputStream.socketWrite0(Native Method)")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.net.PlainDatagramSocketImpl.receive0")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.lang.Thread.getStackTrace")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.net.PlainSocketImpl.socketConnect")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("net.contentobjects.jnotify.linux.JNotify_linux.nativeNotifyLoop")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("de.dal33t.powerfolder.util.net.UDTSocket.recv")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("sun.nio.ch.ServerSocketChannelImpl.accept0")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.net.DualStackPlainSocketImpl.accept0")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("sun.nio.ch.WindowsSelectorImpl$SubSelector.poll0")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("sun.nio.ch.ServerSocketChannelImpl.accept")) {
                    return null;
                }
                if (stackTraceElement.toString().contains("java.net.TwoStacksPlainDatagramSocketImpl.receive0")) {
                    return null;
                }
            }
            stringBuilder.append("        " + stackTraceElement);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static String detailedObjectState0(Class<?> clazz, Object object) {
        Field[] fieldArray;
        if (clazz == Object.class) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Debug.detailedObjectState0(clazz.getSuperclass(), object));
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            stringBuilder.append("; [").append("Field: ").append(field.getName());
            stringBuilder.append(", toString: ");
            try {
                Object object2 = field.get(object);
                stringBuilder.append('(').append(object2).append(')');
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stringBuilder.append(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                stringBuilder.append(illegalAccessException);
            }
            stringBuilder.append(']');
            field.setAccessible(false);
        }
        return stringBuilder.toString();
    }

    public static String detailedObjectState(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Class: ").append(object.getClass().getName());
        stringBuilder.append(Debug.detailedObjectState0(object.getClass(), object));
        return stringBuilder.toString();
    }

    private static void showGroupInfo(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return;
        }
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray, false);
        log.fine("");
        log.fine(threadGroup + " ########################");
        for (Thread thread : threadArray) {
            if (thread == null) continue;
            log.fine("\"" + thread.getName() + "\" - Thread t@" + thread.hashCode());
            log.fine("   java.lang.Thread.State: " + thread.getState());
            Debug.dumpStackTrace(thread);
            log.fine("");
        }
        Object[] objectArray = new ThreadGroup[threadGroup.activeGroupCount()];
        threadGroup.enumerate((ThreadGroup[])objectArray, false);
        for (int i = 0; i < objectArray.length; ++i) {
            Debug.showGroupInfo((ThreadGroup)objectArray[i]);
        }
    }

    private static void dumpStackTrace(Thread thread) {
        for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
            log.fine("        " + stackTraceElement);
        }
    }

    private static class MyThreadLocal
    extends ThreadLocal<DateFormat> {
        private MyThreadLocal() {
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd-MM-yyyy HH:mm");
        }
    }
}

