/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import com.dd.plist.NSDictionary;
import com.dd.plist.PropertyListParser;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.FolderSettings;
import de.dal33t.powerfolder.message.ConfigurationLoadRequest;
import de.dal33t.powerfolder.util.Base64;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.apache.commons.cli.CommandLine;

public class ConfigurationLoader {
    private static final String INITIAL_STARTUP_CONFIG_FILENAME = "initial_startup.config";
    public static final String DEFAULT_CONFIG_NAME = "Default";
    public static final String DEFAULT_CONFIG_FILENAME = "Default.config";
    public static final String LDAP_CONFIG_NAME = "LDAP";
    public static final String RADIUS_CONFIG_NAME = "RADIUS";
    public static final String SHIBBOLETH_CONFIG_NAME = "Shibboleth";
    public static final String DEFAULT_PROPERTIES_URI = "/client_deployment/Default.config";
    private static final String PREFERENCES_PREFIX = "pref.";
    private static final int URL_CONNECT_TIMEOUT_SECONDS = 10;
    public static final String SUFFIX_OVERWRITE = ".overwrite";
    private static Logger LOG = Logger.getLogger(ConfigurationLoader.class.getName());

    private ConfigurationLoader() {
    }

    public static boolean overwriteConfigEntries(Properties properties) {
        boolean bl = Boolean.valueOf(ConfigurationEntry.CONFIG_OVERWRITE_VALUES.getDefaultValue());
        String string = properties.getProperty(ConfigurationEntry.CONFIG_OVERWRITE_VALUES.getConfigKey());
        try {
            bl = Boolean.parseBoolean(string);
        }
        catch (Exception exception) {
            LOG.warning("Unable to parse pre-config overwrite value. Problem value: " + string + ". Now using: " + bl + ". " + exception);
        }
        return bl;
    }

    private static boolean dropFolderSettings(Properties properties) {
        boolean bl = Boolean.valueOf(ConfigurationEntry.CONFIG_DROP_FOLDER_SETTINGS.getDefaultValue());
        String string = properties.getProperty(ConfigurationEntry.CONFIG_DROP_FOLDER_SETTINGS.getConfigKey());
        try {
            bl = Boolean.parseBoolean(string);
        }
        catch (Exception exception) {
            LOG.warning("Unable to parse pre-config drop folders settings value. Problem value: " + string + ". Now using: " + bl + ". " + exception);
        }
        return bl;
    }

    public static void processMessage(Controller controller, ConfigurationLoadRequest configurationLoadRequest) {
        Reject.ifNull(controller, "Controller");
        Reject.ifNull(configurationLoadRequest, "Message");
        try {
            LOG.info("Processing message: " + configurationLoadRequest);
            if (StringUtils.isBlank(configurationLoadRequest.getConfigURL())) {
                if (configurationLoadRequest.isKeyValue()) {
                    boolean bl = controller.getConfig().containsKey(configurationLoadRequest.getKey());
                    if (configurationLoadRequest.isOverwrite() == null || configurationLoadRequest.isOverwrite().booleanValue() || !bl && !configurationLoadRequest.isOverwrite().booleanValue()) {
                        if (configurationLoadRequest.getValue() == null) {
                            controller.getConfig().remove(configurationLoadRequest.getKey());
                        } else {
                            controller.getConfig().put(configurationLoadRequest.getKey(), configurationLoadRequest.getValue());
                        }
                        controller.saveConfig();
                        LOG.log(Level.INFO, "Update configuration " + configurationLoadRequest.getKey() + "=" + configurationLoadRequest.getValue());
                    }
                }
            } else {
                Properties properties = ConfigurationLoader.loadPreConfiguration(configurationLoadRequest.getConfigURL());
                if (properties != null) {
                    boolean bl = configurationLoadRequest.isOverwrite() != null ? configurationLoadRequest.isOverwrite() : ConfigurationLoader.overwriteConfigEntries(properties);
                    if (ConfigurationLoader.dropFolderSettings(properties)) {
                        Set<String> set = FolderSettings.loadEntryIds(controller.getConfig());
                        for (String string : set) {
                            FolderSettings.removeEntries(controller.getConfig(), string);
                        }
                    }
                    int n = ConfigurationLoader.merge(properties, controller.getConfig(), controller.getPreferences(), bl);
                    LOG.log(Level.FINE, "Loaded/Merged " + n + " config/prefs entries from: " + configurationLoadRequest.getConfigURL());
                    ConfigurationEntry.CONFIG_URL.setValue(controller, configurationLoadRequest.getConfigURL());
                    controller.saveConfig();
                } else {
                    LOG.log(Level.WARNING, "Unable to load config from " + configurationLoadRequest.getConfigURL());
                }
            }
            if (configurationLoadRequest.isRestartRequired() && controller.isStarted()) {
                controller.schedule(() -> controller.shutdownAndRequestRestart(), 10000L);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to reload configuration: " + configurationLoadRequest + ". " + iOException, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadAndMergeFromInstaller(Controller controller) {
        block35: {
            Object object;
            Path path = null;
            String string = System.getenv("WINDIR");
            if (StringUtils.isNotBlank(string)) {
                object = Paths.get(string, new String[0]).resolve("TEMP");
                path = object.resolve(INITIAL_STARTUP_CONFIG_FILENAME);
            }
            if ((path == null || Files.notExists(path, new LinkOption[0])) && Files.notExists(path = Paths.get((String)(object = System.getProperty("java.io.tmpdir")), new String[0]).resolve(INITIAL_STARTUP_CONFIG_FILENAME), new LinkOption[0])) {
                return false;
            }
            object = "";
            boolean bl = false;
            try {
                boolean bl2;
                block34: {
                    Object object2;
                    InputStream inputStream;
                    block32: {
                        boolean bl3;
                        block33: {
                            block30: {
                                boolean bl4;
                                block31: {
                                    inputStream = Files.newInputStream(path, new OpenOption[0]);
                                    try {
                                        Properties properties = new Properties();
                                        properties.load(inputStream);
                                        object = properties.getProperty(ConfigurationEntry.CONFIG_URL.getConfigKey());
                                        if (StringUtils.isBlank((String)object) && StringUtils.isNotBlank((String)(object2 = properties.getProperty(ConfigurationEntry.INSTALLER_FILENAME.getConfigKey())))) {
                                            object = PathUtils.decodeURLFromFilename((String)object2);
                                        }
                                        if (!StringUtils.isBlank((String)object)) break block30;
                                        bl4 = false;
                                        if (inputStream == null) break block31;
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            if (inputStream != null) {
                                                try {
                                                    inputStream.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        catch (Exception exception) {
                                            LOG.warning("Unable to read configuration " + path + " / " + (String)object + ". " + exception);
                                            break block35;
                                        }
                                    }
                                    inputStream.close();
                                }
                                return bl4;
                            }
                            object2 = ConfigurationLoader.loadPreConfiguration((String)object);
                            if (object2 != null) break block32;
                            bl3 = false;
                            if (inputStream == null) break block33;
                            inputStream.close();
                        }
                        return bl3;
                    }
                    int n = ConfigurationLoader.merge((Properties)object2, controller);
                    LOG.info("Startup " + n + " with server " + (String)object);
                    if (n > 0) {
                        ConfigurationEntry.CONFIG_URL.setValue(controller, (String)object);
                        controller.saveConfig();
                    }
                    bl = true;
                    bl2 = true;
                    if (inputStream == null) break block34;
                    inputStream.close();
                }
                return bl2;
            }
            finally {
                if (bl) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {
                        LOG.fine("Unable to deleted file " + path + ". " + iOException);
                    }
                }
            }
        }
        return false;
    }

    public static boolean loadAndMergeCLI(Controller controller) {
        CommandLine commandLine = controller.getCommandLine();
        if (commandLine == null) {
            return false;
        }
        String string = commandLine.getOptionValue("c");
        if (StringUtils.isNotBlank(string) && (string.startsWith("http:") || string.startsWith("https:"))) {
            return ConfigurationLoader.loadAndMergeURL(controller, string);
        }
        return false;
    }

    public static boolean loadAndMergeConfigURL(Controller controller) {
        return ConfigurationLoader.loadAndMergeURL(controller, ConfigurationEntry.CONFIG_URL.getValue(controller));
    }

    public static boolean loadAndMergeURL(Controller controller, String string) {
        Reject.ifNull(controller, "Controller is null");
        if (StringUtils.isBlank(string)) {
            return false;
        }
        String string2 = controller.getCLIUsername();
        char[] cArray = Util.toCharArray(controller.getCLIPassword());
        try {
            Properties properties = ConfigurationLoader.loadPreConfiguration(string, string2, cArray);
            boolean bl = ConfigurationLoader.overwriteConfigEntries(properties);
            if (ConfigurationLoader.dropFolderSettings(properties)) {
                Set<String> set = FolderSettings.loadEntryIds(controller.getConfig());
                for (String string3 : set) {
                    FolderSettings.removeEntries(controller.getConfig(), string3);
                }
            }
            int n = ConfigurationLoader.merge(properties, controller.getConfig(), controller.getPreferences(), bl);
            LOG.info("Loaded " + n + " config entries (overwrite? " + bl + ") from: " + string);
            if (n > 0) {
                controller.saveConfig();
            }
            return true;
        }
        catch (Exception exception) {
            LOG.warning("Unable to load config from server: " + string + ". " + exception);
            return false;
        }
    }

    public static boolean loadAndMergePList(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        if (OSUtil.isMacOS()) {
            return false;
        }
        try {
            String string = controller.getDistribution() != null ? controller.getDistribution().getBinaryName() : ConfigurationEntry.DIST_BINARY_NAME.getValue(controller);
            Properties properties = ConfigurationLoader.loadMacOSPlist(string);
            boolean bl = ConfigurationLoader.overwriteConfigEntries(properties);
            if (ConfigurationLoader.dropFolderSettings(properties)) {
                Set<String> set = FolderSettings.loadEntryIds(controller.getConfig());
                for (String string2 : set) {
                    FolderSettings.removeEntries(controller.getConfig(), string2);
                }
            }
            int n = ConfigurationLoader.mergeConfigs(properties, controller.getConfig(), bl);
            LOG.info("Loaded " + n + " config entries (overwrite? " + bl + ") from mac plist");
            if (n > 0) {
                controller.saveConfig();
            }
            return true;
        }
        catch (Exception exception) {
            LOG.warning("Unable to load config from mac plist. " + exception);
            return false;
        }
    }

    public static Properties loadPreConfiguration(String string) throws IOException {
        return ConfigurationLoader.loadPreConfiguration(string, null, null);
    }

    public static Properties loadPreConfiguration(String string, String string2, char[] cArray) throws IOException {
        Reject.ifBlank(string, "Server URL is blank");
        Object object = Util.removeLastSlashFromURI(string.replace("download_client", ""));
        if (!((String)object).startsWith("http")) {
            object = "http://" + (String)object;
        }
        if (!((String)object).endsWith(".config") && !((String)object).contains(DEFAULT_PROPERTIES_URI)) {
            object = (String)object + DEFAULT_PROPERTIES_URI;
        }
        return ConfigurationLoader.loadPreConfiguration(new URL(((String)object).replace(" ", "%20")), string2, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPreConfiguration(URL uRL, String string, char[] cArray) throws IOException {
        Object object;
        Object object2;
        Reject.ifNull(uRL, "URL is null");
        URLConnection uRLConnection = uRL.openConnection();
        if (StringUtils.isNotBlank(string)) {
            object2 = string + ":" + Util.toString(cArray);
            LoginUtil.clear(cArray);
            object = "Basic " + Base64.encodeBytes(((String)object2).getBytes("UTF-8"));
            uRLConnection.setRequestProperty("Authorization", (String)object);
        }
        uRLConnection.setConnectTimeout(10000);
        uRLConnection.setReadTimeout(10000);
        uRLConnection.connect();
        object2 = uRLConnection.getInputStream();
        try {
            object = ConfigurationLoader.loadPreConfiguration((InputStream)object2);
            return object;
        }
        finally {
            try {
                ((InputStream)object2).close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPreConfigFromClasspath(String string) throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException("File '" + string + "' not found in classpath");
        }
        try {
            Properties properties = ConfigurationLoader.loadPreConfiguration(inputStream);
            return properties;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int merge(Properties properties, Controller controller) {
        boolean bl = ConfigurationLoader.overwriteConfigEntries(properties);
        if (ConfigurationLoader.dropFolderSettings(properties)) {
            Set<String> set = FolderSettings.loadEntryIds(controller.getConfig());
            for (String string : set) {
                FolderSettings.removeEntries(controller.getConfig(), string);
            }
        }
        return ConfigurationLoader.merge(properties, controller.getConfig(), controller.getPreferences(), bl);
    }

    public static int merge(Properties properties, Properties properties2, Preferences preferences, boolean bl) {
        return ConfigurationLoader.mergeConfigs(properties, properties2, bl) + ConfigurationLoader.mergePreferences(properties, preferences, bl);
    }

    public static int mergeConfigs(Properties properties, Properties properties2, boolean bl) {
        Reject.ifNull(properties, "PreConfig is null");
        Reject.ifNull(properties2, "TargetConfig is null");
        int n = 0;
        for (Object object : properties.keySet()) {
            Object object2;
            String string = (String)object;
            String string2 = properties.getProperty(string);
            if (string.endsWith(SUFFIX_OVERWRITE)) continue;
            boolean bl2 = bl;
            try {
                object2 = properties.getProperty(string + SUFFIX_OVERWRITE);
                if (StringUtils.isNotBlank((String)object2)) {
                    bl2 = Boolean.valueOf((String)object2);
                }
            }
            catch (RuntimeException runtimeException) {
                LOG.warning("Unable to parse entry '" + string + ".overwrite': " + runtimeException);
            }
            if (properties2.containsKey(string) && !bl2) continue;
            object2 = properties2.setProperty(string, string2);
            if (!string.startsWith(PREFERENCES_PREFIX) && !string2.equals(object2)) {
                ++n;
            }
            LOG.finer("Preconfigured " + string + "=" + string2);
        }
        if (n > 0) {
            LOG.fine(n + " default configurations set");
        } else {
            LOG.finer("No additional default configurations set");
        }
        return n;
    }

    public static int mergePreferences(Properties properties, Preferences preferences, boolean bl) {
        Reject.ifNull(properties, "PreConfig is null");
        Reject.ifNull(preferences, "TargetPreferences is null");
        int n = 0;
        for (Object object : properties.keySet()) {
            String string = (String)object;
            String string2 = properties.getProperty(string);
            if (!string.startsWith(PREFERENCES_PREFIX) || string.endsWith(SUFFIX_OVERWRITE)) continue;
            string = string.substring(PREFERENCES_PREFIX.length(), string.length());
            boolean bl2 = "-XXWEIRED-DEFAULT-VALUE".equals(preferences.get(string, "-XXWEIRED-DEFAULT-VALUE"));
            boolean bl3 = bl;
            try {
                String string3 = properties.getProperty(string + SUFFIX_OVERWRITE);
                if (StringUtils.isNotBlank(string3)) {
                    bl3 = Boolean.valueOf(string3);
                }
            }
            catch (RuntimeException runtimeException) {
                LOG.warning("Unable to parse entry '" + string + ".overwrite': " + runtimeException);
            }
            if (!bl2 && !bl3) continue;
            preferences.put(string, string2);
            ++n;
            LOG.finer("Preconfigured " + string + "=" + string2);
        }
        if (n > 0) {
            LOG.fine(n + " default preferences set");
        } else {
            LOG.finer("No additional default preferences set");
        }
        return n;
    }

    private static Properties loadPreConfiguration(InputStream inputStream) throws IOException {
        Reject.ifNull(inputStream, "Unable to load Preconfiguration. Input stream is null");
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    private static Properties loadMacOSPlist(String string) throws Exception {
        Reject.ifBlank(string, "Domain is blank");
        String string2 = "de.dal33t.powerfolder." + string;
        Properties properties = new Properties();
        String string3 = System.getProperty("user.home") + "/Library/Preferences/" + string2 + ".plist";
        Properties properties2 = ConfigurationLoader.loadPlistFile(string3);
        properties.putAll((Map<?, ?>)properties2);
        LOG.info("Loaded " + properties2.size() + " entries from user plist: " + string3);
        String string4 = "/Library/Preferences/" + string2 + ".plist";
        Properties properties3 = ConfigurationLoader.loadPlistFile(string4);
        properties.putAll((Map<?, ?>)properties3);
        LOG.info("Loaded " + properties3.size() + " entries from system plist: " + string4);
        LOG.info("Total combined plist entries loaded: " + properties.size());
        return properties;
    }

    private static Properties loadPlistFile(String string) throws Exception {
        File file = new File(string);
        Properties properties = new Properties();
        if (!file.exists()) {
            LOG.fine("Plist file not found: " + string);
            return properties;
        }
        NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse(file);
        for (String string2 : nSDictionary.allKeys()) {
            String string3 = nSDictionary.objectForKey(string2).toString();
            properties.setProperty(string2, string3);
            LOG.finer("Plist key=" + string2 + ", value=" + string3);
        }
        return properties;
    }
}

