/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.ExtendedProperties;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.Translation;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class CleanupTranslationFiles {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String[] RETRANSLATE = new String[0];
    private static final String headerText = "#\n# PowerFolder translation file\n#\n# Guide:\n# Missing translations are marked with ## in front of the line\n# You just need to translate the english text behind the =\n# Then remove the ## in front of the line.\n#\n# Original English texts for existing translations are\n# indicated with a proceeding #orig#.\n# Please check if the meaning is still the same.\n#\n# To translate the texts in the right encoding please use\n# the Properties Editor from this URL:\n# http://propedit.sourceforge.jp/index_en.html\n#\n# GUIDE: Launch the program twice, one with the english file opened and the other\n# with the file in your language. Enable \"show line number\" in the View menu\n# and lineup the 2 programs next to each other.\n# Select UTF-8 radiobutton when opening a\n# file with Properties editor\n#\n# When you are completed please send your translation file to\n# development@powerfolder.com\n#\n# Thank you,\n# Your PowerFolder Team\n# http://www.powerfolder.com\n#";
    private static final String baseName = "src/etc/Translation";
    private static final String outputName = "src/etc/Translation";
    private Properties originals;
    private boolean deep = true;

    public void run() throws IOException {
        Object object;
        HashSet<String> hashSet;
        this.originals = this.loadTranslationFile("src/etc/Translation.properties");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Object object3 : this.originals.keySet()) {
            String object22 = (String)object3;
            arrayList.add(object22);
            if (object22.startsWith("transfer_mode.")) continue;
            arrayList2.add(object22);
        }
        Collections.sort(arrayList);
        if (this.deep) {
            Object object3;
            hashSet = new HashSet<String>();
            this.findContent(arrayList2, Paths.get("src/main", new String[0]), hashSet);
            this.findContent(arrayList2, Paths.get("../PF-PRO/src/pro", new String[0]), hashSet);
            this.findContent(arrayList2, Paths.get("../PF-PRO/src/server", new String[0]), hashSet);
            System.out.println("Found " + hashSet.size() + "/" + arrayList.size() + ". " + (arrayList.size() - hashSet.size()) + " unused translations. Removing: ");
            object3 = new HashSet<String>(arrayList2);
            object3.removeAll(hashSet);
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                object = (String)iterator.next();
                System.out.println((String)object);
                if (arrayList.remove(object) || (bl = arrayList.remove((String)object + ".key") || arrayList.remove((String)object + ".label") || arrayList.remove((String)object + ".description"))) continue;
                System.err.println("Unable to remove " + (String)object);
            }
        }
        hashSet = Translation.getSupportedLocales();
        for (Locale locale : hashSet) {
            if (locale.getLanguage().equals("en")) continue;
            object = this.loadTranslationFile("src/etc/Translation_" + locale.getLanguage() + ".properties");
            this.writeTranslationFile(locale.getLanguage(), arrayList, (Properties)object);
        }
        this.writeTranslationFile(null, arrayList, this.originals);
        System.out.println("Streamlined " + this.originals.size() + " translations. " + (hashSet.size() - 1) + " Translation files");
    }

    private void writeTranslationFile(String string, List<String> list, Properties properties) throws IOException {
        FileOutputStream fileOutputStream;
        boolean bl;
        Object object = string;
        if (object == null) {
            object = "";
            bl = true;
        } else {
            object = "_" + (String)object;
            bl = false;
        }
        try {
            fileOutputStream = new FileOutputStream("src/etc/Translation" + (String)object + ".properties");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(fileOutputStream), "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        String string2 = null;
        bufferedWriter.write(headerText);
        bufferedWriter.newLine();
        int n = 0;
        for (String string3 : list) {
            String string4;
            int n2;
            boolean bl2;
            String string5 = properties.getProperty(string3);
            String string6 = this.originals.getProperty(string3);
            if (Arrays.asList(RETRANSLATE).contains(string3)) {
                string5 = null;
            }
            boolean bl3 = bl2 = string5 != null;
            if (string5 == null) {
                string5 = string6;
            }
            if ((n2 = string3.indexOf(46)) >= 0) {
                string4 = string3.substring(0, n2);
            } else {
                string4 = string3;
                System.err.println("Check translation key: " + string3);
            }
            try {
                if (!string4.equals(string2)) {
                    bufferedWriter.newLine();
                }
                if (!bl2 && !bl) {
                    bufferedWriter.write("##");
                    ++n;
                }
                bufferedWriter.write(this.saveConvert(string3, true) + "=" + this.saveConvert(string5, false));
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            string2 = string4;
        }
        try {
            bufferedWriter.flush();
            bufferedWriter.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        System.out.println("Result for " + (String)object + ": " + n + " missing translations.");
    }

    private void findContent(Collection<String> collection, Path path, Collection<String> collection2) throws FileNotFoundException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path path) {
                    return Files.isDirectory(path, new LinkOption[0]) || path.getFileName().toString().endsWith("java");
                }
            };
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
                for (Path path2 : directoryStream) {
                    this.findContent(collection, path2, collection2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                byte[] byArray = StreamUtils.readIntoByteArray(inputStream);
                String string = new String(byArray, Convert.UTF8);
                for (String string2 : collection) {
                    int n;
                    String string3;
                    if (string.contains(string2)) {
                        collection2.add(string2);
                    }
                    if (!string2.endsWith(".key") && !string2.endsWith(".name") && !string2.endsWith(".description") || !string.contains(string3 = string2.substring(0, n = string2.lastIndexOf(".")))) continue;
                    collection2.add(string2);
                }
                System.out.println(path.toAbsolutePath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Properties loadTranslationFile(String string) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        try {
            extendedProperties.load(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.print(string);
            try {
                System.err.println(": Creating new translation file");
                Files.createFile(Paths.get(string, new String[0]), new FileAttribute[0]);
                return extendedProperties;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            System.err.println(string);
            iOException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(string);
            illegalArgumentException.printStackTrace();
        }
        return extendedProperties;
    }

    private String saveConvert(String string, boolean bl) {
        int n = string.length();
        int n2 = n * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(CleanupTranslationFiles.toHex(c >> 12 & 0xF));
                        stringBuffer.append(CleanupTranslationFiles.toHex(c >> 8 & 0xF));
                        stringBuffer.append(CleanupTranslationFiles.toHex(c >> 4 & 0xF));
                        stringBuffer.append(CleanupTranslationFiles.toHex(c & 0xF));
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    public static void main(String[] stringArray) throws IOException {
        CleanupTranslationFiles cleanupTranslationFiles = new CleanupTranslationFiles();
        cleanupTranslationFiles.run();
    }
}

