/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

public class AntiSerializationVulnerability {
    private static final String[] BLOCKED_CLASSES = new String[]{"org.apache.commons.collections.functors.InvokerTransformer", "org.apache.commons.collections.functors.ChainedTransformer", "org.apache.commons.collections.functors.ConstantTransformer", "org.apache.commons.collections.functors.InstantiateTransformer"};
    private static final String[] BLACKLIST = new String[]{"org.apache.commons.fileupload.FileUpload", "org.apache.commons.fileupload.FileUploadBase", "org.apache.commons.fileupload.disk.DiskFileItem", "com.mchange.v2.c3p0.", "org.hibernate."};
    private static final String[] WHITELIST = new String[]{"de.dal33t.powerfolder.message.", "de.dal33t.powerfolder.light.", "de.dal33t.powerfolder.util.delta.", "de.dal33t.powerfolder.util.compare.", "de.dal33t.powerfolder.security.", "de.dal33t.powerfolder.clientserver.", "de.dal33t.powerfolder.domain.", "de.dal33t.powerfolder.Encryption", "de.dal33t.powerfolder.disk.Lock", "de.dal33t.powerfolder.disk.SyncProfile", "de.dal33t.powerfolder.os.OnlineStorageSubscriptionType", "org.hibernate.cache.", "org.hibernate.EntityMode", "org.hibernate.type.", "org.hibernate.TransactionException", "org.hibernate.util.ComparableComparator", "org.hibernate.collection.PersistentBag", "org.hibernate.exception.GenericJDBCException", "org.hibernate.exception.JDBCConnectionException", "org.hibernate.JDBCException", "org.hibernate.HibernateException", "java.lang.", "java.util.", "java.io.File", "java.sql.", "java.net.", "java.io.IOException", "java.security.", "sun.util.calendar.", "sun.util.BuddhistCalendar", "java.sql.", "boolean", "byte", "short", "int", "long", "float", "double", "char", "[B", "[[B", "[I", "[J", "[L", "[Z", "[C"};

    private AntiSerializationVulnerability() {
    }

    public static void checkClasspath() {
        for (int i = 0; i < BLOCKED_CLASSES.length; ++i) {
            String string = BLOCKED_CLASSES[i];
            try {
                Class.forName(string);
                String string2 = "Found potential vulnerable class " + string + ". Please remove it from classpath.";
                System.err.println(string2);
                System.exit(99);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static boolean isWhitelisted(String string) {
        for (String string2 : WHITELIST) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlacklisted(String string) {
        if (AntiSerializationVulnerability.isWhitelisted(string)) {
            return false;
        }
        for (String string2 : BLACKLIST) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

