/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.NodesSelectDialog2;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.SwingWorkerPanel;
import de.dal33t.powerfolder.util.InvitationUtil;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.compare.MemberComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jwf.WizardPanel;

public class SendInvitationsPanel
extends PFWizardPanel {
    private static final Logger LOG = Logger.getLogger(SendInvitationsPanel.class.getName());
    private FolderInfo folderInfo;
    private JButtonMini addButton;
    private JButtonMini searchButton;
    private JButtonMini removeButton;
    private JTextField viaPowerFolderText;
    private JLabel invalidEmail;
    private JList<String> inviteesList;
    private JScrollPane inviteesListScrollPane;
    private DefaultListModel<String> inviteesListModel;
    private JPanel removeButtonPanel;
    private DefaultComboBoxModel<String> permissionsComboModel;
    private JComboBox<String> permissionsCombo;

    SendInvitationsPanel(Controller controller) {
        super(controller);
    }

    /*
     * WARNING - void declaration
     */
    private boolean sendInvitation() {
        Serializable serializable;
        this.invalidEmail.setVisible(false);
        boolean bl = false;
        Set<Member> set = this.getCandidates();
        String string = (String)this.permissionsComboModel.getSelectedItem();
        FolderPermission object2 = FolderPermission.readWrite(this.folderInfo);
        if (string != null) {
            FolderAdminPermission folderAdminPermission;
            FolderReadPermission object = FolderPermission.read(this.folderInfo);
            if (((FolderPermission)object).getName().equals(string)) {
                object2 = object;
            }
            if (((FolderPermission)(serializable = FolderPermission.readWrite(this.folderInfo))).getName().equals(string)) {
                object2 = serializable;
            }
            if (((FolderPermission)(folderAdminPermission = FolderPermission.admin(this.folderInfo))).getName().equals(string)) {
                object2 = folderAdminPermission;
            }
        }
        if (this.viaPowerFolderText.getText().length() > 0) {
            void var5_8;
            String string2 = this.viaPowerFolderText.getText();
            if (string2.contains("<") && string2.contains(">")) {
                String string3 = string2.substring(string2.indexOf("<") + 1, string2.indexOf(">")).trim();
            }
            if (!LoginUtil.isValidUsername(this.getController(), (String)var5_8)) {
                this.invalidEmail.setVisible(true);
                return false;
            }
            serializable = this.folderInfo.getFolder(this.getController()).createInvitation(object2);
            this.sendInvite(set, (String)var5_8, (Invitation)serializable);
            bl = true;
        }
        for (Object object : this.inviteesListModel.toArray()) {
            Invitation invitation = this.folderInfo.getFolder(this.getController()).createInvitation(object2);
            String string4 = (String)object;
            this.sendInvite(set, string4, invitation);
            bl = true;
        }
        return bl;
    }

    private void sendInvite(Collection<Member> collection, String string, Invitation invitation) {
        Reject.ifBlank(string, "Invitee");
        RuntimeException runtimeException = null;
        string = string.trim().toLowerCase();
        try {
            invitation.setRecipient(string);
            this.getController().getOSClient().getFolderService(invitation.folder).sendInvitation(invitation, false);
        }
        catch (RuntimeException runtimeException2) {
            LOG.log(Level.SEVERE, "Unable to send invitation to " + string + ". " + runtimeException2, runtimeException2);
            runtimeException = runtimeException2;
        }
        for (Member member : collection) {
            AccountInfo accountInfo = member.getAccountInfo();
            if (accountInfo == null || accountInfo.getDisplayName() == null || !accountInfo.getDisplayName().equalsIgnoreCase(string)) continue;
            InvitationUtil.invitationToNode(this.getController(), invitation, member);
        }
        for (Member member : collection) {
            if (!string.equalsIgnoreCase(member.getNick())) continue;
            InvitationUtil.invitationToNode(this.getController(), invitation, member);
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.inviteesListModel.isEmpty() || this.viaPowerFolderText.getText().length() > 0;
    }

    @Override
    public WizardPanel next() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!SendInvitationsPanel.this.sendInvitation()) {
                    throw new RuntimeException(Translation.get("wizard.send_invitations.no_invitees", LoginUtil.getUsernameText(SendInvitationsPanel.this.getController())));
                }
            }
        };
        WizardPanel wizardPanel = (WizardPanel)this.getWizardContext().getAttribute("successpanel");
        return new SwingWorkerPanel(this.getController(), runnable, Translation.get("wizard.send_invitations.sending_invites"), Translation.get("wizard.send_invitations.sending_invites.text"), wizardPanel);
    }

    @Override
    protected JPanel buildContent() {
        FormDebugPanel formDebugPanel = new FormDebugPanel();
        formDebugPanel.setGridColor(Color.GREEN);
        FormDebugPanel formDebugPanel2 = new FormDebugPanel();
        formDebugPanel2.setGridColor(Color.BLUE);
        FormLayout formLayout = new FormLayout("pref, 80dlu, 3dlu, pref, pref, 10dlu, pref:grow", "pref, 10dlu, pref, 3dlu, pref, max(10dlu;pref), min(10dlu;pref), pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout2 = new FormLayout("pref:grow, pref, 3dlu", "pref");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2);
        panelBuilder2.addLabel(Translation.get("send_invitations.folder_label"), cellConstraints.xy(2, 1));
        int n = 1;
        panelBuilder.addLabel(this.folderInfo.getName(), cellConstraints.xy(2, n));
        JPanel jPanel = panelBuilder2.getPanel();
        jPanel.setOpaque(false);
        panelBuilder.add((Component)jPanel, cellConstraints.xy(1, n));
        FormLayout formLayout3 = new FormLayout("pref:grow, pref, 3dlu", "pref");
        PanelBuilder panelBuilder3 = new PanelBuilder(formLayout3);
        panelBuilder3.addLabel(LoginUtil.getInviteUsernameLabel(this.getController()), cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.viaPowerFolderText, cellConstraints.xy(2, n += 2));
        panelBuilder.add((Component)this.addButton, cellConstraints.xy(4, n));
        panelBuilder.add((Component)this.invalidEmail, cellConstraints.xy(7, n));
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue() && PreferencesEntry.SHOW_DEVICES.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)this.searchButton, cellConstraints.xy(5, n));
        }
        JPanel jPanel2 = panelBuilder3.getPanel();
        jPanel2.setOpaque(false);
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(1, n));
        this.inviteesListScrollPane = new JScrollPane(this.inviteesList);
        this.inviteesListScrollPane.setPreferredSize(new Dimension(this.getPreferredSize().width, Sizes.dialogUnitYAsPixel(40, this.inviteesListScrollPane)));
        panelBuilder.add((Component)this.inviteesListScrollPane, cellConstraints.xy(2, n += 2));
        this.inviteesListScrollPane.setVisible(false);
        ++n;
        FormLayout formLayout4 = new FormLayout("pref, pref, pref", "pref");
        PanelBuilder panelBuilder4 = new PanelBuilder(formLayout4);
        panelBuilder4.add((Component)this.removeButton, cellConstraints.xy(1, 1));
        this.removeButtonPanel = panelBuilder4.getPanel();
        this.removeButtonPanel.setOpaque(false);
        panelBuilder.add((Component)this.removeButtonPanel, cellConstraints.xy(2, n));
        this.removeButtonPanel.setVisible(false);
        FormLayout formLayout5 = new FormLayout("pref:grow, pref, 3dlu", "pref");
        PanelBuilder panelBuilder5 = new PanelBuilder(formLayout5);
        panelBuilder5.add((Component)new JLabel(Translation.get("send_invitations.permissions_label")), cellConstraints.xy(1, 1));
        panelBuilder.add(this.permissionsCombo, cellConstraints.xy(2, n += 2));
        panelBuilder.add((Component)panelBuilder5.getPanel(), cellConstraints.xy(1, n));
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        this.folderInfo = (FolderInfo)this.getWizardContext().getAttribute("disklocation.folder_info");
        Reject.ifNull(this.folderInfo, "Unable to send invitation, folder is null");
        this.getWizardContext().setAttribute("disklocation.folder_info", null);
        this.addButton = new JButtonMini(new MyAddAction(this.getController()));
        this.removeButton = new JButtonMini(new MyRemoveAction(this.getController()));
        this.searchButton = new JButtonMini(new MySearchAction(this.getController()));
        this.viaPowerFolderText = new JTextField();
        this.viaPowerFolderText.addKeyListener(new MyKeyListener());
        this.invalidEmail = new JLabel("<html><font color='red'>" + Translation.get("wizard.send_invitations.invalid_email", LoginUtil.getUsernameText(this.getController())) + "</font></html>");
        this.invalidEmail.setVisible(false);
        this.inviteesListModel = new DefaultListModel();
        this.inviteesList = new JList<String>(this.inviteesListModel);
        this.inviteesList.getSelectionModel().setSelectionMode(0);
        this.inviteesList.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
        this.permissionsComboModel = new DefaultComboBoxModel();
        this.permissionsCombo = new JComboBox<String>(this.permissionsComboModel);
        this.permissionsComboModel.addElement(FolderPermission.readWrite(this.folderInfo).getName());
        this.permissionsComboModel.addElement(FolderPermission.read(this.folderInfo).getName());
        if (ConfigurationEntry.SECURITY_PERMISSIONS_SHOW_FOLDER_ADMIN.getValueBoolean(this.getController()).booleanValue()) {
            this.permissionsComboModel.addElement(FolderPermission.admin(this.folderInfo).getName());
        }
        this.enableAddButton();
        this.enableRemoveButton();
    }

    private Set<Member> getCandidates() {
        if (!PreferencesEntry.SHOW_DEVICES.getValueBoolean(this.getController()).booleanValue()) {
            Collections.emptySet();
        }
        TreeSet<Member> treeSet = new TreeSet<Member>(MemberComparator.NICK);
        Collections.addAll(treeSet, this.getController().getNodeManager().getFriends());
        for (Member member : this.getController().getNodeManager().getConnectedNodes()) {
            if (!member.isOnLAN()) continue;
            treeSet.add(member);
        }
        return treeSet;
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.send_invitations.title");
    }

    private void enableAddButton() {
        this.addButton.setEnabled(this.viaPowerFolderText.getText().length() > 0);
    }

    private void enableRemoveButton() {
        this.removeButton.setEnabled(!this.inviteesListModel.isEmpty() && this.inviteesList.getSelectedIndex() >= 0);
    }

    private void processInvitee() {
        this.invalidEmail.setVisible(false);
        String string = this.viaPowerFolderText.getText();
        if (string.length() > 0) {
            if (string.contains("<") && string.contains(">")) {
                string = string.substring(string.indexOf("<") + 1, string.indexOf(">")).trim();
            }
            if (LoginUtil.isValidUsername(this.getController(), string)) {
                this.inviteesListModel.addElement(string);
                this.inviteesListScrollPane.setVisible(true);
                this.removeButtonPanel.setVisible(true);
                this.viaPowerFolderText.setText("");
                this.updateButtons();
                this.enableAddButton();
                this.enableRemoveButton();
            } else {
                this.invalidEmail.setVisible(true);
            }
        }
    }

    private class MyAddAction
    extends BaseAction {
        MyAddAction(Controller controller) {
            super("action_add_invitee", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SendInvitationsPanel.this.processInvitee();
        }
    }

    private class MyRemoveAction
    extends BaseAction {
        MyRemoveAction(Controller controller) {
            super("action_remove_invitee", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = SendInvitationsPanel.this.inviteesList.getSelectedIndex();
            if (n >= 0) {
                SendInvitationsPanel.this.inviteesListModel.remove(n);
                SendInvitationsPanel.this.inviteesListScrollPane.setVisible(!SendInvitationsPanel.this.inviteesListModel.isEmpty());
                SendInvitationsPanel.this.removeButtonPanel.setVisible(!SendInvitationsPanel.this.inviteesListModel.isEmpty());
                SendInvitationsPanel.this.enableRemoveButton();
            }
        }
    }

    private class MySearchAction
    extends BaseAction {
        MySearchAction(Controller controller) {
            super("action_search_invitee", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ArrayList<Member> arrayList = new ArrayList<Member>();
            NodesSelectDialog2 nodesSelectDialog2 = new NodesSelectDialog2(this.getController(), arrayList);
            nodesSelectDialog2.open();
            for (Member member : arrayList) {
                boolean bl = false;
                for (Object object : SendInvitationsPanel.this.inviteesListModel.toArray()) {
                    String string = (String)object;
                    if (!member.getNick().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                SendInvitationsPanel.this.inviteesListModel.addElement(member.getNick());
                SendInvitationsPanel.this.inviteesListScrollPane.setVisible(true);
                SendInvitationsPanel.this.removeButtonPanel.setVisible(true);
            }
            SendInvitationsPanel.this.updateButtons();
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            SendInvitationsPanel.this.updateButtons();
            SendInvitationsPanel.this.enableAddButton();
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SendInvitationsPanel.this.enableRemoveButton();
            SendInvitationsPanel.this.updateButtons();
        }
    }
}

