/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.widget;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.widget.JButton3Icons;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class FilterTextField {
    private int columns;
    private String hint;
    private JPanel panel;
    private JTextField textField;
    private JButton clearTextJButton;
    private JLabel spacerIcon;
    private JLabel glassIcon;
    private ValueModel externalValueModel;
    private ValueModel localValueModel;
    private String tooltip;
    private boolean focus;
    private JPopupMenu contextMenu;

    public FilterTextField(int n, String string, String string2) {
        this.columns = n;
        this.hint = string;
        this.tooltip = string2;
        this.localValueModel = new ValueHolder();
        this.externalValueModel = new ValueHolder();
    }

    public ValueModel getValueModel() {
        return this.externalValueModel;
    }

    public JPanel getUIComponent() {
        if (this.panel == null) {
            this.initComponents();
            FormLayout formLayout = new FormLayout("pref, 1dlu, pref:grow, 15dlu", "pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add((Component)this.glassIcon, cellConstraints.xy(1, 1));
            panelBuilder.add((Component)this.textField, cellConstraints.xy(3, 1));
            panelBuilder.add((Component)this.clearTextJButton, cellConstraints.xy(4, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
            panelBuilder.add((Component)this.spacerIcon, cellConstraints.xy(4, 1));
            panelBuilder.setBorder(new EtchedBorder());
            this.panel = panelBuilder.getPanel();
            this.panel.setBackground(Color.white);
        }
        return this.panel;
    }

    private void initComponents() {
        this.textField = BasicComponentFactory.createTextField(this.localValueModel, false);
        this.textField.setColumns(this.columns);
        this.textField.setBorder(null);
        this.textField.setPreferredSize(new Dimension(17, 17));
        if (this.tooltip != null && this.tooltip.length() > 0) {
            this.textField.setToolTipText(this.tooltip);
        }
        this.spacerIcon = SimpleComponentFactory.createLabel(Icons.getIconById("blank.icon"));
        this.spacerIcon.setVisible(false);
        this.clearTextJButton = new JButton3Icons(Icons.getIconById("filter_text_field_clear_button_normal.icon"), Icons.getIconById("filter_text_field_clear_button_hover.icon"), Icons.getIconById("filter_text_field_clear_button_push.icon"));
        this.clearTextJButton.setVisible(false);
        this.clearTextJButton.setToolTipText(Translation.get("filter_text_field.clear.hint"));
        this.clearTextJButton.setContentAreaFilled(false);
        this.clearTextJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterTextField.this.textField.setText("");
                FilterTextField.this.externalValueModel.setValue("");
                FilterTextField.this.textField.requestFocus();
            }
        });
        this.glassIcon = SimpleComponentFactory.createLabel(Icons.getIconById("filter_text_field_glass.icon"));
        this.localValueModel.addValueChangeListener(new MyPropertyChangeListener());
        MyFocusListener myFocusListener = new MyFocusListener();
        this.clearTextJButton.addFocusListener(myFocusListener);
        this.textField.addFocusListener(myFocusListener);
        this.setHint();
    }

    private void setHint() {
        if (!this.hasExternalText()) {
            this.textField.setForeground(Color.lightGray);
            this.textField.setText(this.hint);
        }
    }

    private void clearHint() {
        if (!this.hasExternalText()) {
            this.textField.setText("");
            this.textField.setForeground(SystemColor.textText);
        }
    }

    private boolean hasExternalText() {
        return this.externalValueModel.getValue() != null && ((CharSequence)this.externalValueModel.getValue()).length() > 0;
    }

    public JPopupMenu createPopupMenu() {
        if (this.contextMenu == null) {
            this.contextMenu = new JPopupMenu();
            this.contextMenu.add(new JMenuItem("todo"));
        }
        return this.contextMenu;
    }

    public void requestFocus() {
        this.textField.requestFocusInWindow();
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (FilterTextField.this.focus) {
                FilterTextField.this.externalValueModel.setValue(FilterTextField.this.localValueModel.getValue());
            }
            boolean bl = FilterTextField.this.hasExternalText();
            FilterTextField.this.clearTextJButton.setVisible(bl);
            FilterTextField.this.spacerIcon.setVisible(!bl);
        }
    }

    private class MyFocusListener
    extends FocusAdapter {
        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.doFocusChange();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.doFocusChange();
        }

        private void doFocusChange() {
            FilterTextField.this.focus = FilterTextField.this.clearTextJButton.hasFocus() || FilterTextField.this.textField.hasFocus();
            if (FilterTextField.this.focus) {
                FilterTextField.this.clearHint();
            } else {
                FilterTextField.this.setHint();
            }
        }
    }
}

