/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.util.Translation;
import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.util.TimerTask;
import javax.swing.Icon;

public class SyncIconButtonMini
extends JButtonMini {
    private static final long ROTATION_STEP_DELAY = 200L;
    private int angle = 0;
    private volatile boolean spin;
    private static final Icon ICON_ZERO = Icons.getIconById(Icons.SYNC_ANIMATION[0]);

    public SyncIconButtonMini(Controller controller) {
        super(ICON_ZERO, Translation.get("sync_icon_button_mini.tip"));
        controller.scheduleAndRepeat(new MyUpdateTask(this), 200L);
    }

    private void rotate() {
        if (!this.spin) {
            if (!this.getIcon().equals(ICON_ZERO)) {
                this.setIcon(ICON_ZERO);
            }
            return;
        }
        ++this.angle;
        if (this.angle >= Icons.SYNC_ANIMATION.length) {
            this.angle = 0;
        }
        Icon icon = Icons.getIconById(Icons.SYNC_ANIMATION[this.angle]);
        this.setIcon(icon);
    }

    public void spin(boolean bl) {
        this.spin = bl;
    }

    private static class MyUpdateTask
    extends TimerTask {
        private WeakReference<SyncIconButtonMini> buttonReference;

        private MyUpdateTask(SyncIconButtonMini syncIconButtonMini) {
            this.buttonReference = new WeakReference<SyncIconButtonMini>(syncIconButtonMini);
        }

        @Override
        public void run() {
            final SyncIconButtonMini syncIconButtonMini = (SyncIconButtonMini)this.buttonReference.get();
            if (syncIconButtonMini == null) {
                this.cancel();
                return;
            }
            if (syncIconButtonMini.isVisible() && syncIconButtonMini.isShowing()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (syncIconButtonMini.isVisible() && syncIconButtonMini.isShowing()) {
                            syncIconButtonMini.rotate();
                        }
                    }
                });
            }
        }
    }
}

