/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.model;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.event.TransferManagerEvent;
import de.dal33t.powerfolder.event.TransferManagerListener;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.Upload;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.information.downloads.DownloadManagersTableModel;
import de.dal33t.powerfolder.ui.information.uploads.UploadsTableModel;
import de.dal33t.powerfolder.ui.util.DelayedUpdater;
import de.dal33t.powerfolder.ui.util.UIUtil;

public class TransferManagerModel
extends PFUIComponent {
    private TransferManager transferManager;
    private DownloadManagersTableModel downloadManagersTableModel;
    private UploadsTableModel uploadsTableModel;
    private final ValueModel allDownloadsCountVM = new ValueHolder();
    private final ValueModel allUploadsCountVM = new ValueHolder();
    private final ValueModel activeUploadsCountVM = new ValueHolder();
    private final ValueModel activeDownloadsCountVM = new ValueHolder();
    private final ValueModel completedUploadsCountVM = new ValueHolder();
    private final ValueModel completedDownloadsCountVM = new ValueHolder();
    private DelayedUpdater downloadsValueModelUpdater;
    private DelayedUpdater uploadsValueModelUpdater;

    public TransferManagerModel(TransferManager transferManager) {
        super(transferManager.getController());
        this.transferManager = transferManager;
        this.downloadsValueModelUpdater = new DelayedUpdater(this.getController());
        this.uploadsValueModelUpdater = new DelayedUpdater(this.getController());
        this.downloadManagersTableModel = new DownloadManagersTableModel(this);
        this.uploadsTableModel = new UploadsTableModel(this);
    }

    public void initialize() {
        this.transferManager.addListener(new MyTransferManagerListener());
        try {
            UIUtil.invokeAndWaitInEDT(new Runnable(){

                @Override
                public void run() {
                    TransferManagerModel.this.uploadsTableModel.initialize();
                    TransferManagerModel.this.downloadManagersTableModel.initialize();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        this.updateDownloadsValueModels0();
        this.updateUploadsValueModels0();
    }

    public TransferManager getTransferManager() {
        return this.getController().getTransferManager();
    }

    public DownloadManagersTableModel getDownloadsTableModel() {
        return this.downloadManagersTableModel;
    }

    public UploadsTableModel getUploadsTableModel() {
        return this.uploadsTableModel;
    }

    public int countCompletedDownloads(Folder folder) {
        int n = this.downloadManagersTableModel.getRowCount();
        int n2 = 0;
        FolderRepository folderRepository = this.getController().getFolderRepository();
        for (int i = 0; i < n; ++i) {
            DownloadManager downloadManager = this.downloadManagersTableModel.getDownloadManagerAtRow(i);
            Folder folder2 = downloadManager.getFileInfo().getFolder(folderRepository);
            if (folder2 == null || !downloadManager.isCompleted() || !folder2.equals(folder)) continue;
            ++n2;
        }
        return n2;
    }

    public int countCompletedDownloads() {
        int n = this.downloadManagersTableModel.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DownloadManager downloadManager = this.downloadManagersTableModel.getDownloadManagerAtRow(i);
            if (!downloadManager.isCompleted()) continue;
            ++n2;
        }
        return n2;
    }

    public int countActiveDownloads() {
        int n = this.downloadManagersTableModel.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            DownloadManager downloadManager = this.downloadManagersTableModel.getDownloadManagerAtRow(i);
            if (!downloadManager.isStarted()) continue;
            ++n2;
        }
        return n2;
    }

    public int countTotalDownloads() {
        return this.downloadManagersTableModel.getRowCount();
    }

    public ValueModel getActiveUploadsCountVM() {
        return this.activeUploadsCountVM;
    }

    public ValueModel getActiveDownloadsCountVM() {
        return this.activeDownloadsCountVM;
    }

    public ValueModel getAllDownloadsCountVM() {
        return this.allDownloadsCountVM;
    }

    public ValueModel getAllUploadsCountVM() {
        return this.allUploadsCountVM;
    }

    public ValueModel getCompletedUploadsCountVM() {
        return this.completedUploadsCountVM;
    }

    public ValueModel getCompletedDownloadsCountVM() {
        return this.completedDownloadsCountVM;
    }

    private void updateDownloadsValueModels() {
        this.downloadsValueModelUpdater.schedule(new Runnable(){

            @Override
            public void run() {
                TransferManagerModel.this.updateDownloadsValueModels0();
            }
        });
    }

    private void updateDownloadsValueModels0() {
        int n = this.getTransferManager().countCompletedDownloads();
        int n2 = this.getTransferManager().countActiveDownloads();
        int n3 = n + n2;
        this.allDownloadsCountVM.setValue(n3);
        this.activeDownloadsCountVM.setValue(n2);
        this.completedDownloadsCountVM.setValue(n);
    }

    private void updateUploadsValueModels() {
        this.uploadsValueModelUpdater.schedule(new Runnable(){

            @Override
            public void run() {
                TransferManagerModel.this.updateUploadsValueModels0();
            }
        });
    }

    private void updateUploadsValueModels0() {
        int n = this.uploadsTableModel.getRowCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            Upload upload = this.uploadsTableModel.getUploadAtRow(i);
            if (upload.isStarted() && !upload.isCompleted() && !upload.isBroken() && !upload.isAborted()) {
                ++n2;
            } else if (upload.isCompleted()) {
                ++n4;
            }
            ++n3;
        }
        this.allUploadsCountVM.setValue(n3);
        this.activeUploadsCountVM.setValue(n2);
        this.completedUploadsCountVM.setValue(n4);
    }

    private class MyTransferManagerListener
    implements TransferManagerListener {
        private MyTransferManagerListener() {
        }

        @Override
        public void downloadRequested(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateDownloadsValueModels();
        }

        @Override
        public void downloadQueued(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateDownloadsValueModels();
        }

        @Override
        public void downloadStarted(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateDownloadsValueModels();
        }

        @Override
        public void downloadAborted(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateDownloadsValueModels();
        }

        @Override
        public void downloadBroken(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateDownloadsValueModels();
        }

        @Override
        public void downloadCompleted(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateDownloadsValueModels();
        }

        @Override
        public void completedDownloadRemoved(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateDownloadsValueModels();
        }

        @Override
        public void pendingDownloadEnqueued(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateUploadsValueModels();
        }

        @Override
        public void uploadRequested(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateUploadsValueModels();
        }

        @Override
        public void uploadStarted(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateUploadsValueModels();
        }

        @Override
        public void uploadAborted(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateUploadsValueModels();
        }

        @Override
        public void uploadBroken(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateUploadsValueModels();
        }

        @Override
        public void uploadCompleted(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateUploadsValueModels();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void completedUploadRemoved(TransferManagerEvent transferManagerEvent) {
            TransferManagerModel.this.updateUploadsValueModels();
        }
    }
}

