/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.model;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Reject;

public abstract class BoundPermission
extends PFComponent {
    private ServerClientListener listener;
    private Permission permission;
    private boolean hasPermission;

    public BoundPermission(Controller controller, Permission permission) {
        super(controller);
        Reject.ifNull(permission, "Permission");
        this.permission = permission;
        this.listener = new MyServerClientListener();
        this.getController().getOSClient().addWeakListener(this.listener);
        this.getController().schedule(() -> this.checkPermission(true), 0L);
    }

    public Permission getPermission() {
        return this.permission;
    }

    public abstract void hasPermission(boolean var1);

    private synchronized void checkPermission(boolean bl) {
        boolean bl2;
        if (!ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()).booleanValue()) {
            return;
        }
        boolean bl3 = this.hasPermission;
        this.hasPermission = this.getController().getOSClient().getAccount().hasPermission(this.permission);
        boolean bl4 = bl2 = this.hasPermission != bl3;
        if (bl2 || bl) {
            final boolean bl5 = this.hasPermission;
            UIUtil.invokeLaterInEDT(new Runnable(){

                @Override
                public void run() {
                    BoundPermission.this.hasPermission(bl5);
                }
            });
        }
    }

    public void dispose() {
        this.getController().getOSClient().removeListener(this.listener);
    }

    public String toString() {
        return "BoundPermission [permission=" + this.permission + "]";
    }

    private final class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            BoundPermission.this.getController().schedule(() -> BoundPermission.this.checkPermission(false), 0L);
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            BoundPermission.this.getController().schedule(() -> BoundPermission.this.checkPermission(false), 0L);
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
        }
    }
}

