/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.uploads;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.transfer.Transfer;
import de.dal33t.powerfolder.ui.information.uploads.UploadsTableModel;
import de.dal33t.powerfolder.ui.model.TransferManagerModel;
import de.dal33t.powerfolder.ui.render.SortedTableHeaderRenderer;
import de.dal33t.powerfolder.ui.render.UploadTableCellRenderer;
import de.dal33t.powerfolder.ui.util.Icons;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class UploadsTable
extends JTable {
    public UploadsTable(TransferManagerModel transferManagerModel) {
        super(transferManagerModel.getUploadsTableModel());
        this.setRowHeight(Icons.getIconById("node_friend_connected.icon").getIconHeight() + 3);
        this.setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        UploadTableCellRenderer uploadTableCellRenderer = new UploadTableCellRenderer(transferManagerModel.getController());
        this.setDefaultRenderer(FileInfo.class, uploadTableCellRenderer);
        this.setDefaultRenderer(FolderInfo.class, uploadTableCellRenderer);
        this.setDefaultRenderer(Transfer.class, uploadTableCellRenderer);
        this.setDefaultRenderer(Member.class, uploadTableCellRenderer);
        this.setDefaultRenderer(Long.class, uploadTableCellRenderer);
        this.setupColumns();
        SortedTableHeaderRenderer.associateHeaderRenderer(transferManagerModel.getUploadsTableModel(), this.getColumnModel(), 2, true);
    }

    private void setupColumns() {
        int n = this.getWidth();
        this.getTableHeader().setPreferredSize(new Dimension(n, 20));
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        tableColumn.setPreferredWidth(20);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn = this.getColumn(this.getColumnName(1));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.getColumn(this.getColumnName(2));
        tableColumn.setPreferredWidth(80);
        tableColumn = this.getColumn(this.getColumnName(3));
        tableColumn.setPreferredWidth(20);
        tableColumn = this.getColumn(this.getColumnName(4));
        tableColumn.setPreferredWidth(20);
        tableColumn = this.getColumn(this.getColumnName(5));
        tableColumn.setPreferredWidth(40);
    }

    private class MyDisplayabilityListener
    implements HierarchyListener {
        private MyDisplayabilityListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 2L) == 2L) {
                boolean bl = hierarchyEvent.getChanged().isShowing();
                UploadsTableModel uploadsTableModel = (UploadsTableModel)UploadsTable.this.getModel();
                uploadsTableModel.setPeriodicUpdate(bl);
            }
        }
    }
}

