/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.members;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.information.folder.members.MembersSimpleTable;
import de.dal33t.powerfolder.ui.information.folder.members.MembersSimpleTableModel;
import de.dal33t.powerfolder.ui.information.folder.members.MembersTab;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MembersSimpleTab
extends PFUIComponent
implements MembersTab {
    private JPanel uiComponent;
    private MembersSimpleTableModel model = new MembersSimpleTableModel(this.getController());
    private JScrollPane scrollPane;
    private BaseAction inviteAction;
    private MembersSimpleTable membersTable;

    public MembersSimpleTab(Controller controller) {
        super(controller);
        this.model.sortBy(1);
    }

    @Override
    public void setFolderInfo(FolderInfo folderInfo) {
        this.model.setFolderInfo(folderInfo);
        this.inviteAction.allowWith(FolderPermission.admin(folderInfo));
    }

    @Override
    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    public void initialize() {
        this.inviteAction = new MyInviteAction();
        this.membersTable = new MembersSimpleTable(this.model);
        this.membersTable.getSelectionModel().setSelectionMode(0);
        this.membersTable.getSelectionModel().addListSelectionListener(new MySelectionListener());
        this.scrollPane = new JScrollPane(this.membersTable);
        UIUtil.whiteStripTable(this.membersTable);
        UIUtil.removeBorder(this.scrollPane);
        UIUtil.setZeroHeight(this.scrollPane);
        this.enableOnSelection();
        this.model.getRefreshingModel().addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                boolean bl2 = MembersSimpleTab.this.model.isPermissionsRetrieved();
                MembersSimpleTab.this.membersTable.cancelCellEditing();
                boolean bl3 = !bl && bl2;
                FolderInfo folderInfo = MembersSimpleTab.this.model.getFolderInfo();
                if (folderInfo != null) {
                    boolean bl4 = MembersSimpleTab.this.getController().getOSClient().getAccount().hasAdminPermission(folderInfo);
                    bl3 = bl3 && bl4;
                }
            }
        });
    }

    private void buildUIComponent() {
        FormLayout formLayout = new FormLayout("3dlu, fill:pref:grow, 3dlu", "3dlu, pref, 3dlu, pref , 3dlu, fill:0:grow, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.createToolBar(), cellConstraints.xy(2, 2));
        panelBuilder.addSeparator(null, cellConstraints.xyw(1, 4, 3));
        panelBuilder.add((Component)this.scrollPane, cellConstraints.xy(2, 6));
        this.uiComponent = panelBuilder.getPanel();
    }

    private JPanel createToolBar() {
        JButton jButton = new JButton(this.inviteAction);
        FormLayout formLayout = new FormLayout("0:grow", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.enableOnSelection();
        ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        if (ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            buttonBarBuilder.addGridded(jButton);
        }
        JPanel jPanel = buttonBarBuilder.getPanel();
        formLayout = new FormLayout("pref, 0:grow, pref", "pref");
        panelBuilder = new PanelBuilder(formLayout);
        cellConstraints = new CellConstraints();
        panelBuilder.add((Component)jPanel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)Help.createWikiLinkButton(this.getController(), "Security_Permissions"), cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private void enableOnSelection() {
    }

    private static JComboBox createdEditComboBox(SelectionInList<FolderPermission> selectionInList) {
        return BasicComponentFactory.createComboBox(selectionInList, new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof FolderPermission) {
                    this.setText(((FolderPermission)object).getName());
                } else {
                    this.setText(Translation.get("permissions.folder.no_access"));
                }
                return component;
            }
        });
    }

    private class MyInviteAction
    extends BaseAction {
        private MyInviteAction() {
            super("action_invite_friend", MembersSimpleTab.this.getController());
            this.setIcon(null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PFWizard.openSendInvitationWizard(this.getController(), MembersSimpleTab.this.model.getFolderInfo());
            MembersSimpleTab.this.model.refreshModel();
        }
    }

    private class MySelectionListener
    implements ListSelectionListener {
        private MySelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            MembersSimpleTab.this.enableOnSelection();
        }
    }
}

