/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files.versions;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.ui.information.folder.files.versions.FileInfoVersionTypeHolder;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.compare.FileInfoVersionTypeComparator;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class FileVersionsTableModel
extends PFComponent
implements TableModel,
SortedTableModel {
    private String[] columns = new String[]{"", Translation.get("file_versions_table_model.date"), Translation.get("file_versions_table_model.version"), Translation.get("file_versions_table_model.size")};
    private final List<FileInfoVersionTypeHolder> versionInfos = new ArrayList<FileInfoVersionTypeHolder>();
    private int comparatorType = -1;
    private boolean sortAscending = true;
    private int sortColumn;
    private final List<TableModelListener> listeners = new CopyOnWriteArrayList<TableModelListener>();

    public FileVersionsTableModel(Controller controller) {
        super(controller);
    }

    public void setVersionInfos(List<FileInfoVersionTypeHolder> list) {
        boolean bl = true;
        if (this.versionInfos.size() == list.size()) {
            for (FileInfoVersionTypeHolder fileInfoVersionTypeHolder : list) {
                boolean bl2 = false;
                for (FileInfoVersionTypeHolder fileInfoVersionTypeHolder2 : this.versionInfos) {
                    if (!fileInfoVersionTypeHolder.getFileInfo().isVersionDateAndSizeIdentical(fileInfoVersionTypeHolder2.getFileInfo())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            this.versionInfos.clear();
            this.versionInfos.addAll(list);
            this.sort();
            this.fireModelChanged();
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return FileInfoVersionTypeHolder.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columns[n];
    }

    @Override
    public int getRowCount() {
        return this.versionInfos.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.versionInfos.get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new UnsupportedOperationException("Cannot modify FileVersionsTableModel");
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public boolean sortBy(int n) {
        this.sortColumn = n;
        switch (n) {
            case 0: {
                return this.sortMe(0);
            }
            case 1: {
                return this.sortMe(1);
            }
            case 2: {
                return this.sortMe(2);
            }
            case 3: {
                return this.sortMe(3);
            }
        }
        this.sortColumn = -1;
        return false;
    }

    public boolean sortMe(int n) {
        boolean bl;
        int n2 = this.comparatorType;
        this.comparatorType = n;
        if (n2 != n && (bl = this.sort())) {
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    private void fireModelChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        for (TableModelListener tableModelListener : this.listeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sort() {
        if (this.comparatorType != -1) {
            FileInfoVersionTypeComparator fileInfoVersionTypeComparator = FileInfoVersionTypeComparator.getComparator(this.comparatorType);
            List<FileInfoVersionTypeHolder> list = this.versionInfos;
            synchronized (list) {
                if (this.sortAscending) {
                    Collections.sort(this.versionInfos, fileInfoVersionTypeComparator);
                } else {
                    Collections.sort(this.versionInfos, new ReverseComparator<FileInfoVersionTypeHolder>(fileInfoVersionTypeComparator));
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseList() {
        this.sortAscending = !this.sortAscending;
        List<FileInfoVersionTypeHolder> list = this.versionInfos;
        synchronized (list) {
            Collections.reverse(this.versionInfos);
        }
        this.fireModelChanged();
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }
}

