/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files.versions;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.FolderService;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.FileArchiver;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.information.folder.files.versions.FileInfoVersionTypeHolder;
import de.dal33t.powerfolder.ui.information.folder.files.versions.FileVersionsTable;
import de.dal33t.powerfolder.ui.information.folder.files.versions.FileVersionsTableModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileVersionsPanel
extends PFUIComponent {
    private static final int STATE_EMPTY = 0;
    private static final int STATE_LOADING = 1;
    private static final int STATE_RESULTS = 2;
    private JPanel panel;
    private JLabel emptyLabel;
    private JScrollPane scrollPane;
    private FileVersionsTableModel fileVersionsTableModel;
    private FileVersionsTable fileVersionsTable;
    private volatile FileInfo fileInfo;
    private RestoreAction restoreAction;
    private JPanel currentVersionPanel;
    private JPopupMenu popupMenu;
    private JLabel currentVersionLabel;
    private JLabel currentSizeLabel;
    private JLabel currentDateLabel;

    public FileVersionsPanel(Controller controller) {
        super(controller);
    }

    public Component getPanel() {
        if (this.panel == null) {
            this.initComponents();
            this.scrollPane = new JScrollPane(this.fileVersionsTable);
            FormLayout formLayout = new FormLayout("pref:grow", "pref, 3dlu, pref, 3dlu, fill:0:grow");
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            defaultFormBuilder.add(this.createButtonPanel(), cellConstraints.xy(1, 1));
            defaultFormBuilder.addSeparator(null, cellConstraints.xy(1, 3));
            defaultFormBuilder.add((Component)this.emptyLabel, cellConstraints.xy(1, 5));
            defaultFormBuilder.add((Component)this.scrollPane, cellConstraints.xy(1, 5));
            this.panel = defaultFormBuilder.getPanel();
            this.buildPopupMenus();
            this.setState(0);
        }
        return this.panel;
    }

    private Component createButtonPanel() {
        FormLayout formLayout = new FormLayout("pref, fill:0:grow, pref", "pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)new JButton(this.restoreAction), cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.currentVersionPanel, cellConstraints.xy(3, 1, CellConstraints.DEFAULT, CellConstraints.BOTTOM));
        return defaultFormBuilder.getPanel();
    }

    private void buildPopupMenus() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.restoreAction);
    }

    private void initComponents() {
        this.fileVersionsTableModel = new FileVersionsTableModel(this.getController());
        this.fileVersionsTable = new FileVersionsTable(this.fileVersionsTableModel);
        this.fileVersionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FileVersionsPanel.this.enableRestoreAction();
            }
        });
        this.fileVersionsTable.addMouseListener(new TableMouseListener());
        this.emptyLabel = new JLabel(Translation.get("file_version_tab.no_versions_available"), 0);
        this.emptyLabel.setEnabled(false);
        this.restoreAction = new RestoreAction(this.getController());
        this.currentVersionLabel = new JLabel();
        this.currentSizeLabel = new JLabel();
        this.currentDateLabel = new JLabel();
        this.currentVersionPanel = this.createCurrentVersionPanel();
        this.currentVersionPanel.setVisible(false);
    }

    private JPanel createCurrentVersionPanel() {
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, fill:0:grow", "pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.currentVersionLabel, cellConstraints.xy(1, 1));
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setPreferredSize(new Dimension(2, 12));
        defaultFormBuilder.add((Component)jSeparator, cellConstraints.xy(3, 1));
        defaultFormBuilder.add((Component)this.currentSizeLabel, cellConstraints.xy(5, 1));
        JSeparator jSeparator2 = new JSeparator(1);
        jSeparator2.setPreferredSize(new Dimension(2, 12));
        defaultFormBuilder.add((Component)jSeparator2, cellConstraints.xy(7, 1));
        defaultFormBuilder.add((Component)this.currentDateLabel, cellConstraints.xy(9, 1));
        return defaultFormBuilder.getPanel();
    }

    public void setFileInfo(FileInfo fileInfo) {
        if (this.panel == null) {
            return;
        }
        if (this.fileInfo == fileInfo) {
            return;
        }
        this.fileInfo = fileInfo;
        if (fileInfo == null) {
            this.setState(0);
            this.currentVersionPanel.setVisible(false);
            return;
        }
        this.restoreAction.allowWith(FolderPermission.get(fileInfo.getFolderInfo(), AccessMode.READ_WRITE));
        this.currentVersionLabel.setText(Translation.get("file_version_tab.current_version", String.valueOf(fileInfo.getVersion())));
        this.currentSizeLabel.setText(Translation.get("file_version_tab.size", Format.formatBytesShort(fileInfo.getSize())));
        this.currentDateLabel.setText(Translation.get("file_version_tab.date", Format.formatDateShort(fileInfo.getModifiedDate())));
        this.currentVersionPanel.setVisible(true);
        Folder folder = fileInfo.getFolder(this.getController().getFolderRepository());
        if (folder == null) {
            return;
        }
        this.getController().getThreadPool().execute(() -> {
            this.setState(1);
            try {
                FolderService folderService;
                ServerClient serverClient;
                FileArchiver fileArchiver = folder.getFileArchiver();
                ArrayList<FileInfoVersionTypeHolder> arrayList = new ArrayList<FileInfoVersionTypeHolder>();
                for (FileInfo object2 : fileArchiver.getArchivedFilesInfos(fileInfo)) {
                    arrayList.add(new FileInfoVersionTypeHolder(object2, false));
                }
                this.logFine("Local versions " + arrayList.size());
                boolean bl = folder.hasMember(this.getController().getOSClient().getServer());
                if (bl && (serverClient = this.getController().getOSClient()) != null && serverClient.isConnected() && serverClient.isLoggedIn() && (folderService = serverClient.getFolderService(folder.getInfo())) != null) {
                    List<FileInfo> list = folderService.getArchivedFilesInfos(fileInfo);
                    this.logFine("Online versions " + list.size());
                    for (FileInfo fileInfo2 : list) {
                        boolean bl2 = false;
                        for (FileInfoVersionTypeHolder fileInfoVersionTypeHolder : arrayList) {
                            if (!fileInfo2.isVersionDateAndSizeIdentical(fileInfoVersionTypeHolder.getFileInfo())) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        arrayList.add(new FileInfoVersionTypeHolder(fileInfo2, true));
                    }
                    this.logFine("Consolidated versions " + arrayList.size());
                }
                if (arrayList.isEmpty()) {
                    this.setState(0);
                } else {
                    this.setState(2);
                    this.fileVersionsTableModel.setVersionInfos(arrayList);
                }
            }
            catch (Exception exception) {
                this.logWarning("Unabel to retrieve file versions for " + fileInfo.toDetailString() + "." + exception);
            }
        });
    }

    private void setState(final int n) {
        UIUtil.invokeLaterInEDT(new Runnable(){

            @Override
            public void run() {
                if (FileVersionsPanel.this.panel == null) {
                    return;
                }
                FileVersionsPanel.this.emptyLabel.setVisible(n != 2);
                FileVersionsPanel.this.scrollPane.setVisible(n == 2);
                if (n == 1) {
                    FileVersionsPanel.this.emptyLabel.setText("");
                } else if (n == 0) {
                    FileVersionsPanel.this.emptyLabel.setText(Translation.get("file_version_tab.no_versions_available"));
                }
                FileVersionsPanel.this.enableRestoreAction();
            }
        });
    }

    private void enableRestoreAction() {
        this.restoreAction.setEnabled(this.scrollPane.isVisible() && this.fileVersionsTable.getSelectedRow() > -1);
    }

    private void restoreFile() {
        if (this.fileInfo != null) {
            FileInfoVersionTypeHolder fileInfoVersionTypeHolder = this.fileVersionsTable.getSelectedInfo();
            PFWizard.openSingleFileRestoreWizard(this.getController(), this.fileInfo.getFolder(this.getController().getFolderRepository()), this.fileInfo, fileInfoVersionTypeHolder.getFileInfo());
        }
    }

    private class RestoreAction
    extends BaseAction {
        RestoreAction(Controller controller) {
            super("action_restore_archive", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileVersionsPanel.this.restoreFile();
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            FileVersionsPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

