/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files.breadcrumb;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.information.folder.files.FilesTab;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FilesBreadcrumbPanel
extends PFUIComponent {
    private final FilesTab parent;
    private JPanel breadcrumbPanel;

    public FilesBreadcrumbPanel(Controller controller, FilesTab filesTab) {
        super(controller);
        this.parent = filesTab;
        this.breadcrumbPanel = new JPanel(new FlowLayout(0));
    }

    public JPanel getUiComponent() {
        return this.breadcrumbPanel;
    }

    public void setRoot(FolderInfo folderInfo) {
        this.rebuild(folderInfo, new String[0]);
    }

    public void setDirectory(FolderInfo folderInfo, DirectoryInfo directoryInfo) {
        String[] stringArray = directoryInfo.getRelativeName().split("/");
        this.rebuild(folderInfo, stringArray);
    }

    private void rebuild(FolderInfo folderInfo, String[] stringArray) {
        this.breadcrumbPanel.removeAll();
        AbstractAction abstractAction = new AbstractAction(folderInfo.getLocalizedName()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilesBreadcrumbPanel.this.parent.selectionChanged("");
            }
        };
        this.breadcrumbPanel.add(new ActionLabel(this.getController(), abstractAction).getUIComponent());
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string.length() <= 0) continue;
            this.breadcrumbPanel.add(new JLabel(">"));
            stringBuilder.append(string);
            final String string2 = stringBuilder.toString();
            AbstractAction abstractAction2 = new AbstractAction(string){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FilesBreadcrumbPanel.this.parent.selectionChanged(string2);
                }
            };
            this.breadcrumbPanel.add(new ActionLabel(this.getController(), abstractAction2).getUIComponent());
            stringBuilder.append('/');
        }
    }
}

