/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.information.folder.files.FilteredDirectory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class FilteredDirectoryModel {
    private final String rootFolderName;
    private String directoryRelativeName;
    private final Date ignoreDeletedBeforeDate;
    private final List<FileInfo> fileInfos = new ArrayList<FileInfo>();
    private final FilteredDirectory filteredDirectory;

    public FilteredDirectoryModel(String string, String string2, Date date) {
        this.rootFolderName = string;
        this.directoryRelativeName = string2;
        this.ignoreDeletedBeforeDate = date;
        this.filteredDirectory = new FilteredDirectory(string, "");
    }

    public String getRootFolderName() {
        return this.rootFolderName;
    }

    public void setDirectoryRelativeName(String string) {
        this.directoryRelativeName = string;
    }

    public String getDirectoryRelativeName() {
        return this.directoryRelativeName;
    }

    public List<FileInfo> getFileInfos() {
        return Collections.unmodifiableList(this.fileInfos);
    }

    public boolean addFileInfo(FileInfo fileInfo) {
        if (this.ignoreDeletedBeforeDate != null && fileInfo.isDeleted() && fileInfo.getModifiedDate().before(this.ignoreDeletedBeforeDate)) {
            return false;
        }
        this.fileInfos.add(fileInfo);
        return true;
    }

    public FilteredDirectory getFilteredDirectory() {
        return this.filteredDirectory;
    }
}

